/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Money;
import net.fexcraft.mod.fsmm.data.PlayerAccData;
import net.fexcraft.mod.fsmm.event.ATMEvent;
import net.fexcraft.mod.fsmm.event.AccountEvent;
import net.fexcraft.mod.fsmm.event.FsmmEvent;
import net.fexcraft.mod.fsmm.local.AtmBlock;
import net.fexcraft.mod.fsmm.local.FsmmCmd;
import net.fexcraft.mod.fsmm.local.MobileAtm;
import net.fexcraft.mod.fsmm.local.MoneyItem;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.FsmmUIKeys;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_4970;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSMM
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fsmm");
    public static DataManager CACHE;
    public static Config CONFIG;
    private boolean loaded;

    public void onInitialize() {
        CONFIG = new Config(new File(FabricLoader.getInstance().getConfigDir().toAbsolutePath().toFile(), "fsmm.json"));
        UniEntity.register((Appendable)new PlayerAccData(null));
        FCL.registerItem((String)"fsmm:mobile", prop -> new MobileAtm((class_1792.class_1793)prop));
        FCL.registerBlock((String)"fsmm:atm", prop -> new AtmBlock((class_4970.class_2251)prop));
        FsmmUIKeys.IS_ATM = (ply, pos) -> ((class_1297)ply.entity.direct()).method_37908().method_8320(new class_2338(pos.x, pos.y, pos.z)).method_26204() instanceof AtmBlock;
        FsmmUIKeys.register(this);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            LOGGER.info("Loading account of " + String.valueOf(handler.field_14140.method_5477()) + " || " + handler.field_14140.method_7334().getId().toString());
            Account account = DataManager.getAccount("player:" + handler.field_14140.method_7334().getId().toString(), false, true);
            if (Config.NOTIFY_BALANCE_ON_JOIN) {
                UniEntity ent = UniEntity.get((Object)handler.field_14140);
                ent.entity.send(Formatter.format((String)"&m&3Balance &r&7(in bank)&0: &a") + Config.getWorthAsString(account.getBalance()));
                ent.entity.send(Formatter.format((String)"&m&3Balance &r&7(in Inv0)&0: &a") + Config.getWorthAsString(ItemManager.countInInventory(handler.field_14140)));
            }
            if (account.lastAccessed() >= 0L) {
                account.setTemporary(false);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            LOGGER.info("Unloading account of " + String.valueOf(handler.field_14140.method_5477()) + " || " + handler.field_14140.method_7334().getId().toString());
            DataManager.unloadAccount("player", handler.field_14140.method_7334().getId().toString());
        });
        ServerWorldEvents.LOAD.register((server, level) -> {
            if (level != server.method_30002()) {
                return;
            }
            FSMM.loadDataManager();
            this.setup();
        });
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            if (level != server.method_30002()) {
                return;
            }
            FSMM.unloadDataManager();
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (this.loaded) {
                return;
            }
            DataManager.CURRENCY.values().forEach(val -> {
                JsonMap map = Config.MONEY_INIT_CACHE.get(val);
                if (map != null) {
                    ItemWrapper item = ItemWrapper.get((String)map.get("id").string_value());
                    val.loadstack(item, map);
                }
            });
            Config.MONEY_INIT_CACHE.clear();
            this.loaded = true;
        });
        CommandRegistrationCallback.EVENT.register((dis, con, lis) -> FsmmCmd.regCmd((CommandDispatcher<class_2168>)dis));
    }

    private void setup() {
        MoneyItem.sort();
        if (EnvInfo.DEV) {
            FsmmEvent.addListener(AccountEvent.BalanceUpdated.class, fe -> FSMM.log("bal-upd: " + fe.getOldBalance() + " -> " + fe.getNewBalance()));
        }
        FsmmEvent.addListener(ATMEvent.GatherAccounts.class, event -> {
            event.getAccountsList().add(new AccountPermission(event.getAccount(), true, true, true, true));
            if (((MinecraftServer)FCL.SERVER.get()).method_3724()) {
                event.getAccountsList().add(new AccountPermission(event.getBank().getAccount(), true, true, true, true));
            }
        });
        FsmmEvent.addListener(ATMEvent.SearchAccounts.class, event -> {
            if (event.getSearchedId().length() < Config.MIN_SEARCH_CHARS) {
                return;
            }
            if (!event.getSearchedType().equals("player")) {
                if (!FSMM.conAccPerm(event.getAccountsMap(), event.getSearchedType()) && DataManager.exists(event.getSearchedType(), event.getSearchedId())) {
                    FSMM.putAccPerm(event.getAccountsMap(), event.getSearchedType() + ":" + event.getSearchedId());
                }
                return;
            }
            for (Account account : DataManager.getAccountsOfType("player").values()) {
                if (!account.getId().contains(event.getSearchedId()) && !account.getName().contains(event.getSearchedId())) continue;
                event.getAccountsMap().put(account.getTypeAndId(), new AccountPermission(account));
            }
            Optional gp = ((MinecraftServer)FCL.SERVER.get()).method_3793().method_14515(event.getSearchedId());
            if (gp.isPresent() && new File(DataManager.ACCOUNT_DIR, "player/" + ((GameProfile)gp.get()).getId().toString() + ".json").exists()) {
                FSMM.putAccPerm(event.getAccountsMap(), "player:" + ((GameProfile)gp.get()).getId().toString());
            } else if (new File(DataManager.ACCOUNT_DIR, "player/" + event.getSearchedId() + ".json").exists()) {
                FSMM.putAccPerm(event.getAccountsMap(), "player:" + event.getSearchedId());
            }
        });
    }

    public static boolean isDataManagerLoaded() {
        return CACHE != null;
    }

    public static void log(Object obj) {
        LOGGER.info(String.valueOf(obj));
    }

    public static void loadDataManager() {
        if (FSMM.isDataManagerLoaded()) {
            return;
        }
        if (CACHE != null) {
            CACHE.saveAll();
            CACHE.clearAll();
        }
        CACHE = new DataManager(((MinecraftServer)FCL.SERVER.get()).method_3831().toAbsolutePath().toFile());
        CACHE.schedule();
    }

    public static void unloadDataManager() {
        if (CACHE != null) {
            CACHE.saveAll();
            CACHE.clearAll();
            CACHE = null;
        }
    }

    private static void putAccPerm(HashMap<String, AccountPermission> map, String id) {
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, new AccountPermission(id));
    }

    private static void putAccPermIn(HashMap<String, AccountPermission> map, String id) {
        map.put(id, new AccountPermission(id));
    }

    private static boolean conAccPerm(HashMap<String, AccountPermission> map, String type) {
        for (AccountPermission perm : map.values()) {
            if (!perm.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static void registerItem(Money money) {
        FCL.registerItem((String)money.getID().colon(), prop -> new MoneyItem((class_1792.class_1793)prop, money));
    }

    public static TagCW getTagfromJson(JsonMap map) {
        return null;
    }
}

