/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.data.Manageable;
import net.fexcraft.mod.fsmm.data.Removable;
import net.fexcraft.mod.fsmm.data.Transfer;
import net.fexcraft.mod.fsmm.event.AccountEvent;
import net.fexcraft.mod.fsmm.event.FsmmEvent;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.world.MessageSender;

public class Account
extends Removable
implements Manageable {
    private final IDL idtype;
    private String name;
    private Bank bank;
    private long balance;
    private JsonMap additionaldata;
    private CopyOnWriteArrayList<Transfer> transfers = new CopyOnWriteArrayList();

    public Account(JsonMap map, String def_type, String def_id) {
        this.idtype = IDLManager.getIDLCached((String)(map.getString("type", def_type) + ":" + map.getString("id", def_id)));
        this.bank = DataManager.getBank(map.getString("bank", Config.DEFAULT_BANK));
        this.balance = map.getLong("balance", 0L);
        this.additionaldata = map.has("data") ? map.getMap("data") : null;
        String string = this.name = map.has("name") ? map.get("name").string_value() : null;
        if (map.has("transfers")) {
            for (JsonValue elm : (List)map.getArray((String)"transfers").value) {
                this.transfers.add(new Transfer(elm.asMap()));
            }
        }
        this.updateLastAccess();
    }

    public Account(String id, String type, long bal, Bank bank_, JsonMap data) {
        this.idtype = IDLManager.getIDLCached((String)(type + ":" + id));
        this.balance = bal;
        this.bank = bank_;
        this.additionaldata = data;
        this.updateLastAccess();
    }

    public String getId() {
        return this.idtype.id();
    }

    public long getBalance() {
        return this.balance;
    }

    public long setBalance(long rpl) {
        FsmmEvent.run(new AccountEvent.BalanceUpdated(this, this.balance, rpl));
        this.updateLastAccess();
        this.balance = rpl;
        return this.balance;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank nbank) {
        this.updateLastAccess();
        this.bank = nbank;
    }

    public String getType() {
        return this.idtype.space();
    }

    public IDL getIDL() {
        return this.idtype;
    }

    public String getTypeAndId() {
        return this.idtype.colon();
    }

    public JsonMap getData() {
        return this.additionaldata;
    }

    public void setData(JsonMap obj) {
        this.updateLastAccess();
        this.additionaldata = obj;
    }

    public String getName() {
        return this.name == null ? this.idtype.id() : this.name;
    }

    public Account setName(String nname) {
        this.name = nname;
        return this;
    }

    public JsonMap toJson(boolean withtransfers) {
        this.updateLastAccess();
        JsonMap obj = new JsonMap();
        obj.add("id", this.idtype.id());
        obj.add("type", this.idtype.space());
        if (this.bank != null) {
            obj.add("bank", this.bank.id);
        } else {
            FSMM.log("Account '" + String.valueOf(this.idtype) + "' has no bank assigned.");
        }
        obj.add("balance", this.balance);
        if (this.additionaldata != null) {
            obj.add("data", (JsonValue)this.additionaldata);
        }
        if (this.name != null) {
            obj.add("name", this.name);
        }
        if (withtransfers) {
            JsonArray array = new JsonArray();
            for (Transfer transfer : this.transfers) {
                array.add((JsonValue)transfer.toJson());
            }
            if (array.size() > 0) {
                obj.add("transfers", (JsonValue)array);
            }
        }
        return obj;
    }

    @Override
    public JsonMap toJson() {
        return this.toJson(true);
    }

    @Override
    public void modifyBalance(Manageable.Action action, long amount, MessageSender log) {
        switch (action) {
            case SET: {
                FsmmEvent.run(new AccountEvent.BalanceUpdated(this, this.balance, amount));
                this.balance = amount;
                return;
            }
            case SUB: {
                if (this.balance - amount >= 0L) {
                    FsmmEvent.run(new AccountEvent.BalanceUpdated(this, this.balance, this.balance -= amount));
                } else {
                    log.send("Not enough money to subtract this amount! (B:" + this.balance / 1000L + " - S:" + amount / 1000L + ")");
                }
                return;
            }
            case ADD: {
                if (this.balance + amount >= Long.MAX_VALUE) {
                    log.send("Max Value reached.");
                    break;
                }
                FsmmEvent.run(new AccountEvent.BalanceUpdated(this, this.balance, this.balance += amount));
            }
        }
    }

    public void addTransfer(Transfer transfer) {
        this.transfers.add(0, transfer);
        while (this.transfers.size() > Config.TRANSFER_CACHE) {
            this.transfers.remove(Config.TRANSFER_CACHE);
        }
    }

    public List<Transfer> getTransfers() {
        return this.transfers;
    }
}

