/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.uni.tag.TagCW;

public class AccountPermission {
    public static final AccountPermission FULL = new AccountPermission((String)null, true, true, true, true);
    public final boolean withdraw;
    public final boolean transfer;
    public final boolean deposit;
    public final boolean manage;
    public final String accid;
    protected Account account;

    public AccountPermission(String aid, boolean wd, boolean dp, boolean tr, boolean mg) {
        this.accid = aid;
        this.withdraw = wd;
        this.deposit = dp;
        this.transfer = tr;
        this.manage = mg;
    }

    public AccountPermission(Account acc, boolean wd, boolean dp, boolean tr, boolean mg) {
        this(acc.getId(), wd, dp, tr, mg);
        this.account = acc;
    }

    public AccountPermission(String accid) {
        this(accid, false, false, false, false);
    }

    public AccountPermission(Account acc) {
        this(acc.getId());
        this.account = acc;
    }

    public AccountPermission(TagCW compound) {
        this.account = new Account(JsonHandler.parse((String)compound.getString("a"), (boolean)true).asMap(), null, null);
        this.accid = this.account.getId();
        this.withdraw = compound.getBoolean("w");
        this.deposit = compound.getBoolean("d");
        this.transfer = compound.getBoolean("t");
        this.manage = compound.getBoolean("m");
    }

    public Account getAccount() {
        if (this.account == null) {
            this.account = DataManager.getAccount(this.accid, true, true);
        }
        return this.account;
    }

    public TagCW toNBT() {
        TagCW com = TagCW.create();
        com.set("a", this.getAccount().toJson(false).toString());
        com.set("w", this.withdraw);
        com.set("d", this.deposit);
        com.set("t", this.transfer);
        com.set("m", this.manage);
        return com;
    }

    public String getType() {
        return this.account == null ? this.accid.split(":")[0] : this.account.getType();
    }

    public String getId() {
        return this.account == null ? this.accid.split(":")[1] : this.account.getId();
    }

    public String getTypeAndId() {
        return this.account == null ? this.accid : this.account.getTypeAndId();
    }
}

