/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Manageable;
import net.fexcraft.mod.fsmm.data.Transfer;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;

public class Bank
implements Manageable {
    public final String id;
    protected String name;
    protected Account account;
    private JsonMap additionaldata;
    protected TreeMap<String, String> fees;
    protected ArrayList<String> status = new ArrayList();

    public Bank(JsonMap map) {
        this.id = map.getString("uuid", map.getString("id", null));
        this.load(map);
    }

    public Bank(String bankid) {
        this.id = bankid;
    }

    public Bank(String id, String name, JsonMap data, TreeMap<String, String> map) {
        this.id = id;
        this.name = name;
        this.fees = map;
        this.additionaldata = data;
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String name) {
        boolean bl;
        if (this.name.equals(name)) {
            bl = false;
        } else {
            this.name = name;
            bl = this.name.equals(name);
        }
        return bl;
    }

    public long getBalance() {
        return this.account.getBalance();
    }

    public long setBalance(long rpl) {
        return this.account.setBalance(rpl);
    }

    public JsonMap getData() {
        return this.additionaldata;
    }

    public void setData(JsonMap obj) {
        this.additionaldata = obj;
    }

    public TreeMap<String, String> getFees() {
        return this.fees;
    }

    public boolean processAction(Action action, MessageSender log, Account sender, long amount, Account receiver, boolean included) {
        if (log == null) {
            log = UniFCL.LOG;
        }
        long fee = 0L;
        switch (action.ordinal()) {
            case 1: {
                if (sender == null) {
                    log.send("Withdraw failed! Account is null.");
                    FSMM.log(this.getName(log) + " -> player account is null.");
                    return false;
                }
                if (amount <= 0L) {
                    log.send("Withdraw failed! Amount is null or negative. (T:" + amount + " || B:" + sender.getBalance() + ");");
                    FSMM.log(this.getName(log) + " tried to withdraw a negative amount of money!");
                    return false;
                }
                EntityW player = (EntityW)log;
                if (this.fees != null) {
                    String feestr = this.fees.get(sender.getType() + ":self");
                    fee = Bank.parseFee(feestr, amount);
                }
                long total = amount + (included ? 0L : fee);
                if (sender.getBalance() - total >= 0L) {
                    sender.modifyBalance(Manageable.Action.SUB, total, log);
                    ItemManager.addToInventory(player, amount - (included ? fee : 0L));
                    this.log((MessageSender)player, action, amount, fee, total, included, sender, receiver);
                    DataManager.save(sender);
                    return true;
                }
                player.send("Withdraw failed! Not enough money. (W:" + amount + " || B:" + sender.getBalance() + ");");
                FSMM.log(sender.getTypeAndId() + " : Withdraw failed! Player does not have enough money. (T:" + amount + " || F:" + fee + ");");
                return false;
            }
            case 2: {
                if (receiver == null) {
                    log.send("Deposit failed! Account is null.");
                    FSMM.log(this.getName(log) + " -> player account is null.");
                    return false;
                }
                if (amount <= 0L) {
                    log.send("Deposit failed! Amount null or negative. (T:" + amount + " || I:" + ItemManager.countInInventory((EntityW)log) + ");");
                    FSMM.log(this.getName(log) + " tried to deposit a negative amount of money!");
                    return false;
                }
                EntityW player = (EntityW)log;
                if (receiver.getBalance() + amount <= Long.MAX_VALUE) {
                    fee = this.fees == null ? 0L : Bank.parseFee(this.fees.get("self:" + receiver.getType()), amount);
                    long total = amount + (included ? 0L : fee);
                    if (ItemManager.countInInventory(player) - total >= 0L) {
                        ItemManager.removeFromInventory(player, total);
                        receiver.modifyBalance(Manageable.Action.ADD, amount - (included ? fee : 0L), log);
                        this.log((MessageSender)player, action, amount, fee, total, included, sender, receiver);
                        DataManager.save(receiver);
                        return true;
                    }
                    player.send("Deposit failed! Not enough money in Inventory. (D:" + amount + " || B:" + receiver.getBalance() + ");");
                    FSMM.log(receiver.getTypeAndId() + ": Deposit failed! Not enough money in Inventory. (D:" + amount + " || B:" + receiver.getBalance() + ");");
                    return false;
                }
                player.send("Deposit failed! Result is above technical limit. (D:" + amount + " || B:" + receiver.getBalance() + ");");
                FSMM.log(receiver.getTypeAndId() + " : Deposit failed! Result is above technical limit. (D:" + amount + " || B:" + receiver.getBalance() + ");");
                return false;
            }
            case 0: {
                if (sender == null) {
                    log.send("Transfer failed! Sender is null.");
                    FSMM.log(this.getName(log) + " -> sender account is null.");
                    return false;
                }
                if (receiver == null) {
                    log.send("Transfer failed! Receiver is null.");
                    FSMM.log(this.getName(log) + " -> receiver account is null.");
                    return false;
                }
                if (amount <= 0L) {
                    log.send("Transfer failed! Amount is null or negative. (T:" + amount + ");");
                    FSMM.log(this.getName(log) + " tried to transfer a negative amount of money to " + receiver.getTypeAndId() + "!");
                    return false;
                }
                fee = this.fees == null ? 0L : Bank.parseFee(this.fees.get(sender.getType() + ":" + receiver.getType()), amount);
                long total = amount + (included ? 0L : fee);
                if (sender.getBalance() - total >= 0L) {
                    sender.modifyBalance(Manageable.Action.SUB, total, log);
                    receiver.modifyBalance(Manageable.Action.ADD, amount - (included ? fee : 0L), log);
                    this.log(null, action, amount, fee, total, included, sender, receiver);
                    DataManager.save(sender);
                    DataManager.save(receiver);
                    return true;
                }
                log.send("Transfer failed! Not enough money on sender Account.");
                FSMM.log(sender.getTypeAndId() + " -> " + sender.getTypeAndId() + " : Transfer failed! Sender doesn't have enough money. (T:" + amount + " || F:" + fee + ");");
                return false;
            }
        }
        log.send("Invalid Bank Action. " + action.name() + " || " + this.getName(log) + " || " + (sender == null ? "null" : sender.getTypeAndId()) + " || " + amount + " || " + (receiver == null ? "null" : receiver.getTypeAndId()));
        return false;
    }

    public boolean processAction(Action action, MessageSender log, Account sender, long amount, Account receiver) {
        return this.processAction(action, log, sender, amount, receiver, true);
    }

    public static long parseFee(String fee, long amount) {
        if (fee == null) {
            return 0L;
        }
        long result = 0L;
        if (fee.endsWith("%")) {
            float pc = Float.parseFloat(fee.replace("%", ""));
            if (pc < 0.0f) {
                return 0L;
            }
            if (pc > 100.0f) {
                pc = 100.0f;
            }
            result = (long)((float)(amount / 100L) * pc);
        } else {
            result = Long.parseLong(fee);
            result = result < 0L ? 0L : result;
        }
        return result;
    }

    public Account getAccount() {
        return this.account;
    }

    public void load(JsonMap map) {
        this.name = map.getString("name", "Unnamed Bank");
        JsonMap jsonMap = this.additionaldata = map.has("data") ? map.getMap("data") : null;
        if (map.has("fees")) {
            this.fees = new TreeMap();
            for (Map.Entry entry : map.getMap("fees").entries()) {
                this.fees.put((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value());
            }
        }
        if (map.has("status")) {
            ((List)map.getArray((String)"status").value).forEach(val -> this.status.add(val.string_value()));
        }
        this.account = DataManager.getAccount("bank:" + this.id, false, true);
        if (map.has("balance")) {
            this.account.setBalance(map.getLong("balance", 0L));
        }
        this.account.setName(this.name);
        this.account.setBank(this);
    }

    @Override
    public JsonMap toJson() {
        JsonMap map = new JsonMap();
        map.add("id", this.id);
        map.add("name", this.name);
        if (this.fees != null) {
            JsonMap of = new JsonMap();
            for (Map.Entry<String, String> entry : this.fees.entrySet()) {
                of.add(entry.getKey(), entry.getValue());
            }
            map.add("fees", (JsonValue)of);
        }
        if (this.additionaldata != null) {
            map.add("data", (JsonValue)this.additionaldata);
        }
        if (!this.status.isEmpty()) {
            JsonArray array = new JsonArray();
            for (String str : this.status) {
                array.add(str);
            }
            map.add("status", (JsonValue)array);
        }
        return map;
    }

    @Override
    public void modifyBalance(Manageable.Action action, long amount, MessageSender log) {
        this.account.modifyBalance(action, amount, log);
    }

    public ArrayList<String> getStatus() {
        return this.status;
    }

    public boolean hasFee(String fee_id) {
        return this.fees != null && this.fees.containsKey(fee_id);
    }

    private void log(MessageSender player, Action action, long amount, long fee, long total, boolean included, Account sender, Account receiver) {
        String r;
        String s;
        switch (action.ordinal()) {
            case 2: {
                s = sender.getTypeAndId();
                r = player.getName();
                sender.addTransfer(new Transfer(amount, fee, included, action, sender.getName(), sender));
                break;
            }
            case 1: {
                s = player.getName();
                r = receiver.getTypeAndId();
                sender.addTransfer(new Transfer(-amount, fee, included, action, sender.getName(), sender));
                break;
            }
            case 0: {
                s = sender.getTypeAndId();
                r = receiver.getTypeAndId();
                sender.addTransfer(new Transfer(-amount, fee, included, action, sender.getName(), receiver));
                receiver.addTransfer(new Transfer(amount, fee, included, action, sender.getName(), sender));
                break;
            }
            default: {
                s = "INVALID";
                r = "ACTION";
            }
        }
        String str = s + " -> [A: " + amount + "] + [F: " + fee + (included ? "i" : "e") + "] == [R: " + total + "] -> " + r;
        FSMM.log(str);
    }

    public String getName(MessageSender sender) {
        return sender == null ? "[NULL]" : sender.getName();
    }

    public static enum Action {
        TRANSFER,
        WITHDRAW,
        DEPOSIT;

    }
}

