/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;

public class PlayerAccData
implements Appendable<UniEntity> {
    private UniEntity player;
    private Account account;
    private AccountPermission atmacc;
    private Account selected;
    private Bank atmbank;

    public PlayerAccData(UniEntity unient) {
        this.player = unient;
    }

    public Account getAccount() {
        if (this.account == null) {
            this.account = DataManager.getAccount("player:" + this.player.entity.getUUID().toString(), false, true);
            this.account.setName(this.player.entity.getName());
        }
        return this.account;
    }

    public Bank getBank() {
        return this.getAccount().getBank();
    }

    public long getMoneyInInventory() {
        return ItemManager.countInInventory(this.player.entity);
    }

    public long subMoneyFromInventory(long expected_amount) {
        return ItemManager.removeFromInventory(this.player.entity, expected_amount);
    }

    public long addMoneyToInventory(long expected_amount) {
        return ItemManager.addToInventory(this.player.entity, expected_amount);
    }

    public long setMoneyInInventory(long expected_amount) {
        return ItemManager.setInInventory(this.player.entity, expected_amount);
    }

    public AccountPermission getSelectedAccount() {
        return this.atmacc;
    }

    public void setSelectedAccount(AccountPermission perm) {
        this.atmacc = perm;
    }

    public Account getSelectedReceiver() {
        return this.selected;
    }

    public void setSelectedReceiver(Account account) {
        this.selected = account;
    }

    public Bank getSelectedBankInATM() {
        return this.atmbank;
    }

    public void setSelectedBankInATM(Bank bank) {
        this.atmbank = bank;
    }

    public Object getPlayer() {
        return this.player.entity.direct();
    }

    public void save(UniEntity player, TagCW com) {
    }

    public void load(UniEntity player, TagCW com) {
    }

    public PlayerAccData create(UniEntity unient) {
        if (!unient.entity.isPlayer()) {
            return null;
        }
        return new PlayerAccData(unient);
    }

    public String id() {
        return "fsmm";
    }
}

