/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.local;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.data.PlayerAccData;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class FsmmCmd {
    public static final String PREFIX = "&0[&bFSMM&0]&7 ";

    public static void regCmd(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fsmm").then(class_2170.method_9247((String)"balance").executes(cmd -> {
            if (((class_2168)cmd.getSource()).method_43737()) {
                long value = ItemManager.countInInventory(((class_2168)cmd.getSource()).method_44023());
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bInventory&0: &a" + Config.getWorthAsString(value));
                PlayerAccData data = (PlayerAccData)UniEntity.get((Object)((class_2168)cmd.getSource()).method_44023()).getApp("fsmm");
                if (data.getSelectedAccount() != null && !data.getSelectedAccount().getTypeAndId().equals(data.getAccount().getTypeAndId())) {
                    AccountPermission perm = data.getSelectedAccount();
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bPersonal Balance&0: &a" + Config.getWorthAsString(data.getAccount().getBalance()));
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bSelected Account&0: &a" + data.getSelectedAccount().getTypeAndId());
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bSelected Balance&0: &a" + Config.getWorthAsString(data.getSelectedAccount().getAccount().getBalance()));
                } else {
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bAccount Balance&0: &a" + Config.getWorthAsString(data.getAccount().getBalance()));
                }
            } else {
                Bank bank = DataManager.getDefaultBank();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bDefault Bank Balance&0: &a" + Config.getWorthAsString(bank.getBalance()));
            }
            return 0;
        }))).then(class_2170.method_9247((String)"uuid").executes(cmd -> {
            ((class_2168)cmd.getSource()).method_45068((class_2561)class_2561.method_43470((String)((class_2168)cmd.getSource()).method_9207().method_7334().getId().toString()));
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(pre -> FsmmCmd.isOp(pre))).then(class_2170.method_9244((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process(((class_2168)cmd.getSource()).method_44023(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance(am);
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(pre -> FsmmCmd.isOp(pre))).then(class_2170.method_9244((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process(((class_2168)cmd.getSource()).method_44023(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance((am += account.getBalance()) < 0L ? 0L : am);
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sub").requires(pre -> FsmmCmd.isOp(pre))).then(class_2170.method_9244((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process(((class_2168)cmd.getSource()).method_44023(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance((am -= account.getBalance()) < 0L ? 0L : am);
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(pre -> FsmmCmd.isOp(pre))).then(class_2170.method_9244((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"acc-id", (ArgumentType)StringArgumentType.string()).executes(cmd -> {
            try {
                FsmmCmd.process(((class_2168)cmd.getSource()).method_44023(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bAccount&0: &7" + account.getTypeAndId());
                    FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bBalance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<class_2168>)cmd, "&o&7Account Holder is currently offline.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"status").requires(pre -> FsmmCmd.isOp(pre))).executes(cmd -> {
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bAccounts loaded (by type): &7");
            long temp = 0L;
            for (String str : DataManager.getAccountTypes()) {
                Map<String, Account> map = DataManager.getAccountsOfType(str);
                temp = map.values().stream().filter(pre -> pre.lastAccessed() >= 0L).count();
                FsmmCmd.chat((CommandContext<class_2168>)cmd, "&2> &b" + str + ": &7" + map.size() + (String)(temp > 0L ? " &8(&a" + temp + "temp.&8)" : ""));
            }
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bBanks active: &7" + DataManager.getBanks().size());
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&aLast scheduled unload: &r&7" + Time.getAsString((long)DataManager.LAST_TIMERTASK));
            return 0;
        }))).executes(cmd -> {
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&0[&bFSMM&0]&7 ============");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&bUser commands:");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm balance");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm uuid");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&dAdmin commands:");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm set <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm add <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm sub <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm info <type:id/name>");
            FsmmCmd.chat((CommandContext<class_2168>)cmd, "&7/fsmm status");
            return 0;
        }));
    }

    public static boolean isOp(class_2168 css) {
        if (css == null || !css.method_43737()) {
            return false;
        }
        if (((MinecraftServer)FCL.SERVER.get()).method_3724()) {
            return true;
        }
        return ((MinecraftServer)FCL.SERVER.get()).method_3760().method_14569(css.method_44023().method_7334());
    }

    private static void process(class_3222 sender, String type, String acc, BiConsumer<Account, Boolean> cons) {
        Account account;
        boolean online;
        class_2960 rs = class_2960.method_60655((String)type, (String)acc.toLowerCase());
        if (rs.method_12836().equals("player")) {
            try {
                UUID.fromString(rs.method_12832());
            }
            catch (Exception e) {
                Optional gp = ((MinecraftServer)FCL.SERVER.get()).method_3793().method_14515(rs.method_12832());
                rs = class_2960.method_60655((String)type, (String)((GameProfile)gp.get()).getId().toString());
            }
        }
        boolean bl = online = (account = DataManager.getAccount(rs.toString(), false, false)) != null;
        if (!online) {
            account = DataManager.getAccount(rs.toString(), true, false);
        }
        if (account == null) {
            FsmmCmd.chat(sender, "Account not found.");
            FsmmCmd.chat(sender, "Searched: " + rs.toString());
            return;
        }
        cons.accept(account, online);
        if (!online) {
            DataManager.unloadAccount(account);
        }
    }

    public static class_2960 getId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static class_2960 getId(class_1799 item) {
        return class_7923.field_41178.method_10221((Object)item.method_7909());
    }

    public static class_2561 getFormatted(String str) {
        return class_2561.method_43470((String)Formatter.format((String)str));
    }

    public static void chat(class_3222 src, String str) {
        src.method_64398(FsmmCmd.getFormatted(str));
    }

    public static void log(String str) {
        FSMM.LOGGER.info(str);
    }

    public static void chat(CommandContext<class_2168> cmd, String str) {
        FsmmCmd.chat(((class_2168)cmd.getSource()).method_44023(), str);
    }

    public static void chat(EntityW entity, String str) {
        FsmmCmd.chat((class_3222)entity.local(), str);
    }
}

