/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.ui.ATMContainer;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ATMBankSelect
extends UserInterface {
    private ATMContainer menu;
    private int scroll;

    public ATMBankSelect(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.menu = (ATMContainer)container;
    }

    public void init() {
        this.menu.sync("bank", "bank_list");
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.startsWith("info_")) {
            int i = Integer.parseInt(id.substring(5));
            if (i < 0 || i >= 8) {
                return false;
            }
            TagCW compound = TagCW.create();
            compound.set("cargo", "bank_info");
            compound.set("bank", this.menu.banks.get(i + this.scroll).getKey());
            ContainerInterface.SEND_TO_SERVER.accept(compound);
            return true;
        }
        if (id.startsWith("select_")) {
            int i = Integer.parseInt(id.substring(7));
            if (i < 0 || i >= 8) {
                return false;
            }
            TagCW compound = TagCW.create();
            compound.set("cargo", "bank_select");
            compound.set("bank", this.menu.banks.get(i + this.scroll).getKey());
            ContainerInterface.SEND_TO_SERVER.accept(compound);
            return true;
        }
        switch (id) {
            case "up": {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                return true;
            }
            case "dw": {
                ++this.scroll;
                return true;
            }
            case "info": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "bank_info");
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
        }
        return true;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.menu.bank != null) {
            ((UIText)this.texts.get("bank_name")).value(this.menu.bank.getName());
        }
        if (this.menu.banks != null) {
            for (int i = 0; i < 8; ++i) {
                int j = i + this.scroll;
                if (j >= this.menu.banks.size()) {
                    ((UIButton)this.buttons.get("info_" + i)).visible(false);
                    ((UIButton)this.buttons.get("select_" + i)).visible(false);
                    ((UIText)this.texts.get("bank_" + i)).value("");
                    continue;
                }
                ((UIButton)this.buttons.get("info_" + i)).visible(false);
                ((UIButton)this.buttons.get("select_" + i)).visible(false);
                ((UIText)this.texts.get("bank_" + i)).value(this.menu.banks.get(j).getValue());
            }
        }
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }
}

