/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.data.Manageable;
import net.fexcraft.mod.fsmm.data.PlayerAccData;
import net.fexcraft.mod.fsmm.event.ATMEvent;
import net.fexcraft.mod.fsmm.event.FsmmEvent;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.FsmmUIKeys;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.world.MessageSender;

public class ATMContainer
extends ContainerInterface {
    protected ArrayList<Map.Entry<String, String>> banks;
    protected ArrayList<AccountPermission> accounts;
    protected ArrayList<String> types;
    protected PlayerAccData pass;
    protected AccountPermission perm;
    protected Account account;
    protected Account receiver;
    protected long inventory;
    protected Bank bank;

    public ATMContainer(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
        this.pass = (PlayerAccData)ply.getApp(PlayerAccData.class);
        this.perm = this.pass.getSelectedAccount() == null ? AccountPermission.FULL : this.pass.getSelectedAccount();
        this.account = this.pass.getSelectedAccount() == null ? this.pass.getAccount() : this.perm.getAccount();
        this.receiver = this.pass.getSelectedReceiver();
        this.bank = this.pass.getSelectedBankInATM() == null ? this.account.getBank() : this.pass.getSelectedBankInATM();
        this.pass.setSelectedBankInATM(null);
    }

    public void init() {
        if ((this.uiid.equals(FsmmUIKeys.UI_ATM_ACC_DEPOSIT) || this.uiid.equals(FsmmUIKeys.UI_ATM_ACC_WITHDRAW)) && !FsmmUIKeys.IS_ATM.apply(this.player, this.pos).booleanValue()) {
            this.player.entity.closeUI();
            if (!this.player.entity.isOnClient()) {
                this.player.entity.send("ui.fsmm.atm_only");
            }
        }
    }

    public Object get(String key, Object ... objs) {
        return null;
    }

    public void packet(TagCW com, boolean client) {
        if (client) {
            switch (com.getString("cargo")) {
                case "sync": {
                    int i;
                    TagLW list;
                    if (com.has("account")) {
                        this.account = new Account(JsonHandler.parse((String)com.getString("account"), (boolean)true).asMap(), null, null);
                    }
                    if (com.has("receiver")) {
                        this.receiver = new Account(JsonHandler.parse((String)com.getString("receiver"), (boolean)true).asMap(), null, null);
                    }
                    if (com.has("bank")) {
                        this.bank = new Bank(JsonHandler.parse((String)com.getString("bank"), (boolean)true).asMap());
                    }
                    if (com.has("account_types")) {
                        this.types = new ArrayList();
                        list = com.getList("account_types");
                        for (i = 0; i < list.size(); ++i) {
                            this.types.add(list.getString(i));
                        }
                    }
                    if (com.has("bank_list")) {
                        TreeMap<String, String> banks = new TreeMap<String, String>();
                        TagLW list2 = com.getList("bank_list");
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            String[] str = list2.getString(i2).split(":");
                            if (this.bank != null && str[0].equals(this.bank.id)) continue;
                            banks.put(str[0], str[1]);
                        }
                        this.banks = new ArrayList();
                        this.banks.addAll(banks.entrySet());
                    }
                    if (com.has("account_list")) {
                        this.accounts = new ArrayList();
                        list = com.getList("account_list");
                        for (i = 0; i < list.size(); ++i) {
                            this.accounts.add(new AccountPermission(list.getCompound(i)));
                        }
                    }
                    if (!com.has("inventory")) break;
                    this.inventory = com.getLong("inventory");
                }
            }
            return;
        }
        switch (com.getString("cargo")) {
            case "bank": {
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_BANK_SELECT, this.pos);
                break;
            }
            case "transfers": {
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_TRANSFERS, this.pos);
                break;
            }
            case "select": {
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_SELECT, this.pos);
                break;
            }
            case "receiver": {
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_RECEIVER, this.pos);
                break;
            }
            case "withdraw": {
                if (!FsmmUIKeys.IS_ATM.apply(this.player, this.pos).booleanValue()) {
                    this.player.entity.send("ui.fsmm.not_mobile");
                    return;
                }
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_WITHDRAW, this.pos);
                break;
            }
            case "deposit": {
                if (!FsmmUIKeys.IS_ATM.apply(this.player, this.pos).booleanValue()) {
                    this.player.entity.send("ui.fsmm.not_mobile");
                    return;
                }
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_DEPOSIT, this.pos);
                break;
            }
            case "transfer": {
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_TRANSFER, this.pos);
                break;
            }
            case "bank_info": {
                this.pass.setSelectedBankInATM(DataManager.getBank(com.getString("bank")));
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_BANK_INFO, this.pos);
                break;
            }
            case "bank_select": {
                String feeid;
                long fee;
                if (!this.perm.manage) {
                    this.player.entity.send("ui.fsmm.atm.account_no_manage_perm");
                    this.player.entity.closeUI();
                    break;
                }
                Bank bank = DataManager.getBank(com.getString("bank"));
                long l = fee = bank.hasFee(feeid = this.account.getType() + ":setup_account") ? Long.parseLong(bank.getFees().get(feeid).replace("%", "")) : 0L;
                if (this.account.getBalance() < fee) {
                    this.player.entity.send("ui.fsmm.atm.not_enough_to_move_bank");
                    this.player.entity.closeUI();
                    break;
                }
                if (fee > 0L) {
                    this.account.modifyBalance(Manageable.Action.SUB, fee, (MessageSender)this.player.entity);
                }
                this.account.setBank(bank);
                this.player.entity.openUI(FsmmUIKeys.UI_ATM_MAIN, this.pos);
                break;
            }
            case "sync": {
                TagCW compound = TagCW.create();
                if (com.getBoolean("account")) {
                    compound.set("account", this.account.toJson(false).toString());
                }
                if (com.getBoolean("account_transfers")) {
                    compound.set("account", this.account.toJson(true).toString());
                }
                if (com.getBoolean("receiver") && this.receiver != null) {
                    compound.set("receiver", this.receiver.toJson(false).toString());
                }
                if (com.getBoolean("bank")) {
                    compound.set("bank", this.bank.toJson().toString());
                }
                if (com.getBoolean("bank_list")) {
                    compound.set("bank_list", this.getBankList());
                }
                if (com.getBoolean("account_types")) {
                    TagLW list = TagLW.create();
                    for (String type : DataManager.getAccountTypes()) {
                        list.add(type);
                    }
                    compound.set("account_types", list);
                }
                if (com.getBoolean("account_list")) {
                    ATMEvent.GatherAccounts event = new ATMEvent.GatherAccounts(this.player);
                    FsmmEvent.run(event);
                    this.accounts = event.getAccountsList();
                    TagLW list = TagLW.create();
                    this.accounts.forEach(account -> list.add(TagCW.wrap((Object)account.toNBT())));
                    compound.set("account_list", list);
                }
                if (com.getBoolean("inventory")) {
                    compound.set("inventory", ItemManager.countInInventory(this.player.entity));
                }
                compound.set("cargo", "sync");
                SEND_TO_CLIENT.accept(compound, this.player);
                break;
            }
            case "action_deposit": 
            case "action_withdraw": {
                boolean deposit = com.getString("cargo").endsWith("deposit");
                if (!(!deposit ? this.perm.withdraw : this.perm.deposit)) {
                    this.player.entity.send(deposit ? "ui.fsmm.atm.no_deposit_perm" : "ui.fsmm.atm.no_withdraw_perm");
                    return;
                }
                if (!this.processSelfAction(com.getLong("amount"), deposit)) break;
                this.player.entity.closeUI();
                break;
            }
            case "action_transfer": {
                if (!this.perm.transfer) {
                    this.player.entity.send("ui.fsmm.atm.no_transfer_perm");
                    return;
                }
                long amount = com.getLong("amount");
                if (amount <= 0L) {
                    return;
                }
                if (this.receiver == null) {
                    this.player.entity.send("ui.fsmm.atm.select_receiver");
                    return;
                }
                if (this.account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)this.player.entity, this.account, amount, this.receiver, false)) {
                    this.player.entity.send("ui.fsmm.atm.transfer_processed", new Object[]{Config.getWorthAsString(amount, false)});
                    this.player.entity.closeUI();
                    break;
                }
                this.player.entity.send("ui.fsmm.atm.transfer_failed");
                break;
            }
            case "account_search": {
                String type = com.getString("type").toLowerCase();
                String id = com.getString("id").toLowerCase();
                if (type.trim().length() == 0 || id.trim().length() == 0) break;
                TagCW compound = TagCW.create();
                ATMEvent.SearchAccounts event = new ATMEvent.SearchAccounts(this.player, type, id);
                FsmmEvent.run(event);
                this.accounts = new ArrayList();
                this.accounts.addAll(event.getAccountsMap().values());
                TagLW list = TagLW.create();
                this.accounts.forEach(account -> list.add(TagCW.wrap((Object)account.toNBT())));
                compound.set("account_list", list);
                compound.set("cargo", "sync");
                SEND_TO_CLIENT.accept(compound, this.player);
                break;
            }
            case "account_select": {
                AccountPermission acc = null;
                String type = com.getString("type");
                String id = com.getString("id");
                boolean mode = com.getBoolean("mode");
                for (AccountPermission perm : this.accounts) {
                    if (!perm.getAccount().getType().equals(type) || !perm.getAccount().getId().equals(id)) continue;
                    acc = perm;
                    break;
                }
                if (acc != null) {
                    if (mode) {
                        this.pass.setSelectedAccount(acc);
                        this.player.entity.openUI(FsmmUIKeys.UI_ATM_MAIN, this.pos);
                        break;
                    }
                    this.pass.setSelectedReceiver(acc.getAccount());
                    this.player.entity.openUI(FsmmUIKeys.UI_ATM_ACC_TRANSFER, this.pos);
                    break;
                }
                this.player.entity.send("ui.fsmm.atm.no_account_server");
                this.player.entity.closeUI();
                break;
            }
        }
    }

    private boolean processSelfAction(long amount, boolean deposit) {
        if (amount <= 0L) {
            return false;
        }
        String dep = deposit ? "&eDeposit" : "&aWithdraw";
        if (this.account.getBank().processAction(deposit ? Bank.Action.DEPOSIT : Bank.Action.WITHDRAW, (MessageSender)this.player.entity, this.account, amount, this.account, false)) {
            this.player.entity.send("ui.fsmm.atm." + (deposit ? "deposit" : "withdraw") + "_processed", new Object[]{Config.getWorthAsString(amount, false)});
            return true;
        }
        this.player.entity.send("ui.fsmm.atm." + (deposit ? "deposit" : "withdraw") + "_failed");
        return false;
    }

    private TagLW getBankList() {
        TagLW list = TagLW.create();
        DataManager.getBanks().forEach((key, val) -> list.add(key + ":" + val.getName()));
        return list;
    }

    public void sync(String ... types) {
        TagCW compound = TagCW.create();
        compound.set("cargo", "sync");
        for (String str : types) {
            compound.set(str, true);
        }
        SEND_TO_SERVER.accept(compound);
    }
}

