/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.ui.ATMContainer;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ATMSelectReceiver
extends UserInterface {
    private ATMContainer menu;
    private int seltype = -1;
    private int scroll;

    public ATMSelectReceiver(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.menu = (ATMContainer)container;
    }

    public void init() {
        this.menu.sync("account_types", "account");
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "search": {
                this.search();
                return true;
            }
            case "result_0": {
                this.select(0);
                return true;
            }
            case "result_1": {
                this.select(1);
                return true;
            }
            case "result_2": {
                this.select(2);
                return true;
            }
            case "result_3": {
                this.select(3);
                return true;
            }
            case "up": {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                return true;
            }
            case "down": {
                ++this.scroll;
                return true;
            }
            case "prev": {
                if (--this.seltype < 0) {
                    this.seltype = this.menu.types.size() - 1;
                }
                return true;
            }
            case "next": {
                if (++this.seltype >= this.menu.types.size()) {
                    this.seltype = 0;
                }
                return true;
            }
        }
        return true;
    }

    private void select(int idx) {
        if (this.menu.accounts == null || idx + this.scroll >= this.menu.accounts.size()) {
            return;
        }
        AccountPermission perm = this.menu.accounts.get(idx + this.scroll);
        TagCW compound = TagCW.create();
        compound.set("cargo", "account_select");
        compound.set("type", perm.getAccount().getType());
        compound.set("id", perm.getAccount().getId());
        compound.set("mode", false);
        ATMContainer.SEND_TO_SERVER.accept(compound);
    }

    private void search() {
        boolean noid;
        if (this.menu.accounts != null) {
            this.menu.accounts.clear();
        }
        String type = this.menu.types.get(this.seltype);
        String id = ((UIField)this.fields.get("id")).text();
        boolean notype = type.trim().length() == 0;
        boolean bl = noid = id.trim().length() == 0;
        if (notype) {
            this.container.player.entity.send("&cYou need to enter the searched account type.");
            return;
        }
        if (noid || id.trim().length() < 1) {
            this.container.player.entity.send("&cYou need to enter at least " + Config.MIN_SEARCH_CHARS + " characters of the searched id.");
            return;
        }
        if (notype && noid) {
            return;
        }
        TagCW compound = TagCW.create();
        compound.set("cargo", "account_search");
        compound.set("type", type);
        compound.set("id", id);
        ATMContainer.SEND_TO_SERVER.accept(compound);
        this.menu.accounts = null;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.seltype < 0 && this.menu.types != null) {
            this.seltype = this.menu.types.indexOf("player");
        }
        if (this.seltype >= 0) {
            ((UIText)this.texts.get("type")).value(this.menu.types.get(this.seltype));
        }
        if (this.menu.account != null) {
            ((UIText)this.texts.get("account_name")).value(this.menu.account.getName());
            ((UIText)this.texts.get("account_id")).value(this.menu.account.getType() + ":" + this.menu.account.getId());
        }
        if (this.menu.accounts != null) {
            for (int i = 0; i < 4; ++i) {
                int k = i + this.scroll;
                if (k >= this.menu.accounts.size()) {
                    ((UIButton)this.buttons.get("result_" + i)).visible(false);
                    ((UIText)this.texts.get("result_name_" + i)).value("");
                    ((UIText)this.texts.get("result_id_" + i)).value("");
                    continue;
                }
                ((UIButton)this.buttons.get("result_" + i)).visible(true);
                Account account = this.menu.accounts.get(k).getAccount();
                ((UIText)this.texts.get("result_name_" + i)).value(account.getName());
                ((UIText)this.texts.get("result_id_" + i)).value(account.getType() + ":" + account.getId());
            }
        }
    }

    public void getTooltip(int mx, int my, List<String> list) {
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }
}

