/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fsmm.data.Transfer;
import net.fexcraft.mod.fsmm.ui.ATMContainer;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ATMViewTransfers
extends UserInterface {
    private ATMContainer menu;
    private int scroll;

    public ATMViewTransfers(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.menu = (ATMContainer)container;
    }

    public void init() {
        this.menu.sync("account_transfers");
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "up": {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                return true;
            }
            case "down": {
                ++this.scroll;
                return true;
            }
        }
        return true;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.menu.account != null) {
            ((UIText)this.texts.get("account_name")).value(this.menu.account.getName());
            ((UIText)this.texts.get("account_id")).value(this.menu.account.getType() + ":" + this.menu.account.getId());
            Transfer transfer = null;
            for (int i = 0; i < 5; ++i) {
                int j = i + this.scroll;
                if (j >= this.menu.account.getTransfers().size()) {
                    ((UIButton)this.buttons.get("transfer_" + i)).visible(false);
                    ((UIText)this.texts.get("transfer_receiver_" + i)).value("");
                    ((UIText)this.texts.get("transfer_amount_" + i)).value("");
                    ((UIText)this.texts.get("transfer_type_" + i)).value("");
                    continue;
                }
                transfer = this.menu.account.getTransfers().get(j);
                ((UIButton)this.buttons.get("transfer_" + i)).visible(false);
                ((UIText)this.texts.get("transfer_receiver_" + i)).value(transfer.name);
                ((UIText)this.texts.get("transfer_amount_" + i)).value(Formatter.format((String)((transfer.negative ? "&c" : "&e") + (transfer.negative ? "-" : "") + Config.getWorthAsString(transfer.amount))));
                ((UIText)this.texts.get("transfer_type_" + i)).value(transfer.action.name());
            }
        }
    }

    public void getTooltip(int mx, int my, List<String> list) {
        for (Map.Entry entry : this.buttons.entrySet()) {
            int idx;
            int j;
            if (!((String)entry.getKey()).startsWith("transfer") || !((UIButton)entry.getValue()).hovered(this.gLeft, this.gTop, mx, my) || (j = (idx = Integer.parseInt(((String)entry.getKey()).substring(9))) + this.scroll) >= this.menu.account.getTransfers().size()) continue;
            Transfer transfer = this.menu.account.getTransfers().get(j);
            list.add(Formatter.format((String)"&9Transfer Info"));
            list.add(Formatter.format((String)("&7Time: &a" + Time.getAsString((long)transfer.time))));
            list.add(Formatter.format((String)("&7Account Name: &b" + transfer.name)));
            list.add(Formatter.format((String)("&7Account Type: &b" + transfer.type)));
            list.add(Formatter.format((String)("&7Account ID: &b" + transfer.from)));
            list.add(Formatter.format((String)("&7Transfer Type: &b" + transfer.action.name().toLowerCase())));
            list.add(Formatter.format((String)("&7Fees Included: " + (transfer.included ? "&aYes" : "&cNo"))));
            list.add(Formatter.format((String)("&7Amount: &e" + (transfer.negative ? "-" : "") + Config.getWorthAsString(transfer.amount))));
            list.add(Formatter.format((String)("&7Fee: &e" + Config.getWorthAsString(transfer.fee))));
            long am = transfer.amount + (transfer.included ? 0L : transfer.fee);
            list.add(Formatter.format((String)("&7Total: &e" + (transfer.negative ? "-" : "") + Config.getWorthAsString(am))));
        }
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }
}

