/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.utils.CallbackContainer;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.data.Money;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.uni.IDL;

public class DataManager
extends TimerTask {
    public static LinkedHashMap<IDL, Money> CURRENCY = new LinkedHashMap();
    private static final Map<String, Map<String, Account>> ACCOUNTS = new ConcurrentHashMap<String, Map<String, Account>>();
    private static final Map<String, Bank> BANKS = new ConcurrentHashMap<String, Bank>();
    public static CallbackContainer AFTER_INIT = new CallbackContainer();
    public static File ACCOUNT_DIR;
    public static File BANK_DIR;
    public static long LAST_TIMERTASK;
    protected static Timer timer;

    public DataManager(File file) {
        timer = new Timer();
        ACCOUNT_DIR = new File(file, "/fsmm/accounts/");
        if (!ACCOUNT_DIR.exists()) {
            ACCOUNT_DIR.mkdirs();
        }
        for (File dir : ACCOUNT_DIR.listFiles()) {
            String[] fls;
            if (!dir.isDirectory() || (fls = dir.list()) == null || fls.length == 0) continue;
            ACCOUNTS.put(dir.getName(), new ConcurrentHashMap());
        }
        BANK_DIR = new File(file, "/fsmm/banks/");
        if (!BANK_DIR.exists()) {
            BANK_DIR.mkdirs();
        }
        if (Config.DEFAULT_BANKS != null) {
            Config.DEFAULT_BANKS.forEach(str -> DataManager.addBank(new Bank((String)str)));
        }
        if (BANKS.isEmpty() || !BANKS.containsKey(Config.DEFAULT_BANK)) {
            BANKS.put(Config.DEFAULT_BANK, new Bank(Config.DEFAULT_BANK));
        }
        for (Bank bank : BANKS.values()) {
            DataManager.loadBank(bank);
        }
        AFTER_INIT.complete();
    }

    @Override
    public void run() {
        ImmutableSet set = ImmutableSet.copyOf(ACCOUNTS.keySet());
        LAST_TIMERTASK = Time.getDate();
        long mndt = LAST_TIMERTASK - ((long)Config.UNLOAD_FREQUENCY * 60000L - 5000L);
        for (String type : set) {
            ImmutableMap map = ImmutableMap.copyOf(ACCOUNTS.get(type));
            for (Map.Entry entry : map.entrySet()) {
                if (((Account)entry.getValue()).lastAccessed() < 0L || ((Account)entry.getValue()).lastAccessed() >= mndt) continue;
                DataManager.unloadAccount(type, (String)entry.getKey());
            }
        }
        this.saveAll();
    }

    public static final void save(Account account) {
        if (account == null) {
            return;
        }
        File file = new File(ACCOUNT_DIR, account.getType() + "/" + account.getId() + ".json");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        JsonHandler.print((File)file, (JsonValue)account.toJson(), (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT);
    }

    public static final void save(Bank bank) {
        if (bank == null) {
            return;
        }
        File file = new File(BANK_DIR, bank.id + ".json");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        JsonHandler.print((File)file, (JsonValue)bank.toJson(), (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT);
    }

    public final void saveAll() {
        for (Map<String, Account> map : ACCOUNTS.values()) {
            for (Account account : map.values()) {
                try {
                    DataManager.save(account);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (Bank bank : BANKS.values()) {
            try {
                DataManager.save(bank);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearAll() {
        ACCOUNTS.clear();
        BANKS.clear();
        timer.cancel();
    }

    public static void unloadAccount(Account account) {
        DataManager.unloadAccount(account.getType(), account.getId());
    }

    public static void unloadAccount(IDL loc) {
        DataManager.unloadAccount(loc.space(), loc.path());
    }

    public static void unloadAccount(String type, String id) {
        if (ACCOUNTS.containsKey(type) && ACCOUNTS.get(type).containsKey(id)) {
            try {
                DataManager.save(ACCOUNTS.get(type).remove(id));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static final DataManager getInstance() {
        return FSMM.CACHE;
    }

    public static final Account getAccount(String accid, boolean tempload) {
        return DataManager.getAccount(accid, tempload, true);
    }

    public static final Account getAccount(String accid, boolean tempload, boolean create) {
        String[] arr = accid.split(":");
        if (arr.length < 2) {
            return null;
        }
        if (ACCOUNTS.containsKey(arr[0]) && ACCOUNTS.get(arr[0]).containsKey(arr[1])) {
            Account account = ACCOUNTS.get(arr[0]).get(arr[1]);
            return !tempload && account.isTemporary() ? (Account)account.setTemporary(false) : account;
        }
        return tempload || create ? DataManager.loadAccount(arr, tempload, create) : null;
    }

    private static final Account loadAccount(String[] arr, boolean tempload, boolean create) {
        File file = new File(ACCOUNT_DIR, arr[0] + "/" + arr[1] + ".json");
        if (file.exists()) {
            try {
                Account account = new Account(JsonHandler.parse((File)file), arr[0], arr[1]);
                if (!account.getType().equals(arr[0]) || !account.getId().equals(arr[1])) {
                    FSMM.LOGGER.info(arr[0] + ":" + arr[1] + " != " + account.getType() + ":" + account.getId());
                    throw new RuntimeException("Account data from file doesn't match request! This is a file error which should get controlled.\n" + file.getPath());
                }
                DataManager.addAccount(arr[0], account);
                return (Account)account.setTemporary(tempload);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (create) {
            try {
                Account account = new Account(arr[1], arr[0], arr[0].equals("player") ? Config.STARTING_BALANCE : 0L, DataManager.getDefaultBank(), null);
                DataManager.addAccount(arr[0], account);
                FSMM.LOGGER.info("Created new account for " + arr[0] + ":" + arr[1] + " at Bank '" + account.getBank().id + "'!");
                return (Account)account.setTemporary(tempload);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static boolean addAccount(String type, Account account) {
        if (DataManager.getAccountsOfType(type) == null) {
            ACCOUNTS.put(type, new ConcurrentHashMap());
        }
        return DataManager.getAccountsOfType(type).put(account.getId(), account) == null;
    }

    public static boolean addAccount(Account account) {
        return DataManager.addAccount(account.getType(), account);
    }

    public static final Map<String, Account> getAccountsOfType(String type) {
        return ACCOUNTS.get(type);
    }

    public static final Bank getBank(String id) {
        if (BANKS.containsKey(id)) {
            return BANKS.get(id);
        }
        return DataManager.getDefaultBank();
    }

    public static void loadBank(Bank bank) {
        if (bank == null) {
            return;
        }
        bank.load(JsonHandler.parse((File)new File(BANK_DIR, bank.id + ".json")));
    }

    public static final Bank getDefaultBank() {
        return BANKS.get(Config.DEFAULT_BANK);
    }

    public static boolean addBank(Bank bank) {
        return BANKS.put(bank.id, bank) == null;
    }

    public static final Map<String, Bank> getBanks() {
        return BANKS;
    }

    public void schedule() {
        LocalDateTime midnight = LocalDateTime.of(LocalDate.now(ZoneOffset.systemDefault()), LocalTime.MIDNIGHT);
        long mid = midnight.toInstant(ZoneOffset.UTC).toEpochMilli();
        long date = Time.getDate();
        while ((mid += (long)Config.UNLOAD_FREQUENCY * 60000L) < date) {
        }
        timer.schedule((TimerTask)this, new Date(mid), (long)Config.UNLOAD_FREQUENCY * 60000L);
    }

    public static String[] getAccountTypes() {
        return ACCOUNTS.keySet().toArray(new String[0]);
    }

    public static boolean exists(String type, String id) {
        if (ACCOUNTS.containsKey(type) && ACCOUNTS.get(type).containsKey(id)) {
            return true;
        }
        File folder = new File(ACCOUNT_DIR, type + "/");
        if (!folder.exists()) {
            return false;
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory() || file.isHidden() || !file.getName().endsWith(".json") || !file.getName().substring(0, file.getName().length() - 5).equals(id)) continue;
            return true;
        }
        return false;
    }

    public static List<Money> getSortedMoneyList() {
        return CURRENCY.values().stream().sorted((o1, o2) -> o1.getWorth() < o2.getWorth() ? 1 : -1).collect(Collectors.toList());
    }
}

