/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.util;

import java.util.List;
import net.fexcraft.mod.fsmm.data.Money;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;

public class ItemManager {
    public static long countInInventory(Object player) {
        UniEntity ent = UniEntity.get((Object)player);
        return ent == null ? -1L : ItemManager.countInInventory(ent.entity);
    }

    public static long countInInventory(EntityW player) {
        if (!player.isPlayer()) {
            return -1L;
        }
        long value = 0L;
        StackWrapper wrapper = null;
        for (int i = 0; i < player.getInventorySize(); ++i) {
            wrapper = player.getStackAt(i);
            if (wrapper.empty()) continue;
            long worth = Config.getStackWorth(wrapper);
            value += worth * (long)wrapper.count();
        }
        return value;
    }

    public static boolean hasSpace(EntityW player, boolean countMoneyItemAsSpace) {
        StackWrapper wrapper = null;
        for (int idx = 0; idx < player.getInventorySize(); ++idx) {
            wrapper = player.getStackAt(idx);
            if (!wrapper.empty() && (!countMoneyItemAsSpace || Config.getStackWorth(wrapper) <= 0L)) continue;
            return true;
        }
        return false;
    }

    public static long addToInventory(EntityW player, long amount) {
        return ItemManager.setInInventory(player, (amount += ItemManager.countInInventory(player)) >= Long.MAX_VALUE ? Long.MAX_VALUE : amount);
    }

    public static long removeFromInventory(EntityW player, long amount) {
        long old = ItemManager.countInInventory(player);
        if ((old -= amount) < 0L) {
            amount += old;
            old = 0L;
        }
        StackWrapper wrapper = null;
        for (int idx = 0; idx < player.getInventorySize(); ++idx) {
            wrapper = player.getStackAt(idx);
            if (wrapper.empty() || Config.getStackWorth(wrapper) <= 0L) continue;
            wrapper.count(0);
        }
        ItemManager.setInInventory(player, old);
        return amount;
    }

    public static long setInInventory(EntityW player, long amount) {
        StackWrapper wrapper = null;
        for (int idx = 0; idx < player.getInventorySize(); ++idx) {
            wrapper = player.getStackAt(idx);
            if (wrapper.empty() || Config.getStackWorth(wrapper) <= 0L) continue;
            wrapper.count(0);
        }
        List<Money> list = DataManager.getSortedMoneyList();
        Money money = null;
        for (int i = 0; i < list.size(); ++i) {
            while (amount - (money = list.get(i)).getWorth() >= 0L) {
                StackWrapper stack = money.getStack().copy();
                if (ItemManager.hasSpace(player, false)) {
                    player.addStack(stack);
                } else {
                    player.drop(stack, 0.5f);
                }
                amount -= money.getWorth();
            }
        }
        if (amount > 0L) {
            player.send(Config.getWorthAsString(amount, true, true) + " couldn't be added to inventory because no matching items were found.");
        }
        return amount;
    }
}

