/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.event;

import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.local.FsmmCmd;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fsmm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        FSMM.LOGGER.info("Loading account of " + String.valueOf(event.getEntity().m_7755_()) + " || " + event.getEntity().m_36316_().getId().toString());
        Account account = DataManager.getAccount("player:" + event.getEntity().m_36316_().getId().toString(), false, true);
        if (Config.NOTIFY_BALANCE_ON_JOIN) {
            event.getEntity().m_213846_(FsmmCmd.getFormatted("&m&3Balance &r&7(in bank)&0: &a" + Config.getWorthAsString(account.getBalance())));
            event.getEntity().m_213846_(FsmmCmd.getFormatted("&m&3Balance &r&7(in Inv0)&0: &a" + Config.getWorthAsString(ItemManager.countInInventory(event.getEntity()))));
        }
        if (account.lastAccessed() >= 0L) {
            account.setTemporary(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        FSMM.LOGGER.info("Unloading account of " + String.valueOf(event.getEntity().m_7755_()) + " || " + event.getEntity().m_36316_().getId().toString());
        DataManager.unloadAccount("player", event.getEntity().m_36316_().getId().toString());
    }
}

