/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fsmm.ui.ATMContainer;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ATMBankInfo
extends UserInterface {
    private ATMContainer menu;
    private String[] keys;
    private String[] vals;
    private int scroll;

    public ATMBankInfo(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.menu = (ATMContainer)container;
    }

    public void init() {
        this.menu.sync("bank");
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "up": {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                return true;
            }
            case "down": {
                ++this.scroll;
                return true;
            }
        }
        return true;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.menu.bank != null) {
            ((UIText)this.texts.get("bank_name")).value(this.menu.bank.getName());
            ((UIText)this.texts.get("bank_line_0")).value(this.menu.bank.getStatus().size() > 0 ? Formatter.format((String)this.menu.bank.getStatus().get(0)) : "");
            ((UIText)this.texts.get("bank_line_1")).value(this.menu.bank.getStatus().size() > 1 ? Formatter.format((String)this.menu.bank.getStatus().get(1)) : "");
            ((UIText)this.texts.get("bank_line_2")).value(this.menu.bank.getStatus().size() > 2 ? Formatter.format((String)this.menu.bank.getStatus().get(2)) : "");
            if (this.keys == null) {
                if (this.menu.bank.getFees() == null) {
                    this.vals = new String[0];
                    this.keys = this.vals;
                } else {
                    this.keys = this.menu.bank.getFees().keySet().toArray(new String[0]);
                    this.vals = this.menu.bank.getFees().values().toArray(new String[0]);
                }
            }
            if (this.keys.length > 0) {
                for (int i = 0; i < 8; ++i) {
                    int j = i + this.scroll;
                    if (j >= this.keys.length) {
                        ((UIText)this.texts.get("bank_fees_" + j)).value("");
                        continue;
                    }
                    String val = this.vals[j].contains("%") ? this.vals[j] : Config.getWorthAsString(Long.parseLong(this.vals[j]));
                    ((UIText)this.texts.get("bank_fees_" + j)).value(this.keys[j].replace(":", " -> ") + " = " + val);
                }
            }
        }
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }
}

