/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Money;
import net.fexcraft.mod.fsmm.data.PlayerAccData;
import net.fexcraft.mod.fsmm.event.ATMEvent;
import net.fexcraft.mod.fsmm.event.AccountEvent;
import net.fexcraft.mod.fsmm.event.FsmmEvent;
import net.fexcraft.mod.fsmm.local.AtmBlock;
import net.fexcraft.mod.fsmm.local.FsmmCmd;
import net.fexcraft.mod.fsmm.local.MobileAtm;
import net.fexcraft.mod.fsmm.local.MoneyItem;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.FsmmUIKeys;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="fsmm")
public class FSMM {
    public static final String MODID = "fsmm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static DataManager CACHE;
    public static Config CONFIG;
    private static boolean loaded;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<Block> ATM_BLOCK;
    public static final RegistryObject<Item> ATM_ITEM;
    public static final RegistryObject<MobileAtm> MOBILE_ATM;
    public static final RegistryObject<CreativeModeTab> FSMM_TAB;

    public FSMM() {
        CONFIG = new Config(new File(FMLPaths.CONFIGDIR.get().toFile(), "fsmm.json"));
        UniEntity.register((Appendable)new PlayerAccData(null));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FsmmUIKeys.IS_ATM = (ply, pos) -> ((Entity)ply.entity.direct()).m_9236_().m_8055_(new BlockPos(pos.x, pos.y, pos.z)).m_60734_() instanceof AtmBlock;
        FsmmUIKeys.register(this);
    }

    public static void registerItem(Money money) {
        ITEMS.register(money.getID().path(), () -> new MoneyItem(money));
    }

    public static TagCW getTagfromJson(JsonMap map) {
        return null;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (loaded) {
            return;
        }
        DataManager.CURRENCY.values().forEach(val -> {
            JsonMap map = Config.MONEY_INIT_CACHE.get(val);
            if (map != null) {
                ItemWrapper item = ItemWrapper.get((String)map.get("id").string_value());
                val.loadstack(item, map);
            }
        });
        Config.MONEY_INIT_CACHE.clear();
        loaded = true;
    }

    private void commonSetup(FMLCommonSetupEvent setup) {
        MoneyItem.sort();
        if (EnvInfo.DEV) {
            FsmmEvent.addListener(AccountEvent.BalanceUpdated.class, fe -> FSMM.log("bal-upd: " + fe.getOldBalance() + " -> " + fe.getNewBalance()));
        }
        FsmmEvent.addListener(ATMEvent.GatherAccounts.class, event -> {
            event.getAccountsList().add(new AccountPermission(event.getAccount(), true, true, true, true));
            if (WrapperHolder.isSinglePlayer()) {
                event.getAccountsList().add(new AccountPermission(event.getBank().getAccount(), true, true, true, true));
            }
        });
        FsmmEvent.addListener(ATMEvent.SearchAccounts.class, event -> {
            if (event.getSearchedId().length() < Config.MIN_SEARCH_CHARS) {
                return;
            }
            if (!event.getSearchedType().equals("player")) {
                if (!FSMM.conAccPerm(event.getAccountsMap(), event.getSearchedType()) && DataManager.exists(event.getSearchedType(), event.getSearchedId())) {
                    FSMM.putAccPerm(event.getAccountsMap(), event.getSearchedType() + ":" + event.getSearchedId());
                }
                return;
            }
            for (Account account : DataManager.getAccountsOfType("player").values()) {
                if (!account.getId().contains(event.getSearchedId()) && !account.getName().contains(event.getSearchedId())) continue;
                event.getAccountsMap().put(account.getTypeAndId(), new AccountPermission(account));
            }
            Optional gp = ((MinecraftServer)FCL.SERVER.get()).m_129927_().m_10996_(event.getSearchedId());
            if (gp.isPresent() && new File(DataManager.ACCOUNT_DIR, "player/" + ((GameProfile)gp.get()).getId().toString() + ".json").exists()) {
                FSMM.putAccPerm(event.getAccountsMap(), "player:" + ((GameProfile)gp.get()).getId().toString());
            } else if (new File(DataManager.ACCOUNT_DIR, "player/" + event.getSearchedId() + ".json").exists()) {
                FSMM.putAccPerm(event.getAccountsMap(), "player:" + event.getSearchedId());
            }
        });
    }

    private static void putAccPerm(HashMap<String, AccountPermission> map, String id) {
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, new AccountPermission(id));
    }

    private static void putAccPermIn(HashMap<String, AccountPermission> map, String id) {
        map.put(id, new AccountPermission(id));
    }

    private static boolean conAccPerm(HashMap<String, AccountPermission> map, String type) {
        for (AccountPermission perm : map.values()) {
            if (!perm.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static void log(Object obj) {
        LOGGER.info(String.valueOf(obj));
    }

    public static void loadDataManager() {
        if (FSMM.isDataManagerLoaded()) {
            return;
        }
        if (CACHE != null) {
            CACHE.saveAll();
            CACHE.clearAll();
        }
        CACHE = new DataManager(((MinecraftServer)FCL.SERVER.get()).m_6237_());
        CACHE.schedule();
    }

    public static void unloadDataManager() {
        if (CACHE != null) {
            CACHE.saveAll();
            CACHE.clearAll();
            CACHE = null;
        }
    }

    public static boolean isDataManagerLoaded() {
        return CACHE != null;
    }

    @SubscribeEvent
    public void onCmdReg(RegisterCommandsEvent event) {
        FsmmCmd.regCmd((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    static {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        ATM_BLOCK = BLOCKS.register("atm", () -> new AtmBlock());
        ATM_ITEM = ITEMS.register("atm", () -> new BlockItem((Block)ATM_BLOCK.get(), new Item.Properties()));
        MOBILE_ATM = ITEMS.register("mobile", () -> new MobileAtm());
        FSMM_TAB = CREATIVE_MODE_TABS.register(MODID, () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256968_}).m_257941_((Component)Component.m_237113_((String)"Fex's Small Money Mod")).m_257737_(() -> ((Item)ATM_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> {
            output.m_246326_((ItemLike)ATM_ITEM.get());
            output.m_246326_((ItemLike)MOBILE_ATM.get());
            for (MoneyItem item : MoneyItem.sorted) {
                output.m_246326_((ItemLike)item);
            }
        }).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="fsmm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            if (!Config.SHOW_ITEM_WORTH) {
                return;
            }
            long worth = Config.getStackWorth(event.getItemStack());
            if (worth <= 0L) {
                return;
            }
            String str = "&9" + Config.getWorthAsString(worth, true, worth < 10L);
            if (event.getItemStack().m_41613_() > 1) {
                str = str + " &8(&7" + Config.getWorthAsString(worth * (long)event.getItemStack().m_41613_(), true, worth < 10L) + "&8)";
            }
            event.getToolTip().add(FsmmCmd.getFormatted(str));
        }
    }
}

