/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;

public class Money {
    private IDL regname;
    private StackWrapper stack;
    private long worth;

    public Money(String id, long iworth) {
        this.regname = IDLManager.getIDLCached((String)("fsmm:" + id));
        this.worth = iworth;
    }

    public Money(JsonMap map) {
        this.regname = IDLManager.getIDLCached((String)map.getString("id", "invalid_" + String.valueOf(map) + "_" + Time.getDate()));
        this.worth = map.getLong("worth", -1L);
        int meta = map.getInteger("meta", -1);
        if (meta >= 0) {
            this.regname = IDLManager.getIDLCached((String)(this.regname.colon() + "_" + meta));
        }
    }

    public void loadstack(ItemWrapper item, JsonMap map) {
        TagCW com = null;
        if (map.has("nbt")) {
            try {
                com = FSMM.getTagfromJson(map);
            }
            catch (Exception e) {
                FSMM.LOGGER.info("ERROR - Could not load NBT from config of '" + this.regname.toString() + "'! This is bad!");
            }
        }
        this.stack = UniStack.createStack((Object)item);
        this.stack.damage(map.getInteger("meta", -1));
        if (com != null) {
            this.stack.updateTag(com);
        }
    }

    public IDL getID() {
        return this.regname;
    }

    public String toString() {
        return super.toString() + "#" + this.getWorth();
    }

    public long getWorth() {
        return this.worth;
    }

    public StackWrapper getStack() {
        return this.stack;
    }

    public static interface Item {
        public Money getType();

        public long getWorth();
    }
}

