/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;

public class Transfer {
    public long time;
    public long amount;
    public long fee;
    public String from;
    public String type;
    public String name;
    public Bank.Action action;
    public boolean included;
    public boolean negative;

    public Transfer(JsonMap data) {
        this.time = data.get("time").long_value();
        this.amount = data.get("amount").long_value();
        this.fee = data.get("fee").long_value();
        if (this.fee > 0L) {
            this.included = data.get("included").bool();
        }
        this.from = data.get("from").string_value();
        this.name = data.get("name").string_value();
        this.type = data.get("type").string_value();
        this.action = Bank.Action.valueOf(data.get("action").string_value());
        if (data.has("minus")) {
            this.negative = data.get("minus").bool();
        }
    }

    public Transfer(long am, long f, boolean in, Bank.Action act, String nm, Account acc) {
        this.time = Time.getDate();
        this.negative = am < 0L;
        this.amount = this.negative ? -am : am;
        this.fee = f;
        this.included = in;
        this.action = act;
        this.name = nm;
        this.from = acc.getId();
        this.name = acc.getName();
        this.type = acc.getType();
    }

    public JsonMap toJson() {
        JsonMap obj = new JsonMap();
        obj.add("time", this.time);
        obj.add("amount", this.amount);
        obj.add("fee", this.fee);
        if (this.included) {
            obj.add("included", this.included);
        }
        obj.add("from", this.from);
        obj.add("name", this.name);
        obj.add("type", this.type);
        obj.add("action", this.action.name());
        if (this.negative) {
            obj.add("minus", true);
        }
        return obj;
    }
}

