/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.local;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.AccountPermission;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.data.PlayerAccData;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FsmmCmd {
    public static final String PREFIX = "&0[&bFSMM&0]&7 ";

    public static void regCmd(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fsmm").then(Commands.m_82127_((String)"balance").executes(cmd -> {
            if (((CommandSourceStack)cmd.getSource()).m_230897_()) {
                long value = ItemManager.countInInventory(((CommandSourceStack)cmd.getSource()).m_230896_());
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bInventory&0: &a" + Config.getWorthAsString(value));
                PlayerAccData data = (PlayerAccData)UniEntity.get((Object)((CommandSourceStack)cmd.getSource()).m_230896_()).getApp("fsmm");
                if (data.getSelectedAccount() != null && !data.getSelectedAccount().getTypeAndId().equals(data.getAccount().getTypeAndId())) {
                    AccountPermission perm = data.getSelectedAccount();
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bPersonal Balance&0: &a" + Config.getWorthAsString(data.getAccount().getBalance()));
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bSelected Account&0: &a" + data.getSelectedAccount().getTypeAndId());
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bSelected Balance&0: &a" + Config.getWorthAsString(data.getSelectedAccount().getAccount().getBalance()));
                } else {
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bAccount Balance&0: &a" + Config.getWorthAsString(data.getAccount().getBalance()));
                }
            } else {
                Bank bank = DataManager.getDefaultBank();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bDefault Bank Balance&0: &a" + Config.getWorthAsString(bank.getBalance()));
            }
            return 0;
        }))).then(Commands.m_82127_((String)"uuid").executes(cmd -> {
            ((CommandSourceStack)cmd.getSource()).m_243053_((Component)Component.m_237113_((String)((CommandSourceStack)cmd.getSource()).m_81375_().m_36316_().getId().toString()));
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(pre -> FsmmCmd.isOp(pre))).then(Commands.m_82129_((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process((Player)((CommandSourceStack)cmd.getSource()).m_230896_(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance(am);
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(pre -> FsmmCmd.isOp(pre))).then(Commands.m_82129_((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process((Player)((CommandSourceStack)cmd.getSource()).m_230896_(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance((am += account.getBalance()) < 0L ? 0L : am);
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sub").requires(pre -> FsmmCmd.isOp(pre))).then(Commands.m_82129_((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"acc-id", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> {
            try {
                FsmmCmd.process((Player)((CommandSourceStack)cmd.getSource()).m_230896_(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    long am = ((Integer)cmd.getArgument("amount", Integer.class)).intValue();
                    account.setBalance((am -= account.getBalance()) < 0L ? 0L : am);
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bNew Balance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7&oYou modified the balance of an Offline Account.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").requires(pre -> FsmmCmd.isOp(pre))).then(Commands.m_82129_((String)"acc-type", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"acc-id", (ArgumentType)StringArgumentType.string()).executes(cmd -> {
            try {
                FsmmCmd.process((Player)((CommandSourceStack)cmd.getSource()).m_230896_(), (String)cmd.getArgument("acc-type", String.class), (String)cmd.getArgument("acc-id", String.class), (account, online) -> {
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bAccount&0: &7" + account.getTypeAndId());
                    FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bBalance&0: &7" + Config.getWorthAsString(account.getBalance()));
                    if (!online.booleanValue()) {
                        FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&o&7Account Holder is currently offline.");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&c&oErrors during command execution.");
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"status").requires(pre -> FsmmCmd.isOp(pre))).executes(cmd -> {
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bAccounts loaded (by type): &7");
            long temp = 0L;
            for (String str : DataManager.getAccountTypes(false)) {
                Map<String, Account> map = DataManager.getAccountsOfType(str);
                temp = map.values().stream().filter(pre -> pre.lastAccessed() >= 0L).count();
                FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&2> &b" + str + ": &7" + map.size() + (String)(temp > 0L ? " &8(&a" + temp + "temp.&8)" : ""));
            }
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bBanks active: &7" + DataManager.getBanks().size());
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&aLast scheduled unload: &r&7" + Time.getAsString((long)DataManager.LAST_TIMERTASK));
            return 0;
        }))).executes(cmd -> {
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&0[&bFSMM&0]&7 ============");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&bUser commands:");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm balance");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm uuid");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&dAdmin commands:");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm set <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm add <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm sub <type:id/name> <amount>");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm info <type:id/name>");
            FsmmCmd.chat((CommandContext<CommandSourceStack>)cmd, "&7/fsmm status");
            return 0;
        }));
    }

    public static boolean isOp(CommandSourceStack css) {
        if (css == null || !css.m_230897_()) {
            return false;
        }
        if (WrapperHolder.isSinglePlayer()) {
            return true;
        }
        return ((MinecraftServer)FCL.SERVER.get()).m_6846_().m_11303_(css.m_230896_().m_36316_());
    }

    private static void process(Player sender, String type, String acc, BiConsumer<Account, Boolean> cons) {
        Account account;
        boolean online;
        ResourceLocation rs = new ResourceLocation(type, acc.toLowerCase());
        if (rs.m_135827_().equals("player")) {
            try {
                UUID.fromString(rs.m_135815_());
            }
            catch (Exception e) {
                Optional gp = ((MinecraftServer)FCL.SERVER.get()).m_129927_().m_10996_(rs.m_135815_());
                rs = new ResourceLocation(type, ((GameProfile)gp.get()).getId().toString());
            }
        }
        boolean bl = online = (account = DataManager.getAccount(rs.toString(), false, false)) != null;
        if (!online) {
            account = DataManager.getAccount(rs.toString(), true, false);
        }
        if (account == null) {
            FsmmCmd.chat((CommandSource)sender, "Account not found.");
            FsmmCmd.chat((CommandSource)sender, "Searched: " + rs.toString());
            return;
        }
        cons.accept(account, online);
        if (!online) {
            DataManager.unloadAccount(account);
        }
    }

    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item);
    }

    public static ResourceLocation getId(ItemStack item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
    }

    public static Component getFormatted(String str) {
        return Component.m_237113_((String)Formatter.format((String)str));
    }

    public static void chat(CommandSource src, String str) {
        src.m_213846_(FsmmCmd.getFormatted(str));
    }

    public static void log(String str) {
        FSMM.LOGGER.info(str);
    }

    public static void chat(CommandContext<CommandSourceStack> cmd, String str) {
        FsmmCmd.chat(((CommandSourceStack)cmd.getSource()).f_81288_, str);
    }

    public static void chat(EntityW entity, String str) {
        FsmmCmd.chat((CommandSource)entity.local(), str);
    }
}

