/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fsmm.ui;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.ui.ATMContainer;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.ItemManager;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ATMDeposit
extends UserInterface {
    private ATMContainer menu;
    private String oldtext = "";
    private long am;
    private long bf;
    private static final DecimalFormat df = new DecimalFormat("#.000", new DecimalFormatSymbols(Locale.US));

    public ATMDeposit(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.menu = (ATMContainer)container;
    }

    public void init() {
        this.menu.sync("account", "bank", "inventory");
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "confirm": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "action_deposit");
                compound.set("amount", this.am);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
        }
        return true;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void predraw(float ticks, int mx, int my) {
        if (!this.oldtext.equals(((UIField)this.fields.get("amount")).text())) {
            this.oldtext = ((UIField)this.fields.get("amount")).text();
            this.updateValues();
        }
        if (this.menu.bank != null) {
            ((UIText)this.texts.get("fee")).value((String)(this.am == 0L || this.bf == 0L ? "-" : Config.getWorthAsString(this.bf) + "  (fee)"));
        }
        String pref = "";
        if (this.menu.account != null) {
            long inv = ItemManager.countInInventory(this.container.player.entity);
            ((UIText)this.texts.get("account_name")).value(this.menu.account.getName());
            ((UIText)this.texts.get("account_id")).value(this.menu.account.getType() + ":" + this.menu.account.getId());
            ((UIText)this.texts.get("balance")).value(Config.getWorthAsString(inv) + " (inventory)");
            if (this.am + this.bf > inv) {
                pref = "&c";
            }
        }
        ((UIText)this.texts.get("total")).value(Formatter.format((String)(pref + Config.getWorthAsString(this.am + this.bf))) + "  (total)");
    }

    private void updateValues() {
        this.am = this.format();
        TreeMap<String, String> fees = this.menu.bank == null ? null : this.menu.bank.getFees();
        String type = this.menu.account == null ? "player" : this.menu.account.getType();
        this.bf = Bank.parseFee(fees == null ? null : fees.get("self:" + type), this.am);
    }

    private final long format() {
        try {
            String str = ((UIField)this.fields.get("amount")).text().replace(Config.DOT, "").replace(",", ".");
            if (str.length() == 0) {
                return 0L;
            }
            String format = df.format(Double.parseDouble(str));
            return Long.parseLong(format.replace(",", "").replace(".", ""));
        }
        catch (Exception e) {
            this.container.player.entity.send("INVALID INPUT: " + e.getMessage());
            if (Static.dev()) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
    }

    static {
        df.setRoundingMode(RoundingMode.DOWN);
    }
}

