/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.base.api.SlottedAgnosticStorage;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralHubPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.util.ValidationHelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001-B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H&J \u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H&J \u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\bH&J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020!H\u0004J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020!H\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\bJ\u0018\u0010%\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010$J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/PeripheraliumHubPeripheral;", "O", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "maxUpdateCount", "", "owner", "type", "", "<init>", "(ILsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;Ljava/lang/String;)V", "getAdditionalTypes", "", "isEnabled", "", "()Z", "activeUpgrades", "", "getActiveUpgrades", "()Ljava/util/List;", "activeMode", "getActiveMode", "()Ljava/lang/String;", "isUpgradeImpl", "stack", "Lnet/minecraft/world/item/ItemStack;", "isEquitable", "Lkotlin/Pair;", "equipImpl", "unequipImpl", "id", "attachUpgrade", "", "Lnet/minecraft/resources/ResourceLocation;", "detachUpgrade", "getDataForUpgrade", "Lnet/minecraft/nbt/CompoundTag;", "setDataForUpdate", "data", "isUpgrade", "slot", "equip", "Ldan200/computercraft/api/lua/MethodResult;", "unequip", "getUpgrades", "Companion", "peripheralworks-forge-1.20.1"})
public abstract class PeripheraliumHubPeripheral<O extends IPeripheralOwner>
extends PeripheralHubPeripheral<O> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxUpdateCount;
    @NotNull
    public static final String TYPE = "peripheralium_hub";
    @NotNull
    public static final String NETHERITE_TYPE = "netherite_peripheralium_hub";
    @NotNull
    public static final String UPGRADES_TAG = "connectedUpgrades";
    @NotNull
    public static final String MODE_TAG = "mode";
    @NotNull
    private static final ResourceLocation ID = new ResourceLocation("peripheralworks", "peripheralium_hub");
    @NotNull
    private static final ResourceLocation NETHERITE_ID = new ResourceLocation("peripheralworks", "netherite_peripheralium_hub");
    @NotNull
    public static final String TWEAKED_STORAGES = "__TWEAKED_STORAGES__";

    public PeripheraliumHubPeripheral(int maxUpdateCount, @NotNull O owner, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super(type2, owner);
        this.maxUpdateCount = maxUpdateCount;
    }

    @NotNull
    public Set<String> getAdditionalTypes() {
        return SetsKt.setOf((Object)"peripheral_hub");
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnablePeripheraliumHubs();
    }

    @NotNull
    protected final List<String> getActiveUpgrades() {
        return Companion.getActiveUpgrades(this.getPeripheralOwner().getDataStorage());
    }

    @NotNull
    public abstract String getActiveMode();

    public abstract boolean isUpgradeImpl(@NotNull ItemStack var1);

    @NotNull
    public abstract Pair<Boolean, String> isEquitable(@NotNull ItemStack var1);

    @NotNull
    public abstract Pair<Boolean, String> equipImpl(@NotNull ItemStack var1);

    @NotNull
    public abstract ItemStack unequipImpl(@NotNull String var1);

    protected final void attachUpgrade(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ListTag upgradeList = this.getPeripheralOwner().getDataStorage().getList(UPGRADES_TAG, 8);
        upgradeList.add((Object)StringTag.m_129297_((String)id.toString()));
        this.getPeripheralOwner().getDataStorage().mutate(arg_0 -> PeripheraliumHubPeripheral.attachUpgrade$lambda$0(upgradeList, this, arg_0));
    }

    protected final void detachUpgrade(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ListTag upgradeList = this.getPeripheralOwner().getDataStorage().getList(UPGRADES_TAG, 8);
        upgradeList.remove((Object)StringTag.m_129297_((String)id.toString()));
        this.getPeripheralOwner().getDataStorage().mutate(arg_0 -> PeripheraliumHubPeripheral.detachUpgrade$lambda$0(upgradeList, arg_0));
    }

    @NotNull
    public final CompoundTag getDataForUpgrade(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Companion.getDataForUpgrade(id, this.getPeripheralOwner().getDataStorage());
    }

    public final void setDataForUpdate(@NotNull String id, @Nullable CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        IDataStorage base = this.getPeripheralOwner().getDataStorage();
        if (!base.has(TWEAKED_STORAGES)) {
            base.putCompound(TWEAKED_STORAGES, new CompoundTag());
        }
        CompoundTag tweakedStorages = base.getCompound(TWEAKED_STORAGES);
        if (data == null) {
            tweakedStorages.m_128473_(id);
        } else {
            tweakedStorages.m_128365_(id, (Tag)data);
        }
    }

    @LuaFunction(mainThread=true)
    public final boolean isUpgrade(int slot) {
        SlottedAgnosticStorage slottedAgnosticStorage = this.getPeripheralOwner().getStorage();
        if (slottedAgnosticStorage == null) {
            return false;
        }
        SlottedAgnosticStorage storage = slottedAgnosticStorage;
        ValidationHelpersKt.assertBetween((int)slot, (int)1, (int)storage.getSize(), (String)("Slot should be between 1 and " + storage.getSize()));
        ItemStack stack = (ItemStack)storage.get(slot - 1);
        return this.isUpgradeImpl(stack);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult equip(int slot) {
        block12: {
            Pair<Boolean, String> equipResult;
            ItemStack takenStack;
            SlottedAgnosticStorage storage;
            block11: {
                block10: {
                    Pair<Boolean, String> equipTestResult;
                    block9: {
                        if (this.getActiveUpgrades().size() > this.maxUpdateCount) {
                            throw new LuaException("Cannot add new upgrade, maximum upgrade count for this hub is " + this.maxUpdateCount);
                        }
                        SlottedAgnosticStorage slottedAgnosticStorage = this.getPeripheralOwner().getStorage();
                        if (slottedAgnosticStorage == null) {
                            Object[] objectArray = new Object[]{null, "Cannot access inventory for some reason"};
                            MethodResult methodResult = MethodResult.of((Object[])objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                            return methodResult;
                        }
                        storage = slottedAgnosticStorage;
                        ValidationHelpersKt.assertBetween((int)slot, (int)1, (int)storage.getSize(), (String)("Slot should be between 1 and " + storage.getSize()));
                        ItemStack stack = (ItemStack)storage.get(slot - 1);
                        equipTestResult = this.isEquitable(stack);
                        if (equipTestResult.getFirst() == null) break block9;
                        Object object = equipTestResult.getFirst();
                        Intrinsics.checkNotNull((Object)object);
                        if (((Boolean)object).booleanValue()) break block10;
                    }
                    Object[] objectArray = new Object[]{equipTestResult.getFirst(), equipTestResult.getSecond()};
                    MethodResult methodResult = MethodResult.of((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                    return methodResult;
                }
                takenStack = (ItemStack)storage.take((Number)1, slot - 1, slot - 1, ItemStorageUtils.INSTANCE.getALWAYS(), false);
                if (takenStack.m_41619_()) {
                    Object[] objectArray = new Object[]{null, "Cannot extract item for equipment"};
                    MethodResult methodResult = MethodResult.of((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                    return methodResult;
                }
                equipResult = this.equipImpl(takenStack);
                if (equipResult.getFirst() == null) break block11;
                Object object = equipResult.getFirst();
                Intrinsics.checkNotNull((Object)object);
                if (((Boolean)object).booleanValue()) break block12;
            }
            storage.store((Object)takenStack, slot - 1, slot - 1, false);
            Object[] objectArray = new Object[]{equipResult.getFirst(), equipResult.getSecond()};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult unequip(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SlottedAgnosticStorage slottedAgnosticStorage = this.getPeripheralOwner().getStorage();
        if (slottedAgnosticStorage == null) {
            Object[] objectArray = new Object[]{null, "Cannot access inventory for some reason"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        SlottedAgnosticStorage storage = slottedAgnosticStorage;
        if (!this.getActiveUpgrades().contains(id)) {
            throw new LuaException("Cannot find upgrade with id " + id);
        }
        ItemStack stack = this.unequipImpl(id);
        if (stack.m_41619_()) {
            Object[] objectArray = new Object[]{null, "Cannot generate stack for unknown reason"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        BlockPos blockPos = this.getPeripheralOwner().getPos();
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        ItemStorageUtils.INSTANCE.toInventoryOrToWorld(stack, storage, 0, blockPos, level);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> getUpgrades() {
        return this.getActiveUpgrades();
    }

    private static final void attachUpgrade$lambda$0(ListTag $upgradeList, PeripheraliumHubPeripheral this$0, CompoundTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.m_128365_(UPGRADES_TAG, (Tag)$upgradeList);
        if (!((Collection)$upgradeList).isEmpty()) {
            it.m_128359_(MODE_TAG, this$0.getActiveMode());
        }
    }

    private static final void detachUpgrade$lambda$0(ListTag $upgradeList, CompoundTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.m_128365_(UPGRADES_TAG, (Tag)$upgradeList);
        if ($upgradeList.isEmpty()) {
            it.m_128473_(MODE_TAG);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/PeripheraliumHubPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "NETHERITE_TYPE", "UPGRADES_TAG", "MODE_TAG", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID$annotations", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "NETHERITE_ID", "getNETHERITE_ID$annotations", "getNETHERITE_ID", "TWEAKED_STORAGES", "getActiveUpgrades", "", "dataStorage", "Lsite/siredvin/tweakium/modules/peripheral/api/IDataStorage;", "getDataForUpgrade", "Lnet/minecraft/nbt/CompoundTag;", "id", "peripheralworks-forge-1.20.1"})
    @SourceDebugExtension(value={"SMAP\nPeripheraliumHubPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeripheraliumHubPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/PeripheraliumHubPeripheral$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1557#2:151\n1628#2,3:152\n*S KotlinDebug\n*F\n+ 1 PeripheraliumHubPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/PeripheraliumHubPeripheral$Companion\n*L\n33#1:151\n33#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public static /* synthetic */ void getID$annotations() {
        }

        @NotNull
        public final ResourceLocation getNETHERITE_ID() {
            return NETHERITE_ID;
        }

        public static /* synthetic */ void getNETHERITE_ID$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getActiveUpgrades(@NotNull IDataStorage dataStorage) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dataStorage, (String)"dataStorage");
            Iterable $this$map$iv = (Iterable)dataStorage.getList(PeripheraliumHubPeripheral.UPGRADES_TAG, 8);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tag tag = (Tag)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.m_7916_());
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final CompoundTag getDataForUpgrade(@NotNull String id, @NotNull IDataStorage dataStorage) {
            CompoundTag tweakedStorages;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)dataStorage, (String)"dataStorage");
            if (!dataStorage.has(PeripheraliumHubPeripheral.TWEAKED_STORAGES)) {
                dataStorage.putCompound(PeripheraliumHubPeripheral.TWEAKED_STORAGES, new CompoundTag());
            }
            if (!(tweakedStorages = dataStorage.getCompound(PeripheraliumHubPeripheral.TWEAKED_STORAGES)).m_128441_(id)) {
                tweakedStorages.m_128365_(id, (Tag)new CompoundTag());
            }
            CompoundTag compoundTag = tweakedStorages.m_128469_(id);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            return compoundTag;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

