/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.embers;

import com.rekindled.embers.api.power.IEmberCapability;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyStorageUtils;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.peripheralworks.common.setup.ModEnergies;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0016J&\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lsite/siredvin/peripheralworks/integrations/embers/AgnosticEmberStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "capability", "Lcom/rekindled/embers/api/power/IEmberCapability;", "<init>", "(Lcom/rekindled/embers/api/power/IEmberCapability;)V", "firstEnergy", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getFirstEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "maxStackSize", "", "getMaxStackSize", "()Ljava/lang/Long;", "operator", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "canExtract", "", "getCanExtract", "()Z", "getContent", "", "take", "predicate", "Ljava/util/function/Predicate;", "limit", "simulate", "canReceive", "getCanReceive", "unit", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "store", "stack", "setChanged", "", "peripheralworks-forge-1.20.1"})
public final class AgnosticEmberStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final IEmberCapability capability;

    public AgnosticEmberStorage(@NotNull IEmberCapability capability) {
        Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
        this.capability = capability;
    }

    @NotNull
    public AgnosticEnergyStack getFirstEnergy() {
        return new AgnosticEnergyStack(this.getUnit(), (long)this.capability.getEmber());
    }

    @NotNull
    public Long getMaxStackSize() {
        return (long)this.capability.getEmberCapacity();
    }

    @NotNull
    public SomethingOperator<AgnosticEnergyStack, Long> getOperator() {
        return (SomethingOperator)EnergyStorageUtils.INSTANCE;
    }

    public boolean getCanExtract() {
        return true;
    }

    @NotNull
    public Iterator<AgnosticEnergyStack> getContent() {
        return CollectionsKt.listOf((Object)this.getFirstEnergy()).iterator();
    }

    @NotNull
    public AgnosticEnergyStack take(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getFirstEnergy())) {
            return new AgnosticEnergyStack(this.getUnit(), 0L);
        }
        double actualLimit = RangesKt.coerceAtMost((double)limit, (double)this.capability.getEmber());
        if (!simulate) {
            IEmberCapability iEmberCapability = this.capability;
            iEmberCapability.setEmber(iEmberCapability.getEmber() - actualLimit);
        }
        return new AgnosticEnergyStack(this.getUnit(), (long)actualLimit);
    }

    public boolean getCanReceive() {
        return true;
    }

    @NotNull
    public final EnergyUnit getUnit() {
        return ModEnergies.INSTANCE.getEMBER();
    }

    @NotNull
    public AgnosticEnergyStack store(@NotNull AgnosticEnergyStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(this.getUnit())) {
            return stack;
        }
        double actualLimit = RangesKt.coerceAtMost((double)stack.getAmount(), (double)(this.capability.getEmberCapacity() - this.capability.getEmber()));
        if (!simulate) {
            IEmberCapability iEmberCapability = this.capability;
            iEmberCapability.setEmber(iEmberCapability.getEmber() + actualLimit);
        }
        return new AgnosticEnergyStack(this.getUnit(), stack.getAmount() - (long)actualLimit);
    }

    public void setChanged() {
        this.capability.onContentsChanged();
    }
}

