/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.occultism;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.base.api.AgnosticStorage;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStorage;", "Lsite/siredvin/broccolium/modules/storage/base/api/AgnosticStorage;", "Lnet/minecraft/world/item/ItemStack;", "", "storageController", "Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;", "<init>", "(Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;)V", "getContent", "", "maxStackSize", "getMaxStackSize", "()Ljava/lang/Integer;", "operator", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "setChanged", "", "store", "stack", "simulate", "", "take", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class OccultismItemStorage
implements AgnosticStorage<ItemStack, Integer> {
    @NotNull
    private final IStorageController storageController;

    public OccultismItemStorage(@NotNull IStorageController storageController) {
        Intrinsics.checkNotNullParameter((Object)storageController, (String)"storageController");
        this.storageController = storageController;
    }

    @NotNull
    public Iterator<ItemStack> getContent() {
        return this.storageController.getStacks().iterator();
    }

    @NotNull
    public Integer getMaxStackSize() {
        int n;
        if (((Boolean)Occultism.SERVER_CONFIG.storage.overrideItemStackSizes.get()).booleanValue()) {
            Object object = Occultism.SERVER_CONFIG.storage.controllerStackSize.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            n = ((Number)object).intValue();
        } else {
            n = 64;
        }
        return n;
    }

    @NotNull
    public SomethingOperator<ItemStack, Integer> getOperator() {
        return (SomethingOperator)ItemStorageUtils.INSTANCE;
    }

    public void setChanged() {
        this.storageController.onContentsChanged();
    }

    @NotNull
    public ItemStack store(@NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int returnedAmount = this.storageController.insertStack(stack, simulate);
        ItemStack itemStack = stack.m_255036_(returnedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack take(@NotNull Predicate<ItemStack> predicate, int limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ItemStack itemStack = this.storageController.getItemStack(predicate, limit, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        return itemStack;
    }
}

