/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.base.api.SlottedAgnosticStorage;
import site.siredvin.broccolium.modules.storage.item.ContainerWrapper;
import site.siredvin.broccolium.modules.storage.item.MergedContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ8\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsite/siredvin/peripheralworks/utils/MinecartUtils;", "", "<init>", "()V", "SEARCH_MARGIN", "", "getSearchShape", "Lnet/minecraft/world/phys/AABB;", "pos", "Lnet/minecraft/core/BlockPos;", "getMinecarts", "", "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;", "level", "Lnet/minecraft/world/level/Level;", "getContainerMinecarts", "Lnet/minecraft/world/entity/vehicle/AbstractMinecartContainer;", "minecartExtractor", "Lsite/siredvin/broccolium/modules/storage/base/api/SlottedAgnosticStorage;", "Lnet/minecraft/world/item/ItemStack;", "", "blockPos", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nMinecartUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecartUtils.kt\nsite/siredvin/peripheralworks/utils/MinecartUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1053#2:45\n*S KotlinDebug\n*F\n+ 1 MinecartUtils.kt\nsite/siredvin/peripheralworks/utils/MinecartUtils\n*L\n28#1:45\n*E\n"})
public final class MinecartUtils {
    @NotNull
    public static final MinecartUtils INSTANCE = new MinecartUtils();
    private static final double SEARCH_MARGIN = 0.2;

    private MinecartUtils() {
    }

    @NotNull
    public final AABB getSearchShape(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new AABB((double)pos.m_123341_() + 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.2, (double)(pos.m_123341_() + 1) - 0.2, (double)(pos.m_123342_() + 1) - 0.2, (double)(pos.m_123343_() + 1) - 0.2);
    }

    @NotNull
    public final List<AbstractMinecart> getMinecarts(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List list = level.m_45976_(AbstractMinecart.class, this.getSearchShape(pos));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AbstractMinecart it = (AbstractMinecart)a;
                boolean bl = false;
                Comparable comparable = it.m_20148_();
                it = (AbstractMinecart)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.m_20148_());
            }
        });
    }

    @NotNull
    public final List<AbstractMinecartContainer> getContainerMinecarts(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List list = level.m_45976_(AbstractMinecartContainer.class, this.getSearchShape(pos));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        return list;
    }

    @Nullable
    public final SlottedAgnosticStorage<ItemStack, Integer> minecartExtractor(@NotNull Level level, @NotNull BlockPos blockPos, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockState state = level.m_8055_(blockPos);
        if (!state.m_60713_(Blocks.f_50030_)) {
            return null;
        }
        List<AbstractMinecartContainer> containers = this.getContainerMinecarts(level, blockPos);
        if (containers.isEmpty()) {
            return null;
        }
        return (SlottedAgnosticStorage)new ContainerWrapper((Container)new MergedContainer(containers));
    }
}

