/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import site.siredvin.peripheralworks.common.block.FlexibleStatue;
import site.siredvin.peripheralworks.utils.QuadData;
import site.siredvin.peripheralworks.utils.QuadList;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a&\u0010\n\u001a\u00020\u00042\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a&\u0010\r\u001a\u00020\u00042\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"MAX_QUAD_VECTOR", "", "MIN_QUAD_VECTOR", "buildVector", "Lorg/joml/Vector3f;", "x", "y", "z", "min", "max", "convertToStartVector", "table", "", "convertToEndVector", "convertToQuadData", "Lsite/siredvin/peripheralworks/utils/QuadData;", "convertToQuadList", "Lsite/siredvin/peripheralworks/utils/QuadList;", "peripheralworks-forge-1.20.1"})
public final class QuadsKt {
    private static final float MAX_QUAD_VECTOR = 32.0f;
    private static final float MIN_QUAD_VECTOR = -32.0f;

    private static final Vector3f buildVector(float x, float y, float z, float min, float max) throws LuaException {
        if (x < min || y < min || z < min) {
            String string = "Coordinate lower then %.2f";
            Object[] objectArray = new Object[]{Float.valueOf(min)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new LuaException(string2);
        }
        if (x > max || y > max || z > max) {
            String string = "Coordinate bigger then %.2f";
            Object[] objectArray = new Object[]{Float.valueOf(min)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new LuaException(string3);
        }
        return new Vector3f(x, y, z);
    }

    @NotNull
    public static final Vector3f convertToStartVector(@NotNull Map<?, ?> table, float min, float max) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        if (!(table.containsKey("x1") && table.containsKey("y1") && table.containsKey("z1"))) {
            throw new LuaException("Table should have start coordinates");
        }
        Object x = table.get("x1");
        Object y = table.get("y1");
        Object z = table.get("z1");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should have start coordinates");
        }
        return QuadsKt.buildVector(((Number)x).floatValue(), ((Number)y).floatValue(), ((Number)z).floatValue(), min, max);
    }

    @NotNull
    public static final Vector3f convertToEndVector(@NotNull Map<?, ?> table, float min, float max) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        if (!(table.containsKey("x2") && table.containsKey("y2") && table.containsKey("z2"))) {
            throw new LuaException("Table should have end coordinates");
        }
        Object x = table.get("x2");
        Object y = table.get("y2");
        Object z = table.get("z2");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should have end coordinates");
        }
        return QuadsKt.buildVector(((Number)x).floatValue(), ((Number)y).floatValue(), ((Number)z).floatValue(), min, max);
    }

    @NotNull
    public static final QuadData convertToQuadData(@NotNull Map<?, ?> table) throws LuaException {
        float f;
        int tint;
        ResourceLocation texture;
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Vector3f startVector = QuadsKt.convertToStartVector(table, -32.0f, 32.0f);
        Vector3f endVector = QuadsKt.convertToEndVector(table, -32.0f, 32.0f);
        ResourceLocation resourceLocation = texture = table.containsKey("texture") ? new ResourceLocation(String.valueOf(table.get("texture"))) : FlexibleStatue.Companion.getWHITE_TEXTURE();
        if (table.containsKey("tint")) {
            Object obj = table.get("tint");
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            v2 = ((Number)obj).intValue();
        } else {
            v2 = tint = 0xFFFFFF;
        }
        if (table.containsKey("opacity")) {
            Object obj = table.get("opacity");
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            f = RangesKt.coerceAtMost((float)((Number)obj).floatValue(), (float)1.0f);
        } else {
            f = 1.0f;
        }
        float opacity = f;
        return new QuadData(startVector, endVector, texture, tint, opacity);
    }

    @NotNull
    public static final QuadList convertToQuadList(@NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        List data = new ArrayList();
        for (Object value : table.values()) {
            if (!(value instanceof Map)) {
                throw new LuaException("Table should be quad list");
            }
            data.add(QuadsKt.convertToQuadData((Map)value));
        }
        return new QuadList(data);
    }
}

