/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.powah;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u001e\u0010 \u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"2\u0006\u0010#\u001a\u00020\u0007H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0018\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/PowahEnergyStorageWrapper;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "storage", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "<init>", "(Lowmii/powah/lib/block/AbstractEnergyStorage;)V", "capacity", "", "getCapacity", "()J", "canExtract", "", "getCanExtract", "()Z", "energy", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "receiveRateLimit", "getReceiveRateLimit", "extractRateLimit", "getExtractRateLimit", "setChanged", "", "canReceive", "getCanReceive", "unit", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "storeEnergy", "stack", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class PowahEnergyStorageWrapper
implements AgnosticEnergyStorage {
    @NotNull
    private final AbstractEnergyStorage<?, ?> storage;

    public PowahEnergyStorageWrapper(@NotNull AbstractEnergyStorage<?, ?> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    public long getCapacity() {
        return this.storage.getEnergy().getCapacity();
    }

    public boolean getCanExtract() {
        return this.storage.canExtractEnergy(null);
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), this.storage.getEnergy().getStored());
    }

    public long getReceiveRateLimit() {
        AbstractBlock abstractBlock = this.storage.getBlock();
        AbstractEnergyBlock abstractEnergyBlock = abstractBlock instanceof AbstractEnergyBlock ? (AbstractEnergyBlock)abstractBlock : null;
        return abstractEnergyBlock != null && (abstractEnergyBlock = (IEnergyConfig)abstractEnergyBlock.getConfig()) != null ? abstractEnergyBlock.getTransfer((Enum)this.storage.getVariant()) : Long.MAX_VALUE;
    }

    public long getExtractRateLimit() {
        return this.getReceiveRateLimit();
    }

    public void setChanged() {
        this.storage.m_6596_();
    }

    public boolean getCanReceive() {
        return this.storage.canReceiveEnergy(null);
    }

    @NotNull
    public EnergyUnit getUnit() {
        return PlatformToolkit.INSTANCE.get().getCommonEnergy();
    }

    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(PlatformToolkit.INSTANCE.get().getCommonEnergy())) {
            return stack;
        }
        if (!this.storage.canReceiveEnergy(null)) {
            return stack;
        }
        long receivedEnergy = this.storage.receiveEnergy(stack.getAmount(), false, null);
        return stack.copyWithCount(stack.getAmount() - receivedEnergy);
    }

    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        long extractedEnergy = this.storage.extractEnergy(limit, false, null);
        if (extractedEnergy == 0L) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), extractedEnergy);
    }
}

