/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.item.DescriptiveItem;
import site.siredvin.peripheralworks.data.ModTooltip;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;
import site.siredvin.peripheralworks.subsystem.configurator.ConfiguratorModeRegistry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0007J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralworks/common/item/UltimateConfigurator;", "Lsite/siredvin/broccolium/modules/base/item/DescriptiveItem;", "<init>", "()V", "appendHoverText", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getActiveMode", "Lkotlin/Pair;", "Lsite/siredvin/peripheralworks/subsystem/configurator/ConfigurationMode;", "Lnet/minecraft/core/BlockPos;", "stack", "saveActiveMode", "mode", "targetBlock", "clearActiveMode", "tryActivateMode", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "use", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "isFoil", "", "Companion", "peripheralworks-forge-1.20.1"})
public final class UltimateConfigurator
extends DescriptiveItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTIVE_MOD_NAME = "activeMod";
    @NotNull
    public static final String ACTIVE_MOD_POS = "activeModPos";

    public UltimateConfigurator() {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.m_7373_(itemStack, level, list, tooltipFlag);
        Pair<ConfigurationMode, BlockPos> activeMode = this.getActiveMode(itemStack);
        if (activeMode != null) {
            list.add((Component)ModTooltip.ACTIVE_CONFIGURATION_MODE.getText());
            list.add(((ConfigurationMode)activeMode.getFirst()).getDescription());
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)((BlockPos)activeMode.getSecond()).toString(), (String)"toString(...)");
            list.add((Component)ModTooltip.CONFIGURATION_TARGET_BLOCK.format(objectArray));
            ((ConfigurationMode)activeMode.getFirst()).extraTooltips(itemStack, list);
        }
    }

    @Nullable
    public final Pair<ConfigurationMode, BlockPos> getActiveMode(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return null;
        }
        CompoundTag data = compoundTag;
        if (!data.m_128441_(ACTIVE_MOD_NAME)) {
            return null;
        }
        if (!data.m_128441_(ACTIVE_MOD_POS)) {
            return null;
        }
        ConfigurationMode configurationMode = ConfiguratorModeRegistry.INSTANCE.get(new ResourceLocation(data.m_128461_(ACTIVE_MOD_NAME)));
        if (configurationMode == null) {
            return null;
        }
        ConfigurationMode configurationMode2 = configurationMode;
        return new Pair((Object)configurationMode2, (Object)NbtUtils.m_129239_((CompoundTag)data.m_128469_(ACTIVE_MOD_POS)));
    }

    private final void saveActiveMode(ItemStack stack, ConfigurationMode mode, BlockPos targetBlock) {
        CompoundTag data = stack.m_41784_();
        data.m_128359_(ACTIVE_MOD_NAME, mode.getModeID().toString());
        data.m_128365_(ACTIVE_MOD_POS, (Tag)NbtUtils.m_129224_((BlockPos)targetBlock));
    }

    private final ItemStack clearActiveMode(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return stack;
        }
        CompoundTag data = compoundTag;
        data.m_128473_(ACTIVE_MOD_NAME);
        data.m_128473_(ACTIVE_MOD_POS);
        return stack;
    }

    private final InteractionResultHolder<ItemStack> tryActivateMode(ItemStack stack, Player player, BlockHitResult hit, Level level) {
        if (player.m_20089_() == Pose.CROUCHING) {
            BlockState targetState = level.m_8055_(hit.m_82425_());
            Intrinsics.checkNotNull((Object)targetState);
            ConfigurationMode possibleMode = ConfiguratorModeRegistry.INSTANCE.get(targetState);
            if (possibleMode != null) {
                BlockPos blockPos = hit.m_82425_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                this.saveActiveMode(stack, possibleMode, blockPos);
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (interactionHand == InteractionHand.OFF_HAND) {
            InteractionResultHolder interactionResultHolder = super.m_7203_(level, player, interactionHand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
            return interactionResultHolder;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            if (player.m_20089_() != Pose.CROUCHING) {
                Intrinsics.checkNotNull((Object)itemStack);
                Pair<ConfigurationMode, BlockPos> pair = this.getActiveMode(itemStack);
                if (pair == null) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemStack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                    return interactionResultHolder;
                }
                Pair<ConfigurationMode, BlockPos> activeModePair = pair;
                return ((ConfigurationMode)activeModePair.getFirst()).onBlockMiss((BlockPos)activeModePair.getSecond(), itemStack, player, level);
            }
            Intrinsics.checkNotNull((Object)itemStack);
        } else {
            Intrinsics.checkNotNull((Object)itemStack);
            Pair<ConfigurationMode, BlockPos> pair = this.getActiveMode(itemStack);
            if (pair == null) {
                Intrinsics.checkNotNull((Object)blockHitResult);
                return this.tryActivateMode(itemStack, player, blockHitResult, level);
            }
            Pair<ConfigurationMode, BlockPos> activeModePair = pair;
            ConfigurationMode configurationMode = (ConfigurationMode)activeModePair.getFirst();
            BlockPos blockPos = (BlockPos)activeModePair.getSecond();
            Intrinsics.checkNotNull((Object)blockHitResult);
            return configurationMode.onBlockClick(blockPos, itemStack, player, blockHitResult, level);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)this.clearActiveMode(itemStack));
        Intrinsics.checkNotNull((Object)interactionResultHolder);
        return interactionResultHolder;
    }

    public boolean m_5812_(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return this.getActiveMode(itemStack) != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralworks/common/item/UltimateConfigurator$Companion;", "", "<init>", "()V", "ACTIVE_MOD_NAME", "", "ACTIVE_MOD_POS", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

