/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.forge;

import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.networking.ClientNetworkContext;
import site.siredvin.peripheralworks.networking.MessageType;
import site.siredvin.peripheralworks.networking.NetworkMessage;
import site.siredvin.peripheralworks.networking.NetworkMessages;
import site.siredvin.peripheralworks.networking.ServerNetworkContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013JF\u0010\u0018\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0019\"\u000e\b\u0001\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u00190 R\"\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsite/siredvin/peripheralworks/forge/ForgeNetworkHandler;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "setLogger", "(Lorg/apache/logging/log4j/Logger;)V", "network", "Lnet/minecraftforge/network/simple/SimpleChannel;", "setup", "", "createClientboundPacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "packet", "Lsite/siredvin/peripheralworks/networking/NetworkMessage;", "Lsite/siredvin/peripheralworks/networking/ClientNetworkContext;", "createServerboundPacket", "Lnet/minecraft/network/protocol/game/ServerGamePacketListener;", "Lsite/siredvin/peripheralworks/networking/ServerNetworkContext;", "registerMainThread", "H", "T", "type", "Lsite/siredvin/peripheralworks/forge/ForgeNetworkHandler$MessageTypeImpl;", "direction", "Lnet/minecraftforge/network/NetworkDirection;", "handler", "Lkotlin/Function1;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "MessageTypeImpl", "peripheralworks-forge-1.20.1"})
public final class ForgeNetworkHandler {
    @NotNull
    public static final ForgeNetworkHandler INSTANCE = new ForgeNetworkHandler();
    private static Logger logger = LogManager.getLogger((String)"peripheralworks.networking");
    @NotNull
    private static final SimpleChannel network;

    private ForgeNetworkHandler() {
    }

    public final Logger getLogger() {
        return logger;
    }

    public final void setLogger(Logger logger) {
        ForgeNetworkHandler.logger = logger;
    }

    public final void setup() {
        MessageTypeImpl forgeType;
        for (MessageType<? extends NetworkMessage<ServerNetworkContext>> messageType : NetworkMessages.INSTANCE.getServerbound()) {
            Intrinsics.checkNotNull(messageType, (String)"null cannot be cast to non-null type site.siredvin.peripheralworks.forge.ForgeNetworkHandler.MessageTypeImpl<out site.siredvin.peripheralworks.networking.NetworkMessage<site.siredvin.peripheralworks.networking.ServerNetworkContext>>");
            forgeType = (MessageTypeImpl)messageType;
            this.registerMainThread(forgeType, NetworkDirection.PLAY_TO_SERVER, ForgeNetworkHandler::setup$lambda$0);
        }
        for (MessageType<NetworkMessage<ServerNetworkContext>> messageType : NetworkMessages.INSTANCE.getClientbound()) {
            Intrinsics.checkNotNull(messageType, (String)"null cannot be cast to non-null type site.siredvin.peripheralworks.forge.ForgeNetworkHandler.MessageTypeImpl<out site.siredvin.peripheralworks.networking.NetworkMessage<site.siredvin.peripheralworks.networking.ClientNetworkContext>>");
            forgeType = (MessageTypeImpl)messageType;
            this.registerMainThread(forgeType, NetworkDirection.PLAY_TO_CLIENT, ForgeNetworkHandler::setup$lambda$1);
        }
    }

    @NotNull
    public final Packet<ClientGamePacketListener> createClientboundPacket(@NotNull NetworkMessage<ClientNetworkContext> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Packet packet2 = network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_CLIENT);
        Intrinsics.checkNotNull((Object)packet2, (String)"null cannot be cast to non-null type net.minecraft.network.protocol.Packet<net.minecraft.network.protocol.game.ClientGamePacketListener>");
        return packet2;
    }

    @NotNull
    public final Packet<ServerGamePacketListener> createServerboundPacket(@NotNull NetworkMessage<ServerNetworkContext> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Packet packet2 = network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_SERVER);
        Intrinsics.checkNotNull((Object)packet2, (String)"null cannot be cast to non-null type net.minecraft.network.protocol.Packet<net.minecraft.network.protocol.game.ServerGamePacketListener>");
        return packet2;
    }

    public final <H, T extends NetworkMessage<H>> void registerMainThread(@NotNull MessageTypeImpl<T> type2, @NotNull NetworkDirection direction, @NotNull Function1<? super NetworkEvent.Context, ? extends H> handler) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        network.messageBuilder(type2.getKlass(), type2.getId(), direction).encoder(NetworkMessage::write).decoder((Function)type2.getReader()).consumerMainThread((arg_0, arg_1) -> ForgeNetworkHandler.registerMainThread$lambda$0(handler, arg_0, arg_1)).add();
    }

    private static final String _init_$lambda$0(String $version) {
        return $version;
    }

    private static final boolean _init_$lambda$1(String $version, String anObject) {
        Intrinsics.checkNotNullParameter((Object)anObject, (String)"anObject");
        return Intrinsics.areEqual((Object)$version, (Object)anObject);
    }

    private static final boolean _init_$lambda$2(String $version, String anObject) {
        Intrinsics.checkNotNullParameter((Object)anObject, (String)"anObject");
        return Intrinsics.areEqual((Object)$version, (Object)anObject);
    }

    private static final ServerNetworkContext setup$lambda$0(NetworkEvent.Context c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return () -> ForgeNetworkHandler.setup$lambda$0$0(c);
    }

    private static final ServerPlayer setup$lambda$0$0(NetworkEvent.Context $c) {
        ServerPlayer serverPlayer = $c.getSender();
        Intrinsics.checkNotNull((Object)serverPlayer);
        return serverPlayer;
    }

    private static final ClientNetworkContext setup$lambda$1(NetworkEvent.Context x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new ClientNetworkContext(){};
    }

    private static final void registerMainThread$lambda$0(Function1 $handler, NetworkMessage packet, Supplier contextSup) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)contextSup, (String)"contextSup");
        try {
            Object t = contextSup.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            packet.handle($handler.invoke(t));
        }
        catch (RuntimeException e) {
            logger.error("Failed handling packet", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            logger.error("Failed handling packet", (Throwable)e);
            throw e;
        }
    }

    static {
        String version = "1.0";
        SimpleChannel simpleChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"peripheralworks", (String)"network")).networkProtocolVersion(() -> ForgeNetworkHandler._init_$lambda$0(version)).clientAcceptedVersions(arg_0 -> ForgeNetworkHandler._init_$lambda$1(version, arg_0)).serverAcceptedVersions(arg_0 -> ForgeNetworkHandler._init_$lambda$2(version, arg_0)).simpleChannel();
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"simpleChannel(...)");
        network = simpleChannel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lsite/siredvin/peripheralworks/forge/ForgeNetworkHandler$MessageTypeImpl;", "T", "Lsite/siredvin/peripheralworks/networking/NetworkMessage;", "Lsite/siredvin/peripheralworks/networking/MessageType;", "id", "", "klass", "Ljava/lang/Class;", "reader", "Lnet/minecraft/network/FriendlyByteBuf$Reader;", "<init>", "(ILjava/lang/Class;Lnet/minecraft/network/FriendlyByteBuf$Reader;)V", "getId", "()I", "getKlass", "()Ljava/lang/Class;", "getReader", "()Lnet/minecraft/network/FriendlyByteBuf$Reader;", "peripheralworks-forge-1.20.1"})
    public static final class MessageTypeImpl<T extends NetworkMessage<?>>
    implements MessageType<T> {
        private final int id;
        @NotNull
        private final Class<T> klass;
        @NotNull
        private final FriendlyByteBuf.Reader<T> reader;

        public MessageTypeImpl(int id, @NotNull Class<T> klass, @NotNull FriendlyByteBuf.Reader<T> reader) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Intrinsics.checkNotNullParameter(reader, (String)"reader");
            this.id = id;
            this.klass = klass;
            this.reader = reader;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final Class<T> getKlass() {
            return this.klass;
        }

        @NotNull
        public final FriendlyByteBuf.Reader<T> getReader() {
            return this.reader;
        }
    }
}

