/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.client.configurator;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import site.siredvin.peripheralworks.client.configurator.ConfigurationModeRender;
import site.siredvin.peripheralworks.client.configurator.EntityLinkClientRenderer;
import site.siredvin.peripheralworks.client.configurator.NetworkManagerClientRender;
import site.siredvin.peripheralworks.client.configurator.PeripheralProxyClientRender;
import site.siredvin.peripheralworks.client.configurator.RemoteObserverClientRender;
import site.siredvin.peripheralworks.common.setup.Items;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;
import site.siredvin.peripheralworks.subsystem.configurator.EntityLinkMode;
import site.siredvin.peripheralworks.subsystem.configurator.NetworkManagerMode;
import site.siredvin.peripheralworks.subsystem.configurator.PeripheralProxyMode;
import site.siredvin.peripheralworks.subsystem.configurator.RemoteObserverMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006J6\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/client/configurator/ConfigurationModeRenderRegistry;", "", "<init>", "()V", "REGISTRY", "", "Lnet/minecraft/resources/ResourceLocation;", "Lsite/siredvin/peripheralworks/client/configurator/ConfigurationModeRender;", "register", "", "modeID", "render", "get", "minecraft", "Lnet/minecraft/client/Minecraft;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "partialTick", "", "camera", "Lnet/minecraft/client/Camera;", "gameRenderer", "Lnet/minecraft/client/renderer/GameRenderer;", "projectionMatrix", "Lorg/joml/Matrix4f;", "peripheralworks-forge-1.20.1"})
public final class ConfigurationModeRenderRegistry {
    @NotNull
    public static final ConfigurationModeRenderRegistry INSTANCE = new ConfigurationModeRenderRegistry();
    @NotNull
    private static final Map<ResourceLocation, ConfigurationModeRender> REGISTRY = new LinkedHashMap();

    private ConfigurationModeRenderRegistry() {
    }

    public final void register(@NotNull ResourceLocation modeID, @NotNull ConfigurationModeRender render) {
        Intrinsics.checkNotNullParameter((Object)modeID, (String)"modeID");
        Intrinsics.checkNotNullParameter((Object)render, (String)"render");
        REGISTRY.put(modeID, render);
    }

    @Nullable
    public final ConfigurationModeRender get(@NotNull ResourceLocation modeID) {
        Intrinsics.checkNotNullParameter((Object)modeID, (String)"modeID");
        return REGISTRY.get(modeID);
    }

    public final void render(@NotNull Minecraft minecraft, @NotNull PoseStack poseStack, float partialTick, @NotNull Camera camera, @NotNull GameRenderer gameRenderer, @NotNull Matrix4f projectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)gameRenderer, (String)"gameRenderer");
        Intrinsics.checkNotNullParameter((Object)projectionMatrix, (String)"projectionMatrix");
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (player.m_21205_().m_150930_((Item)Items.INSTANCE.getULTIMATE_CONFIGURATOR().get())) {
            ItemStack itemStack = player.m_21205_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            Pair<ConfigurationMode, BlockPos> pair = Items.INSTANCE.getULTIMATE_CONFIGURATOR().get().getActiveMode(itemStack);
            if (pair == null) {
                return;
            }
            Pair<ConfigurationMode, BlockPos> activeModePair = pair;
            ConfigurationModeRender configurationModeRender = this.get(((ConfigurationMode)activeModePair.getFirst()).getModeID());
            if (configurationModeRender == null) {
                return;
            }
            ConfigurationModeRender renderMode = configurationModeRender;
            renderMode.render(minecraft, (BlockPos)activeModePair.getSecond(), poseStack, partialTick, camera, gameRenderer, projectionMatrix);
        }
    }

    static {
        INSTANCE.register(RemoteObserverMode.INSTANCE.getModeID(), RemoteObserverClientRender.INSTANCE);
        INSTANCE.register(PeripheralProxyMode.INSTANCE.getModeID(), PeripheralProxyClientRender.INSTANCE);
        INSTANCE.register(EntityLinkMode.INSTANCE.getModeID(), EntityLinkClientRenderer.INSTANCE);
        INSTANCE.register(NetworkManagerMode.INSTANCE.getModeID(), NetworkManagerClientRender.INSTANCE);
    }
}

