/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.blockentity;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.block.FacingBlockEntityBlock;
import site.siredvin.peripheralworks.PeripheralWorksCore;
import site.siredvin.peripheralworks.common.block.EntityLink;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.common.item.EntityCard;
import site.siredvin.peripheralworks.common.setup.BlockEntityTypes;
import site.siredvin.peripheralworks.common.setup.Blocks;
import site.siredvin.peripheralworks.common.setup.Items;
import site.siredvin.peripheralworks.computercraft.operations.SphereOperations;
import site.siredvin.peripheralworks.computercraft.peripherals.EntityLinkPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IOwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoon;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.blockentity.MutablePeripheralBlockEntity;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.boon.ScanningBoon;
import site.siredvin.tweakium.modules.peripheral.owner.BasePeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.EntityProxyPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002:;B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u001dH\u0014J\u001c\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010*\u001a\u00020'H\u0002J \u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0006H\u0016J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\nJ\u000e\u00102\u001a\u00020#2\u0006\u00101\u001a\u00020\nJ\u0006\u00103\u001a\u00020\nJ\f\u00104\u001a\b\u0012\u0004\u0012\u00020\n05J\u001a\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u0002082\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u00109\u001a\u0002082\u0006\u00107\u001a\u000208H\u0016R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006<"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity;", "Lsite/siredvin/tweakium/modules/peripheral/blockentity/MutablePeripheralBlockEntity;", "Lsite/siredvin/peripheralworks/computercraft/peripherals/EntityLinkPeripheral;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "_storedStack", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/item/ItemStack;", "_entity", "Lnet/minecraft/world/entity/Entity;", "upgrades", "Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity$Upgrades;", "getUpgrades", "()Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity$Upgrades;", "value", "storedStack", "getStoredStack", "()Lnet/minecraft/world/item/ItemStack;", "setStoredStack", "(Lnet/minecraft/world/item/ItemStack;)V", "entity", "getEntity", "()Lnet/minecraft/world/entity/Entity;", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "createPeripheral", "side", "isSameEntity", "", "first", "second", "resetPeripheral", "", "updateEntity", "newEntity", "refreshEntity", "handleTick", "level", "Lnet/minecraft/world/level/Level;", "pos", "state", "isSuitableUpgrade", "stack", "injectUpgrade", "ejectUpgrade", "collectUpgrades", "", "loadInternalData", "data", "Lnet/minecraft/nbt/CompoundTag;", "saveInternalData", "Companion", "Upgrades", "peripheralworks-forge-1.20.1"})
public final class EntityLinkBlockEntity
extends MutablePeripheralBlockEntity<EntityLinkPeripheral> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ItemStack _storedStack;
    @Nullable
    private Entity _entity;
    @NotNull
    private final Upgrades upgrades;
    @NotNull
    public static final String STORED_CARD_TAG = "storedCard";
    @NotNull
    public static final String UPGRADES_TAG = "upgrades";

    public EntityLinkBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntityType<EntityLinkBlockEntity> blockEntityType = BlockEntityTypes.INSTANCE.getENTITY_LINK().get();
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"get(...)");
        super(blockEntityType, blockPos, blockState);
        this._storedStack = ItemStack.f_41583_;
        this.upgrades = new Upgrades(false, 1, null);
    }

    @NotNull
    public final Upgrades getUpgrades() {
        return this.upgrades;
    }

    @NotNull
    public final ItemStack getStoredStack() {
        ItemStack itemStack = this._storedStack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"_storedStack");
        return itemStack;
    }

    public final void setStoredStack(@NotNull ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.m_41619_()) {
            this._storedStack = ItemStack.f_41583_;
            this.refreshEntity();
            this.pushInternalDataChangeToClient((BlockState)this.m_58900_().m_61124_((Property)EntityLink.Companion.getCONFIGURED(), (Comparable)Boolean.valueOf(false)));
        } else if (value.m_150930_((Item)Items.INSTANCE.getENTITY_CARD().get())) {
            this._storedStack = value;
            this.refreshEntity();
            this.pushInternalDataChangeToClient((BlockState)this.m_58900_().m_61124_((Property)EntityLink.Companion.getCONFIGURED(), (Comparable)Boolean.valueOf(true)));
        } else {
            PeripheralWorksCore.INSTANCE.getLogger().warn("Something trying to set item that is not entity card to entity link!");
        }
    }

    @Nullable
    public final Entity getEntity() {
        if (!this._storedStack.m_41619_()) {
            ItemStack itemStack = this._storedStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"_storedStack");
            if (!EntityCard.Companion.isEmpty(itemStack) && this._entity == null) {
                this.refreshEntity();
            }
        }
        return this._entity;
    }

    @NotNull
    public final Direction getFacing() {
        Comparable comparable = this.m_58900_().m_61143_((Property)FacingBlockEntityBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Direction)comparable;
    }

    @NotNull
    protected EntityLinkPeripheral createPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (this._entity == null) {
            return new EntityLinkPeripheral(this, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)this, null, 2, null));
        }
        BlockEntity blockEntity = (BlockEntity)this;
        Entity entity = this._entity;
        Intrinsics.checkNotNull((Object)entity);
        EntityProxyPeripheralOwner owner = new EntityProxyPeripheralOwner(blockEntity, entity);
        if (this.upgrades.getScanner()) {
            BasePeripheralOwner.attachOperations$default((BasePeripheralOwner)((BasePeripheralOwner)owner), (double)0.0, (int)PeripheralWorksConfig.INSTANCE.getCooldownTresholdLevel(), (int)1, null);
            SphereOperations operation = SphereOperations.PORTABLE_UNIVERSAL_SCAN;
            int maxRadius = operation.getMaxFreeRadius();
            owner.attachBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getSCANNING(), (IPeripheralOwnerBoon)new ScanningBoon((IPeripheralOwner)owner, maxRadius).attachBlockScan((IPeripheralOperation)operation, new BiConsumer[0]).attachLivingEntityScan((IPeripheralOperation)operation, EntityLinkBlockEntity::createPeripheral$lambda$0, new BiConsumer[0]).attachItemScan((IPeripheralOperation)operation, new BiConsumer[0]).attachPlayerScan((IPeripheralOperation)operation, new BiConsumer[0]));
        }
        return new EntityLinkPeripheral(this, (IPeripheralOwner)owner);
    }

    private final boolean isSameEntity(Entity first, Entity second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)first.m_20148_(), (Object)second.m_20148_());
    }

    private final void resetPeripheral() {
        this.setPeripheral(null);
        this.pushInternalDataChangeToClient((BlockState)this.m_58900_().m_61124_((Property)EntityLink.Companion.getENTITY_TRIGGER(), (Comparable)Integer.valueOf((((Number)((Object)this.m_58900_().m_61143_((Property)EntityLink.Companion.getENTITY_TRIGGER()))).intValue() + 1) % 4)));
    }

    private final void updateEntity(Entity newEntity) {
        if (!this.isSameEntity(this._entity, newEntity)) {
            boolean isNull = newEntity == null || newEntity.m_213877_();
            this._entity = isNull ? null : newEntity;
            this.resetPeripheral();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void refreshEntity() {
        Entity entity = this._entity;
        boolean bl = entity != null ? entity.m_213877_() : false;
        if (bl) {
            this.updateEntity(null);
            return;
        }
        if (!this._storedStack.m_41619_()) {
            ItemStack itemStack = this._storedStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"_storedStack");
            if (!EntityCard.Companion.isEmpty(itemStack)) {
                Level level = ((BlockEntity)this).f_58857_;
                if (!(level instanceof ServerLevel)) return;
                ServerLevel serverLevel = (ServerLevel)level;
                if (serverLevel == null) {
                    return;
                }
                ServerLevel serverLevel2 = serverLevel;
                ItemStack itemStack2 = this._storedStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"_storedStack");
                UUID entityUUID = EntityCard.Companion.getEntityUUID(itemStack2);
                if (entityUUID == null) {
                    this.updateEntity(null);
                    return;
                }
                Entity entity2 = serverLevel2.m_8791_(entityUUID);
                if (entity2 == null) {
                    return;
                }
                Entity newEntity = entity2;
                this.updateEntity(newEntity);
                return;
            }
        }
        if (this._entity == null) return;
        this.updateEntity(null);
    }

    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getPeripheral() != null) {
            IOwnedPeripheral iOwnedPeripheral = this.getPeripheral();
            Intrinsics.checkNotNull((Object)iOwnedPeripheral);
            if (!((EntityLinkPeripheral)iOwnedPeripheral).getConfigured()) {
                IOwnedPeripheral iOwnedPeripheral2 = this.getPeripheral();
                Intrinsics.checkNotNull((Object)iOwnedPeripheral2);
                ((EntityLinkPeripheral)iOwnedPeripheral2).configure();
            }
        }
        this.refreshEntity();
        super.handleTick(level, pos, state);
    }

    public final boolean isSuitableUpgrade(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.m_150930_(Blocks.INSTANCE.getUNIVERSAL_SCANNER().get().m_5456_()) && !this.upgrades.getScanner();
    }

    public final boolean injectUpgrade(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_150930_(Blocks.INSTANCE.getUNIVERSAL_SCANNER().get().m_5456_()) && !this.upgrades.getScanner()) {
            this.upgrades.setScanner(true);
            this.resetPeripheral();
        }
        return false;
    }

    @NotNull
    public final ItemStack ejectUpgrade() {
        if (!this.upgrades.getScanner()) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        this.upgrades.setScanner(false);
        this.resetPeripheral();
        ItemStack itemStack = Blocks.INSTANCE.getUNIVERSAL_SCANNER().get().m_5456_().m_7968_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    @NotNull
    public final List<ItemStack> collectUpgrades() {
        if (this.upgrades.getScanner()) {
            return CollectionsKt.listOf((Object)Blocks.INSTANCE.getUNIVERSAL_SCANNER().get().m_5456_().m_7968_());
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public BlockState loadInternalData(@NotNull CompoundTag data, @Nullable BlockState state) {
        BlockState resultState;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BlockState blockState = state;
        if (blockState == null) {
            blockState = resultState = this.m_58900_();
        }
        if (data.m_128441_(STORED_CARD_TAG)) {
            this._storedStack = ItemStack.m_41712_((CompoundTag)data.m_128469_(STORED_CARD_TAG));
            resultState = (BlockState)resultState.m_61124_((Property)EntityLink.Companion.getCONFIGURED(), (Comparable)Boolean.valueOf(true));
        } else {
            resultState = (BlockState)resultState.m_61124_((Property)EntityLink.Companion.getCONFIGURED(), (Comparable)Boolean.valueOf(false));
        }
        if (data.m_128441_(UPGRADES_TAG)) {
            CompoundTag compoundTag = data.m_128469_(UPGRADES_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            this.upgrades.load(compoundTag);
        }
        BlockState blockState2 = resultState;
        Intrinsics.checkNotNull((Object)blockState2);
        return blockState2;
    }

    @NotNull
    public CompoundTag saveInternalData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this._storedStack.m_41619_()) {
            data.m_128365_(STORED_CARD_TAG, (Tag)this._storedStack.m_41739_(new CompoundTag()));
        }
        data.m_128365_(UPGRADES_TAG, (Tag)this.upgrades.save());
        return data;
    }

    private static final boolean createPeripheral$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity$Companion;", "", "<init>", "()V", "STORED_CARD_TAG", "", "UPGRADES_TAG", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity$Upgrades;", "", "scanner", "", "<init>", "(Z)V", "getScanner", "()Z", "setScanner", "save", "Lnet/minecraft/nbt/CompoundTag;", "load", "", "tag", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "peripheralworks-forge-1.20.1"})
    public static final class Upgrades {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean scanner;
        @NotNull
        public static final String SCANNER_TAG = "scanner";

        public Upgrades(boolean scanner) {
            this.scanner = scanner;
        }

        public /* synthetic */ Upgrades(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getScanner() {
            return this.scanner;
        }

        public final void setScanner(boolean bl) {
            this.scanner = bl;
        }

        @NotNull
        public final CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(SCANNER_TAG, this.scanner);
            return tag;
        }

        public final void load(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (tag.m_128441_(SCANNER_TAG)) {
                this.scanner = tag.m_128471_(SCANNER_TAG);
            }
        }

        public final boolean component1() {
            return this.scanner;
        }

        @NotNull
        public final Upgrades copy(boolean scanner) {
            return new Upgrades(scanner);
        }

        public static /* synthetic */ Upgrades copy$default(Upgrades upgrades, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = upgrades.scanner;
            }
            return upgrades.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Upgrades(scanner=" + this.scanner + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.scanner);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Upgrades)) {
                return false;
            }
            Upgrades upgrades = (Upgrades)other;
            return this.scanner == upgrades.scanner;
        }

        public Upgrades() {
            this(false, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity$Upgrades$Companion;", "", "<init>", "()V", "SCANNER_TAG", "", "peripheralworks-forge-1.20.1"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

