/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.item.DescriptiveItem;
import site.siredvin.peripheralworks.common.block.EntityLink;
import site.siredvin.peripheralworks.common.blockentity.EntityLinkBlockEntity;
import site.siredvin.peripheralworks.common.setup.Items;
import site.siredvin.peripheralworks.data.ModText;
import site.siredvin.peripheralworks.subsystem.entityperipheral.EntityPeripheralLookup;
import site.siredvin.peripheralworks.tags.EntityTags;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/peripheralworks/common/item/EntityCard;", "Lsite/siredvin/broccolium/modules/base/item/DescriptiveItem;", "<init>", "()V", "isFoil", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "appendHoverText", "", "itemStack", "level", "Lnet/minecraft/world/level/Level;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "Companion", "peripheralworks-forge-1.20.1"})
public final class EntityCard
extends DescriptiveItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    @NotNull
    private static final String ENTITY_UUID_TAG = "entityUUID";
    @NotNull
    private static final Map<Item, Function<Player, Entity>> EXTRA_SEARCHES = new LinkedHashMap();

    public EntityCard() {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        super(properties);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return !Companion.isEmpty(stack);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (!Companion.isEmpty(itemStack)) {
            list.add((Component)ModText.SOMETHING_STORED_INSIDE_CARD.getText());
        }
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        ItemStack itemInHand = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (interactionHand == InteractionHand.MAIN_HAND) {
            Intrinsics.checkNotNull((Object)itemInHand);
            if (!Companion.isEmpty(itemInHand)) {
                if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockEntity blockEntity = level.m_7702_(blockHitResult.m_82425_());
                    EntityLinkBlockEntity entityLinkBlockEntity = blockEntity instanceof EntityLinkBlockEntity ? (EntityLinkBlockEntity)blockEntity : null;
                    if (entityLinkBlockEntity == null) {
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemInHand);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                        return interactionResultHolder;
                    }
                    EntityLinkBlockEntity blockEntity2 = entityLinkBlockEntity;
                    if (((Boolean)blockEntity2.m_58900_().m_61143_((Property)EntityLink.Companion.getCONFIGURED())).booleanValue()) {
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemInHand);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                        return interactionResultHolder;
                    }
                    blockEntity2.setStoredStack(itemInHand);
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)ItemStack.f_41583_);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                    return interactionResultHolder;
                }
                if (level instanceof ServerLevel) {
                    UUID uUID = Companion.getEntityUUID(itemInHand);
                    if (uUID == null) {
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemInHand);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                        return interactionResultHolder;
                    }
                    UUID entityUUID = uUID;
                    Entity entity = ((ServerLevel)level).m_8791_(entityUUID);
                    if (entity == null) {
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemInHand);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                        return interactionResultHolder;
                    }
                    Entity entity2 = entity;
                    Object[] objectArray = new Object[]{entity2.m_7755_().getString(), entity2.m_20183_().toString()};
                    player.m_5661_((Component)ModText.TARGET_ENTITY.format(objectArray), false);
                }
            } else {
                Entity newEntity;
                ItemStack itemInOffhand = player.m_21120_(InteractionHand.OFF_HAND);
                Function<Player, Entity> extraLogic = EXTRA_SEARCHES.get(itemInOffhand.m_41720_());
                if (extraLogic != null && (newEntity = extraLogic.apply(player)) != null) {
                    Companion.storeEntity(itemInHand, newEntity);
                }
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)itemInHand);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                return interactionResultHolder;
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)itemInHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        ItemStack itemInHand = player2.m_21120_(InteractionHand.MAIN_HAND);
        if (itemInHand.m_150930_((Item)Items.INSTANCE.getENTITY_CARD().get())) {
            Intrinsics.checkNotNull((Object)itemInHand);
            if (Companion.isEmpty(itemInHand)) {
                Entity newEntity;
                ItemStack itemInOffhand = player2.m_21120_(InteractionHand.OFF_HAND);
                Function<Player, Entity> extraLogic = EXTRA_SEARCHES.get(itemInOffhand.m_41720_());
                if (extraLogic != null && (newEntity = extraLogic.apply(player2)) != null) {
                    Companion.storeEntity(itemInHand, newEntity);
                }
                return InteractionResult.CONSUME;
            }
        }
        InteractionResult interactionResult = super.m_6225_(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R+\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/common/item/EntityCard$Companion;", "", "<init>", "()V", "CUSTOM_MODEL_DATA_TAG", "", "ENTITY_UUID_TAG", "EXTRA_SEARCHES", "", "Lnet/minecraft/world/item/Item;", "Ljava/util/function/Function;", "Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/entity/Entity;", "getEXTRA_SEARCHES", "()Ljava/util/Map;", "isEmpty", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "isEntityMatching", "entity", "storeEntity", "", "getEntityUUID", "Ljava/util/UUID;", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Item, Function<Player, Entity>> getEXTRA_SEARCHES() {
            return EXTRA_SEARCHES;
        }

        public final boolean isEmpty(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag == null) {
                return true;
            }
            CompoundTag itemTag = compoundTag;
            return !itemTag.m_128441_(CUSTOM_MODEL_DATA_TAG);
        }

        public final boolean isEntityMatching(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (entity.m_6095_().m_204039_(EntityTags.INSTANCE.getLINK_BLOCKLIST())) {
                return false;
            }
            return !EntityPeripheralLookup.INSTANCE.collectPlugins(entity).isEmpty();
        }

        public final void storeEntity(@NotNull ItemStack itemStack, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            CompoundTag itemTag = itemStack.m_41784_();
            itemTag.m_128344_(CUSTOM_MODEL_DATA_TAG, (byte)1);
            itemTag.m_128362_(ENTITY_UUID_TAG, entity.m_20148_());
        }

        @Nullable
        public final UUID getEntityUUID(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag == null) {
                return null;
            }
            CompoundTag itemTag = compoundTag;
            if (!itemTag.m_128441_(ENTITY_UUID_TAG)) {
                return null;
            }
            return itemTag.m_128342_(ENTITY_UUID_TAG);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

