/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.peripheralworks.common.block.BasePedestal;
import site.siredvin.peripheralworks.common.blockentity.DisplayPedestalBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.representation.RepresentationMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001e2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bH\u0007J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0007J\b\u0010\u0014\u001a\u00020\bH\u0007J\b\u0010\u0015\u001a\u00020\bH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0007J\u0013\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/DisplayPedestalPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/DisplayPedestalBlockEntity;", "blockEntity", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/DisplayPedestalBlockEntity;)V", "isEnabled", "", "()Z", "getItem", "", "", "", "setItem", "Ldan200/computercraft/api/lua/MethodResult;", "id", "name", "Ljava/util/Optional;", "nbtData", "isLabelRendered", "isItemRendered", "setLabelRendered", "", "value", "setItemRendered", "equals", "other", "hashCode", "", "Companion", "peripheralworks-forge-1.20.1"})
public final class DisplayPedestalPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<DisplayPedestalBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DisplayPedestalBlockEntity blockEntity;
    @NotNull
    public static final String TYPE = "display_pedestal";

    public DisplayPedestalPeripheral(@NotNull DisplayPedestalBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, BasePedestal.Companion.getFACING()));
        this.blockEntity = blockEntity;
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableDisplayPedestal();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> getItem() {
        if (this.blockEntity.getStoredStack().m_41619_()) {
            return null;
        }
        return LuaRepresentation.INSTANCE.forItemStack(this.blockEntity.getStoredStack(), RepresentationMode.FULL);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult setItem(@NotNull String id, @NotNull Optional<String> name, @NotNull Optional<String> nbtData) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(nbtData, (String)"nbtData");
        Item item = (Item)PlatformRegistries.INSTANCE.getITEMS().get(new ResourceLocation(id));
        if (Intrinsics.areEqual((Object)item, (Object)Items.f_41852_)) {
            Object[] objectArray = new Object[]{null, "Cannot find item with id " + id};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (nbtData.isPresent()) {
            stack.m_41751_(TagParser.m_129359_((String)nbtData.get()));
        }
        if (name.isPresent()) {
            stack.m_41714_((Component)Component.m_237113_((String)name.get()));
        }
        this.blockEntity.setStoredStack(stack);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    public final boolean isLabelRendered() {
        return this.blockEntity.getRenderLabel();
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemRendered() {
        return this.blockEntity.getRenderItem();
    }

    @LuaFunction(mainThread=true)
    public final void setLabelRendered(boolean value) {
        this.blockEntity.setRenderLabel(value);
    }

    @LuaFunction(mainThread=true)
    public final void setItemRendered(boolean value) {
        this.blockEntity.setRenderItem(value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplayPedestalPeripheral)) {
            return false;
        }
        if (!super.equals((IPeripheral)other)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.blockEntity, (Object)((DisplayPedestalPeripheral)((Object)other)).blockEntity);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.blockEntity.hashCode();
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/DisplayPedestalPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

