/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.common.blockentity.EntityLinkBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.subsystem.entityperipheral.EntityPeripheralLookup;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\tH\u0007J\u0016\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001b"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/EntityLinkPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "blockEntity", "Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity;", "owner", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/EntityLinkBlockEntity;Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "_configured", "", "configured", "getConfigured", "()Z", "buildPlugins", "", "configure", "isEntityFound", "inspect", "", "", "", "hashCode", "", "equals", "other", "isEnabled", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nEntityLinkPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityLinkPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/EntityLinkPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1863#2,2:87\n1863#2,2:89\n*S KotlinDebug\n*F\n+ 1 EntityLinkPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/EntityLinkPeripheral\n*L\n39#1:87,2\n60#1:89,2\n*E\n"})
public final class EntityLinkPeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityLinkBlockEntity blockEntity;
    private boolean _configured;
    @NotNull
    public static final String TYPE = "entity_link";
    @NotNull
    private static final List<BiConsumer<Entity, Map<String, Object>>> ENRICHERS = new ArrayList();

    public EntityLinkPeripheral(@NotNull EntityLinkBlockEntity blockEntity, @NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
        this.blockEntity = blockEntity;
    }

    public final boolean getConfigured() {
        return this.getInitialized();
    }

    protected void buildPlugins() {
        this.getPlugins().clear();
        if (this.blockEntity.getEntity() != null) {
            Entity entity = this.blockEntity.getEntity();
            Intrinsics.checkNotNull((Object)entity);
            Map<String, IPeripheralPlugin> plugins = EntityPeripheralLookup.INSTANCE.collectPlugins(entity);
            Iterable $this$forEach$iv = plugins.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPeripheralPlugin p0 = (IPeripheralPlugin)element$iv;
                boolean bl = false;
                this.addPlugin(p0);
            }
        }
        super.buildPlugins();
        this.setInitialized(this.blockEntity.m_58904_() instanceof ServerLevel);
    }

    public final void configure() {
        this.buildPlugins();
    }

    @LuaFunction(mainThread=true)
    public final boolean isEntityFound() {
        return this.blockEntity.getEntity() != null;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> inspect() {
        Map map;
        Entity entity = this.blockEntity.getEntity();
        if (entity == null) {
            return null;
        }
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity) {
            Direction direction = this.blockEntity.getFacing();
            BlockPos blockPos = this.blockEntity.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            map = LuaRepresentation.INSTANCE.withPos(entity2, direction, blockPos, (Function1)new Function1<LivingEntity, Map<String, Object>>((Object)LuaRepresentation.INSTANCE){

                public final Map<String, Object> invoke(LivingEntity p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((LuaRepresentation)this.receiver).forLivingEntity(p0);
                }
            });
        } else {
            Direction direction = this.blockEntity.getFacing();
            BlockPos blockPos = this.blockEntity.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            map = LuaRepresentation.INSTANCE.withPos(entity2, direction, blockPos, (Function1)new Function1<Entity, Map<String, Object>>((Object)LuaRepresentation.INSTANCE){

                public final Map<String, Object> invoke(Entity p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((LuaRepresentation)this.receiver).forEntity(p0);
                }
            });
        }
        Map baseData2 = map;
        Iterable $this$forEach$iv = ENRICHERS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BiConsumer it = (BiConsumer)element$iv;
            boolean bl = false;
            it.accept(entity2, baseData2);
        }
        return baseData2;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.blockEntity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityLinkPeripheral)) {
            return false;
        }
        if (!super.equals((IPeripheral)other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.blockEntity), (Object)((Object)((EntityLinkPeripheral)((Object)other)).blockEntity))) {
            return false;
        }
        return this._configured == ((EntityLinkPeripheral)((Object)other))._configured;
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableEntityLink();
    }

    private static final void _init_$lambda$1(Entity entity, Map data) {
        Intrinsics.checkNotNull((Object)data);
        data.put("yRot", Float.valueOf(entity.m_146908_()));
        data.put("xRot", Float.valueOf(entity.m_146909_()));
    }

    static {
        ENRICHERS.add(EntityLinkPeripheral::_init_$lambda$1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R/\u0010\u0006\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/EntityLinkPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "ENRICHERS", "", "Ljava/util/function/BiConsumer;", "Lnet/minecraft/world/entity/Entity;", "", "getENRICHERS", "()Ljava/util/List;", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BiConsumer<Entity, Map<String, Object>>> getENRICHERS() {
            return ENRICHERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

