/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.common.blockentity.NetworkManagerBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00192\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u001a"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/NetworkManagerPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/NetworkManagerBlockEntity;", "be", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/NetworkManagerBlockEntity;)V", "isEnabled", "", "()Z", "getGroups", "", "", "addGroup", "Ldan200/computercraft/api/lua/MethodResult;", "group", "removeGroup", "add", "peripheral", "remove", "setGroupColor", "color", "", "getGroupColor", "get", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNetworkManagerPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkManagerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/NetworkManagerPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n774#2:91\n865#2,2:92\n37#3,2:94\n*S KotlinDebug\n*F\n+ 1 NetworkManagerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/NetworkManagerPeripheral\n*L\n86#1:91\n86#1:92,2\n86#1:94,2\n*E\n"})
public final class NetworkManagerPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<NetworkManagerBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkManagerBlockEntity be;
    @NotNull
    public static final String TYPE = "network_manager";

    public NetworkManagerPeripheral(@NotNull NetworkManagerBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)be, null, 2, null));
        this.be = be;
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableNetworkManager();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> getGroups() {
        return CollectionsKt.toList((Iterable)this.be.getPeripheralGroups().keySet());
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult addGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (this.be.getPeripheralGroups().containsKey(group)) {
            Object[] objectArray = new Object[]{false, "Such group already exists"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        this.be.getPeripheralGroups().put(group, new NetworkManagerBlockEntity.PeripheralGroup());
        this.be.pushData();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult removeGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (this.be.getPeripheralGroups().containsKey(group)) {
            Object[] objectArray = new Object[]{false, "Group does not exists"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        Intrinsics.checkNotNull((Object)peripheralGroup);
        if (!((Collection)peripheralGroup.getPeripherals()).isEmpty()) {
            Object[] objectArray = new Object[]{false, "Group is not empty"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        this.be.getPeripheralGroups().remove(group);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult add(@NotNull String group, @NotNull String peripheral) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        if (!this.be.getPeripherals().containsKey(peripheral)) {
            Object[] objectArray = new Object[]{false, "There is no such peripheral"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        if (peripheralGroup == null) {
            Object[] objectArray = new Object[]{false, "There is no such group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup groupInstance = peripheralGroup;
        if (groupInstance.getPeripherals().contains(peripheral)) {
            Object[] objectArray = new Object[]{false, "Peripheral already in the group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        groupInstance.getPeripherals().add(peripheral);
        Object[] objectArray = new Object[]{group, "added", peripheral};
        this.queueEvent("network_manager_group_change", objectArray);
        this.be.pushData();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult remove(@NotNull String group, @NotNull String peripheral) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        if (!this.be.getPeripherals().containsKey(peripheral)) {
            Object[] objectArray = new Object[]{false, "There is no such peripheral"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        if (peripheralGroup == null) {
            Object[] objectArray = new Object[]{false, "There is no such group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup groupInstance = peripheralGroup;
        if (!groupInstance.getPeripherals().contains(peripheral)) {
            Object[] objectArray = new Object[]{false, "Peripheral not in the group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        groupInstance.getPeripherals().remove(peripheral);
        Object[] objectArray = new Object[]{group, "removed", peripheral};
        this.queueEvent("network_manager_group_change", objectArray);
        this.be.pushData();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult setGroupColor(@NotNull String group, int color) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (!this.be.getPeripheralGroups().containsKey(group)) {
            Object[] objectArray = new Object[]{false, "There is no such group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        Intrinsics.checkNotNull((Object)peripheralGroup);
        peripheralGroup.setColor(color);
        this.be.pushData();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getGroupColor(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        if (!this.be.getPeripheralGroups().containsKey(group)) {
            Object[] objectArray = new Object[]{false, "There is no such group"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        Intrinsics.checkNotNull((Object)peripheralGroup);
        MethodResult methodResult = MethodResult.of((Object)peripheralGroup.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult get(@NotNull String group) {
        void $this$toTypedArray$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = this.be.getPeripheralGroups().get(group);
        if (peripheralGroup == null) {
            MethodResult methodResult = MethodResult.of();
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        NetworkManagerBlockEntity.PeripheralGroup group2 = peripheralGroup;
        Iterable $this$filter$iv = group2.getPeripherals();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.be.getPeripherals().containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        MethodResult methodResult = MethodResult.of((Object[])Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/NetworkManagerPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

