/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.api.ISyncingBlockEntity;
import site.siredvin.broccolium.modules.base.util.world.ScanUtils;
import site.siredvin.peripheralworks.common.block.FlexibleRealityAnchor;
import site.siredvin.peripheralworks.common.blockentity.FlexibleRealityAnchorBlockEntity;
import site.siredvin.peripheralworks.common.blockentity.RealityForgerBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.tags.BlockTags;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.LuaInterpretation;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.util.ValidationHelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 22\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002J@\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0014\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u001fH\u0002J\u001a\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00190!H\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007JL\u0010&\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u00100'2\u000e\u0010(\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0014\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u001fJ\u0018\u0010+\u001a\u00020#2\u000e\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0007J\u0010\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u0013\u0010/\u001a\u00020\b2\b\u00100\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u00101\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/RealityForgerBlockEntity;", "blockEntity", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/RealityForgerBlockEntity;)V", "isEnabled", "", "()Z", "interactionRadius", "", "getInteractionRadius", "()I", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "parseMap", "", "realityMirror", "Lsite/siredvin/peripheralworks/common/blockentity/FlexibleRealityAnchorBlockEntity;", "table", "", "forgeRealityTileEntity", "targetState", "Lnet/minecraft/world/level/block/state/BlockState;", "appearanceTable", "flagTable", "Ljava/util/Optional;", "detectAnchors", "", "clearAnchors", "Ldan200/computercraft/api/lua/MethodResult;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "forgeRealityPiecesInner", "Lkotlin/Pair;", "posesMap", "stateTable", "flags", "batchForgeRealityPieces", "batch", "forgeRealityPieces", "forgeReality", "equals", "other", "hashCode", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRealityForgerPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealityForgerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n216#2,2:215\n1863#3,2:217\n1863#3,2:219\n*S KotlinDebug\n*F\n+ 1 RealityForgerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral\n*L\n50#1:215,2\n106#1:217,2\n134#1:219,2\n*E\n"})
public final class RealityForgerPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<RealityForgerBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "reality_forger";
    @NotNull
    private static final Map<String, BooleanProperty> FLAG_MAPPING;

    public RealityForgerPeripheral(@NotNull RealityForgerBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, null, 2, null));
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableRealityForger();
    }

    private final int getInteractionRadius() {
        return PeripheralWorksConfig.INSTANCE.getRealityForgerMaxRange();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map data = super.getPeripheralConfiguration();
        data.put("interactionRadius", this.getInteractionRadius());
        return data;
    }

    private final void parseMap(FlexibleRealityAnchorBlockEntity realityMirror, Map<?, ?> table) {
        Map<?, ?> $this$forEach$iv = table;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue() instanceof Boolean) {
                BooleanProperty targetProperty = FLAG_MAPPING.get(String.valueOf(it.getKey()));
                if (targetProperty == null) continue;
                Object obj = it.getValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
                realityMirror.setBooleanStateValue(targetProperty, (Boolean)obj);
                continue;
            }
            if (!Intrinsics.areEqual(it.getKey(), (Object)"lightLevel") || !(it.getValue() instanceof Number)) continue;
            Object obj = it.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            realityMirror.setLightLevel(((Number)obj).intValue());
        }
    }

    private final void forgeRealityTileEntity(FlexibleRealityAnchorBlockEntity realityMirror, BlockState targetState, Map<?, ?> appearanceTable, Optional<Map<?, ?>> flagTable) {
        this.parseMap(realityMirror, appearanceTable);
        flagTable.ifPresent(arg_0 -> RealityForgerPeripheral.forgeRealityTileEntity$lambda$2(arg_0 -> RealityForgerPeripheral.forgeRealityTileEntity$lambda$1(this, realityMirror, arg_0), arg_0));
        if (targetState != null) {
            FlexibleRealityAnchorBlockEntity.setMimic$default(realityMirror, targetState, null, false, 6, null);
        } else {
            ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)realityMirror), null, (int)1, null);
        }
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> detectAnchors() {
        List data = new ArrayList();
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level, (BlockPos)((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (int)this.getInteractionRadius(), (arg_0, arg_1) -> RealityForgerPeripheral.detectAnchors$lambda$3(this, data, arg_0, arg_1), (boolean)false, null, (int)48, null);
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult clearAnchors(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        List poses = new ArrayList();
        Optional posesTable = arguments.optTable(0);
        if (posesTable.isEmpty()) {
            Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level, (BlockPos)((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (int)this.getInteractionRadius(), (arg_0, arg_1) -> RealityForgerPeripheral.clearAnchors$lambda$4(this, poses, arg_0, arg_1), (boolean)false, null, (int)48, null);
        } else {
            for (Object value : ((Map)posesTable.get()).values()) {
                if (!(value instanceof Map)) {
                    throw new LuaException("First argument should be list of block positions");
                }
                poses.add(LuaInterpretation.INSTANCE.asBlockPos(((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (Map)value, ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getFacing()));
            }
        }
        Iterable $this$forEach$iv = poses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
            BlockEntity blockEntity = level != null ? level.m_7702_(it) : null;
            FlexibleRealityAnchorBlockEntity flexibleRealityAnchorBlockEntity = blockEntity instanceof FlexibleRealityAnchorBlockEntity ? (FlexibleRealityAnchorBlockEntity)blockEntity : null;
            if (flexibleRealityAnchorBlockEntity == null) continue;
            FlexibleRealityAnchorBlockEntity.setMimic$default(flexibleRealityAnchorBlockEntity, null, null, false, 6, null);
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final Pair<Boolean, String> forgeRealityPiecesInner(@NotNull Map<?, ?> posesMap, @NotNull Map<?, ?> stateTable, @NotNull Optional<Map<?, ?>> flags) {
        Intrinsics.checkNotNullParameter(posesMap, (String)"posesMap");
        Intrinsics.checkNotNullParameter(stateTable, (String)"stateTable");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        List poses = new ArrayList();
        for (Object value : posesMap.values()) {
            if (!(value instanceof Map)) {
                throw new LuaException("First argument should be list of block positions");
            }
            poses.add(LuaInterpretation.INSTANCE.asBlockPos(((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (Map)value, ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getFacing()));
        }
        List entities = new ArrayList();
        for (BlockPos pos : poses) {
            FlexibleRealityAnchorBlockEntity entity;
            if (!ValidationHelpersKt.radiusCorrect((BlockPos)pos, (BlockPos)((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (int)this.getInteractionRadius())) {
                return new Pair(null, (Object)"One of blocks are too far away");
            }
            Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            BlockEntity blockEntity = level.m_7702_(pos);
            if ((blockEntity instanceof FlexibleRealityAnchorBlockEntity ? (FlexibleRealityAnchorBlockEntity)blockEntity : null) == null) {
                return new Pair(null, (Object)"One of provided coordinate are not correct");
            }
            entity = entity;
            entities.add(entity);
        }
        BlockState targetState = LuaInterpretation.INSTANCE.asBlockState(stateTable);
        if (targetState.m_204336_(BlockTags.INSTANCE.getREALITY_FORGER_FORBIDDEN())) {
            throw new LuaException("You cannot use this block, is blocklisted");
        }
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlexibleRealityAnchorBlockEntity it = (FlexibleRealityAnchorBlockEntity)((Object)element$iv);
            boolean bl = false;
            this.forgeRealityTileEntity(it, targetState, stateTable, flags);
        }
        return new Pair((Object)true, null);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult batchForgeRealityPieces(@NotNull Map<?, ?> batch) throws LuaException {
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        for (Object batchRecord : batch.values()) {
            Optional<Map<?, ?>> flags;
            Pair<Boolean, String> result;
            Optional<Map<?, ?>> optional;
            Map state;
            Map poses;
            Map map = batchRecord instanceof Map ? (Map)batchRecord : null;
            if (map == null) {
                throw new LuaException("Element of batch should be maps");
            }
            Map recordMap = map;
            Object v = recordMap.get(1.0);
            if ((v instanceof Map ? (Map)v : null) == null) {
                throw new LuaException("First element of batch should be table with poses");
            }
            poses = poses;
            Object v2 = recordMap.get(2.0);
            if ((v2 instanceof Map ? (Map)v2 : null) == null) {
                throw new LuaException("Second element of batch should be table with block state");
            }
            state = state;
            Object possibleFlags = recordMap.get(3.0);
            if (possibleFlags == null) {
                var9_9 = Optional.empty();
                Intrinsics.checkNotNull(var9_9);
                optional = var9_9;
            } else {
                Map map2 = possibleFlags instanceof Map ? (Map)possibleFlags : null;
                if (map2 == null) {
                    throw new LuaException("Thrid element of batch should be table with flags or null");
                }
                var9_9 = Optional.of(map2);
                Intrinsics.checkNotNull(var9_9);
                optional = var9_9;
            }
            if (Intrinsics.areEqual((Object)(result = this.forgeRealityPiecesInner(poses, state, flags = optional)).getFirst(), (Object)true)) continue;
            Object[] objectArray = new Object[]{result.getFirst(), result.getSecond()};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult forgeRealityPieces(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map map = arguments.getTable(0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTable(...)");
        Map map2 = arguments.getTable(1);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getTable(...)");
        Optional optional = arguments.optTable(2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optTable(...)");
        Pair<Boolean, String> result = this.forgeRealityPiecesInner(map, map2, optional);
        if (Intrinsics.areEqual((Object)result.getFirst(), (Object)true)) {
            MethodResult methodResult = MethodResult.of((Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Object[] objectArray = new Object[]{result.getFirst(), result.getSecond()};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult forgeReality(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map table = arguments.getTable(0);
        Intrinsics.checkNotNull((Object)table);
        BlockState targetState = LuaInterpretation.INSTANCE.asBlockState(table);
        if (((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel() == null) {
            Object[] objectArray = new Object[]{null, "Level is not loaded, what?"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (targetState.m_204336_(BlockTags.INSTANCE.getREALITY_FORGER_FORBIDDEN())) {
            throw new LuaException("You cannot use this block, is blocklisted");
        }
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level, (BlockPos)((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (int)this.getInteractionRadius(), (arg_0, arg_1) -> RealityForgerPeripheral.forgeReality$lambda$7(this, targetState, table, arguments, arg_0, arg_1), (boolean)false, null, (int)48, null);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealityForgerPeripheral)) {
            return false;
        }
        if (!super.equals((IPeripheral)other)) {
            return false;
        }
        if (this.isEnabled() != ((RealityForgerPeripheral)((Object)other)).isEnabled()) {
            return false;
        }
        if (this.getInteractionRadius() != ((RealityForgerPeripheral)((Object)other)).getInteractionRadius()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getPeripheralOwner(), (Object)((RealityForgerPeripheral)((Object)other)).getPeripheralOwner());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.isEnabled());
        result = 31 * result + this.getInteractionRadius();
        result = 31 * result + ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).hashCode();
        return result;
    }

    private static final Unit forgeRealityTileEntity$lambda$1(RealityForgerPeripheral this$0, FlexibleRealityAnchorBlockEntity $realityMirror, Map it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$realityMirror), (String)"$realityMirror");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.parseMap($realityMirror, it);
        return Unit.INSTANCE;
    }

    private static final void forgeRealityTileEntity$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void detectAnchors$lambda$3(RealityForgerPeripheral this$0, List $data, BlockState blockState, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level = ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlexibleRealityAnchorBlockEntity) {
            $data.add(LuaRepresentation.INSTANCE.forBlockPos(pos, ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getFacing(), ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getPos()));
        }
    }

    private static final void clearAnchors$lambda$4(RealityForgerPeripheral this$0, List $poses, BlockState blockState, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$poses, (String)"$poses");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level = ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlexibleRealityAnchorBlockEntity) {
            $poses.add(pos);
        }
    }

    private static final void forgeReality$lambda$7(RealityForgerPeripheral this$0, BlockState $targetState, Map $table, IArguments $arguments, BlockState blockState, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$targetState, (String)"$targetState");
        Intrinsics.checkNotNullParameter((Object)$arguments, (String)"$arguments");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Level level = ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof FlexibleRealityAnchorBlockEntity) {
            FlexibleRealityAnchorBlockEntity flexibleRealityAnchorBlockEntity = (FlexibleRealityAnchorBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)$table);
            Optional optional = $arguments.optTable(1);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optTable(...)");
            this$0.forgeRealityTileEntity(flexibleRealityAnchorBlockEntity, $targetState, $table, optional);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"playerPassable", (Object)FlexibleRealityAnchor.Companion.getPLAYER_PASSABLE()), TuplesKt.to((Object)"lightPassable", (Object)FlexibleRealityAnchor.Companion.getLIGHT_PASSABLE()), TuplesKt.to((Object)"skyLightPassable", (Object)FlexibleRealityAnchor.Companion.getSKY_LIGHT_PASSABLE()), TuplesKt.to((Object)"invisible", (Object)FlexibleRealityAnchor.Companion.getINVISIBLE())};
        FLAG_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "FLAG_MAPPING", "", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

