/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.tweakium.modules.peripheral.BoundMethod;
import site.siredvin.tweakium.modules.peripheral.api.IExpandedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.util.ValidationHelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\b\u0010\u0015\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/NoteBlockPlugin;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "getNote", "", "getInstrument", "", "setNote", "", "note", "setInstrument", "instrument", "play", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNoteBlockPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoteBlockPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/NoteBlockPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class NoteBlockPlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos pos;
    private static final int lowerNote;
    private static final int upperNote;

    public NoteBlockPlugin(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.level = level;
        this.pos = pos;
    }

    private final BlockState getBlockState() {
        BlockState state = this.level.m_8055_(this.pos);
        if (!(state.m_60734_() instanceof NoteBlock)) {
            throw new LuaException("Target block is not note block at all!");
        }
        Intrinsics.checkNotNull((Object)state);
        return state;
    }

    @LuaFunction(mainThread=true)
    public final int getNote() {
        Comparable comparable = this.getBlockState().m_61143_((Property)NoteBlock.f_55013_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return ((Number)((Object)comparable)).intValue();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final String getInstrument() {
        String string = ((NoteBlockInstrument)this.getBlockState().m_61143_((Property)NoteBlock.f_55011_)).name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @LuaFunction(mainThread=true)
    public final void setNote(int note) {
        ValidationHelpersKt.assertBetween((int)note, (int)lowerNote, (int)upperNote, (String)"note");
        this.level.m_46597_(this.pos, (BlockState)this.getBlockState().m_61124_((Property)NoteBlock.f_55013_, (Comparable)Integer.valueOf(note)));
    }

    @LuaFunction(mainThread=true)
    public final void setInstrument(@NotNull String instrument) {
        Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
        try {
            String string = instrument.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            NoteBlockInstrument instrumentValue = NoteBlockInstrument.valueOf((String)string);
            this.level.m_46597_(this.pos, (BlockState)this.getBlockState().m_61124_((Property)NoteBlock.f_55011_, (Comparable)instrumentValue));
        }
        catch (IllegalArgumentException exc) {
            String allValues = CollectionsKt.joinToString$default((Iterable)((Iterable)EntriesMappings.entries$0), (CharSequence)", ", null, null, (int)0, null, NoteBlockPlugin::setInstrument$lambda$0, (int)30, null);
            throw new LuaException("Instrument should be one of: " + allValues);
        }
    }

    @LuaFunction(mainThread=true)
    public final void play() {
        this.level.m_7696_(this.pos, Blocks.f_50065_, 0, 0);
        this.level.m_142346_(null, GameEvent.f_223699_, this.pos);
    }

    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this, (MinecraftServer)server);
    }

    public void onFirstAttach() {
        IPeripheralPlugin.DefaultImpls.onFirstAttach((IPeripheralPlugin)this);
    }

    public void onLastDetach() {
        IPeripheralPlugin.DefaultImpls.onLastDetach((IPeripheralPlugin)this);
    }

    public void collectConfiguration(@NotNull Map<String, Object> data) {
        IPeripheralPlugin.DefaultImpls.collectConfiguration((IPeripheralPlugin)this, data);
    }

    @Nullable
    public IExpandedPeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IExpandedPeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IExpandedPeripheral)value);
    }

    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType((IPeripheralPlugin)this);
    }

    @NotNull
    public List<String> getAdditionalTypes() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalTypes((IPeripheralPlugin)this);
    }

    private static final CharSequence setInstrument$lambda$0(NoteBlockInstrument mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        String string = mode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    static {
        Comparable comparable;
        Companion = new Companion(null);
        Collection collection = NoteBlock.f_55013_.m_6908_();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPossibleValues(...)");
        Iterator iterator = ((Iterable)collection).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable<Integer> it = (Integer)iterator.next();
        boolean bl = false;
        it = it;
        while (iterator.hasNext()) {
            Comparable<Integer> it2 = (Integer)iterator.next();
            $i$a$-minOf-NoteBlockPlugin$Companion$lowerNote$1 = false;
            if (it.compareTo((Integer)(it2 = (Comparable)it2)) <= 0) continue;
            it = it2;
        }
        Comparable<Integer> comparable2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"minOf(...)");
        lowerNote = ((Number)((Object)comparable2)).intValue();
        Collection collection2 = NoteBlock.f_55013_.m_6908_();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPossibleValues(...)");
        iterator = ((Iterable)collection2).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (Integer)iterator.next();
        boolean bl2 = false;
        comparable = comparable;
        while (iterator.hasNext()) {
            Comparable comparable3;
            Integer it3 = (Integer)iterator.next();
            $i$a$-maxOf-NoteBlockPlugin$Companion$upperNote$1 = false;
            if (comparable.compareTo(comparable3 = (Comparable)comparable3) >= 0) continue;
            comparable = comparable3;
        }
        Comparable comparable4 = comparable;
        Intrinsics.checkNotNullExpressionValue((Object)comparable4, (String)"maxOf(...)");
        upperNote = ((Number)((Object)comparable4)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/NoteBlockPlugin$Companion;", "", "<init>", "()V", "lowerNote", "", "getLowerNote", "()I", "upperNote", "getUpperNote", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLowerNote() {
            return lowerNote;
        }

        public final int getUpperNote() {
            return upperNote;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<NoteBlockInstrument> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])NoteBlockInstrument.values()));
        }
    }
}

