/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.item.ContainerWrapper;
import site.siredvin.broccolium.modules.storage.item.MergedContainer;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.peripheralworks.utils.MinecartUtils;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.plugins.AbstractInventoryPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0007J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/PoweredRailPlugin;", "Lsite/siredvin/tweakium/modules/plugins/AbstractInventoryPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "getLevel", "()Lnet/minecraft/world/level/Level;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "storage", "Lsite/siredvin/broccolium/modules/storage/item/api/SlottedAgnosticItemStorage;", "getStorage", "()Lsite/siredvin/broccolium/modules/storage/item/api/SlottedAgnosticItemStorage;", "isPowered", "", "pushMinecarts", "", "reverse", "Ljava/util/Optional;", "getMinecartsLua", "", "", "", "", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nPoweredRailPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoweredRailPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/PoweredRailPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n774#2:68\n865#2,2:69\n1863#2,2:71\n1557#2:73\n1628#2,3:74\n*S KotlinDebug\n*F\n+ 1 PoweredRailPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/PoweredRailPlugin\n*L\n59#1:68\n59#1:69,2\n59#1:71,2\n65#1:73\n65#1:74,3\n*E\n"})
public final class PoweredRailPlugin
extends AbstractInventoryPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos pos;
    public static final double PUSH_POWER = 5.0;

    public PoweredRailPlugin(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.level = level;
        this.pos = pos;
    }

    @NotNull
    public Level getLevel() {
        return this.level;
    }

    private final BlockState getBlockState() {
        BlockState state = this.getLevel().m_8055_(this.pos);
        if (!(state.m_60734_() instanceof PoweredRailBlock)) {
            throw new LuaException("Target block is not note block at all!");
        }
        Intrinsics.checkNotNull((Object)state);
        return state;
    }

    @NotNull
    public SlottedAgnosticItemStorage getStorage() {
        return (SlottedAgnosticItemStorage)new ContainerWrapper((Container)new MergedContainer(MinecartUtils.INSTANCE.getContainerMinecarts(this.getLevel(), this.pos)));
    }

    @LuaFunction(mainThread=true)
    public final boolean isPowered() {
        Comparable comparable = this.getBlockState().m_61143_((Property)PoweredRailBlock.f_55215_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Boolean)comparable;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    public final void pushMinecarts(@NotNull Optional<Boolean> reverse) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(reverse, (String)"reverse");
        RailShape orientation = (RailShape)this.getBlockState().m_61143_((Property)PoweredRailBlock.f_55214_);
        Boolean isReversed = reverse.orElse(false);
        RailShape railShape = orientation;
        Vec3 moveVector = switch (railShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[railShape.ordinal()]) {
            case 1 -> new Vec3(0.0, 0.0, isReversed != false ? 5.0 : -5.0);
            case 2 -> new Vec3(isReversed != false ? -5.0 : 5.0, 0.0, 0.0);
            case 3 -> new Vec3(isReversed != false ? -5.0 : 5.0, 0.0, 0.0);
            case 4 -> new Vec3(isReversed != false ? 5.0 : -5.0, 0.0, 0.0);
            case 5 -> new Vec3(0.0, 0.0, isReversed != false ? 5.0 : -5.0);
            case 6 -> new Vec3(0.0, 0.0, isReversed != false ? -5.0 : 5.0);
            case 7 -> {
                if (isReversed.booleanValue()) {
                    yield new Vec3(0.0, 0.0, 5.0);
                }
                yield new Vec3(5.0, 0.0, 0.0);
            }
            case 8 -> {
                if (isReversed.booleanValue()) {
                    yield new Vec3(0.0, 0.0, 5.0);
                }
                yield new Vec3(-5.0, 0.0, 0.0);
            }
            case 9 -> {
                if (isReversed.booleanValue()) {
                    yield new Vec3(0.0, 0.0, -5.0);
                }
                yield new Vec3(-5.0, 0.0, 0.0);
            }
            case 10 -> {
                if (isReversed.booleanValue()) {
                    yield new Vec3(0.0, 0.0, -5.0);
                }
                yield new Vec3(5.0, 0.0, 0.0);
            }
            default -> new Vec3(0.0, 0.0, isReversed != false ? 5.0 : -5.0);
        };
        Iterable $this$filter$iv = MinecartUtils.INSTANCE.getMinecarts(this.getLevel(), this.pos);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AbstractMinecart it = (AbstractMinecart)element$iv$iv;
            boolean bl = false;
            if (!(it.m_20184_().m_82553_() == 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractMinecart it = (AbstractMinecart)element$iv;
            boolean bl = false;
            it.m_20256_(moveVector);
        }
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(value={"getMinecarts"}, mainThread=true)
    @NotNull
    public final List<Map<String, Object>> getMinecartsLua() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = MinecartUtils.INSTANCE.getMinecarts(this.getLevel(), this.pos);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractMinecart abstractMinecart = (AbstractMinecart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LuaRepresentation.INSTANCE.forEntity((Entity)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/PoweredRailPlugin$Companion;", "", "<init>", "()V", "PUSH_POWER", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RailShape.values().length];
            try {
                nArray[RailShape.NORTH_SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.EAST_WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.ASCENDING_EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.ASCENDING_WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.ASCENDING_NORTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.ASCENDING_SOUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.SOUTH_EAST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.SOUTH_WEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.NORTH_WEST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RailShape.NORTH_EAST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

