/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.computercraft.plugins.specific.BeaconPlugin;
import site.siredvin.peripheralworks.computercraft.plugins.specific.JukeboxPlugin;
import site.siredvin.peripheralworks.computercraft.plugins.specific.LecternPlugin;
import site.siredvin.peripheralworks.computercraft.plugins.specific.NoteBlockPlugin;
import site.siredvin.peripheralworks.computercraft.plugins.specific.PoweredRailPlugin;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/SpecificPluginProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
public final class SpecificPluginProvider
implements PeripheralPluginProvider {
    @NotNull
    public static final SpecificPluginProvider INSTANCE = new SpecificPluginProvider();

    private SpecificPluginProvider() {
    }

    @Override
    @NotNull
    public String getPluginType() {
        return "minecraft";
    }

    @Override
    @Nullable
    public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (Intrinsics.areEqual((Object)block, (Object)Blocks.f_50065_)) {
            if (PeripheralWorksConfig.INSTANCE.getEnableNoteBlock()) {
                return new NoteBlockPlugin(level, pos);
            }
        } else if (Intrinsics.areEqual((Object)block, (Object)Blocks.f_50030_) && PeripheralWorksConfig.INSTANCE.getEnablePoweredRail()) {
            return (IPeripheralPlugin)new PoweredRailPlugin(level, pos);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        BlockEntity entity = blockEntity;
        Class<?> clazz = entity.getClass();
        return Intrinsics.areEqual(clazz, LecternBlockEntity.class) ? (IPeripheralPlugin)(PeripheralWorksConfig.INSTANCE.getEnableLectern() ? new LecternPlugin((LecternBlockEntity)entity) : null) : (Intrinsics.areEqual(clazz, BeaconBlockEntity.class) ? (IPeripheralPlugin)(PeripheralWorksConfig.INSTANCE.getEnableBeacon() ? new BeaconPlugin((BeaconBlockEntity)entity) : null) : (Intrinsics.areEqual(clazz, JukeboxBlockEntity.class) ? (IPeripheralPlugin)(PeripheralWorksConfig.INSTANCE.getEnableJukebox() ? new JukeboxPlugin((JukeboxBlockEntity)entity) : null) : null));
    }

    @Override
    public int getPriority() {
        return PeripheralPluginProvider.DefaultImpls.getPriority(this);
    }

    @Override
    @NotNull
    public Set<String> getConflictWith() {
        return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
    }

    @Override
    public int compareTo(@NotNull PeripheralPluginProvider other) {
        return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
    }
}

