/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.google.common.collect.ImmutableSet;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.platform.api.RegistryWrapper;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.integrations.ae2.AE2Helper;
import site.siredvin.peripheralworks.integrations.ae2.Configuration;
import site.siredvin.tweakium.modules.peripheral.BoundMethod;
import site.siredvin.tweakium.modules.peripheral.api.IExpandedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0007J\u0018\u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r0\u0011H\u0007J\u0018\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r0\u0011H\u0007J\u0018\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r0\u0011H\u0007J(\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r0\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J4\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "<init>", "(Lnet/minecraft/world/level/Level;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "getAverageEnergyDemand", "", "getAverageEnergyIncome", "getChannelEnergyDemand", "getChannelInformation", "", "", "", "getCraftingCPUs", "", "getCraftableItems", "getCraftableFluids", "getPatternsFor", "mode", "id_key", "getActiveCraftings", "Ldan200/computercraft/api/lua/MethodResult;", "scheduleCrafting", "amount", "Ljava/util/Optional;", "", "targetCPU", "Companion", "Provider", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nMENetworkBlockPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MENetworkBlockPlugin.kt\nsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,209:1\n1863#2,2:210\n1863#2,2:212\n1863#2,2:214\n1863#2:216\n1864#2:223\n1863#2,2:224\n230#2,2:226\n13346#3,2:217\n13346#3:219\n13346#3,2:220\n13347#3:222\n*S KotlinDebug\n*F\n+ 1 MENetworkBlockPlugin.kt\nsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin\n*L\n77#1:210,2\n94#1:212,2\n104#1:214,2\n120#1:216\n120#1:223\n154#1:224,2\n196#1:226,2\n124#1:217,2\n125#1:219\n132#1:220,2\n125#1:222\n*E\n"})
public final class MENetworkBlockPlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Level level;
    @NotNull
    private final AENetworkBlockEntity entity;
    @NotNull
    public static final String PLUGIN_TYPE = "ae2";

    public MENetworkBlockPlugin(@NotNull Level level, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.level = level;
        this.entity = entity;
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getEnergyService()) == null) {
            return 0.0;
        }
        IGrid energyService = iGrid;
        return energyService.getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyIncome() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getEnergyService()) == null) {
            return 0.0;
        }
        IGrid energyService = iGrid;
        return energyService.getAvgPowerInjection();
    }

    @LuaFunction(mainThread=true)
    public final double getChannelEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getEnergyService()) == null) {
            return 0.0;
        }
        IGrid energyService = iGrid;
        return energyService.getChannelPowerUsage();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getChannelInformation() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getPathingService()) == null) {
            return MapsKt.emptyMap();
        }
        IGrid pathingService = iGrid;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"maxChannels", (Object)pathingService.getChannelMode().getAdHocNetworkChannels()), TuplesKt.to((Object)"usedChannels", (Object)pathingService.getUsedChannels())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftingCPUs() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            return CollectionsKt.emptyList();
        }
        IGrid craftingService = iGrid;
        List data = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getCpus(...)");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            Map cpuInformation = new LinkedHashMap();
            if (it.getName() != null) {
                Component component = it.getName();
                Intrinsics.checkNotNull((Object)component);
                cpuInformation.put("name", component.getString());
            }
            cpuInformation.put("capacity", 1 + it.getCoProcessors());
            cpuInformation.put("storage", it.getAvailableStorage());
            cpuInformation.put("isBusy", it.isBusy());
            data.add(cpuInformation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableItems() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            return CollectionsKt.emptyList();
        }
        IGrid craftingService = iGrid;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableItems$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getCraftables(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEItemKey");
            Item item = ((AEItemKey)it).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            data.add(LuaRepresentation.INSTANCE.forItem(item));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableFluids() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            return CollectionsKt.emptyList();
        }
        IGrid craftingService = iGrid;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableFluids$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getCraftables(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            RegistryWrapper registryWrapper = PlatformRegistries.INSTANCE.getFLUIDS();
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
            data.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)registryWrapper.getKey((Object)((AEFluidKey)it).getFluid()).toString())));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getPatternsFor(@NotNull String mode, @NotNull String id_key) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            return CollectionsKt.emptyList();
        }
        IGrid craftingService = iGrid;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        Collection patterns = craftingService.getCraftingFor(key);
        List data = new ArrayList();
        Intrinsics.checkNotNull((Object)patterns);
        Iterable $this$forEach$iv = patterns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericStack it;
            IPatternDetails pattern = (IPatternDetails)element$iv;
            boolean bl = false;
            Map patternRepresentation = new LinkedHashMap();
            List outputs = new ArrayList();
            List inputs = new ArrayList();
            GenericStack[] genericStackArray = pattern.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)genericStackArray, (String)"getOutputs(...)");
            Object[] $this$forEach$iv2 = genericStackArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (GenericStack)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                outputs.add(AE2Helper.INSTANCE.genericStackToMap(it));
            }
            IPatternDetails.IInput[] iInputArray = pattern.getInputs();
            Intrinsics.checkNotNullExpressionValue((Object)iInputArray, (String)"getInputs(...)");
            $this$forEach$iv2 = iInputArray;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (IPatternDetails.IInput)element$iv2;
                boolean bl3 = false;
                Map inputData = null;
                if (it.getPossibleInputs().length == 1) {
                    GenericStack genericStack = it.getPossibleInputs()[0];
                    Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"get(...)");
                    Map map = inputData = AE2Helper.INSTANCE.genericStackToMap(genericStack);
                    var25_25 = "count";
                    Object object = inputData.get("count");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                    Double d = ((Number)object).doubleValue() * (double)it.getMultiplier();
                    map.put((String)var25_25, (Object)d);
                } else {
                    List inputVariants = new ArrayList();
                    GenericStack[] genericStackArray2 = it.getPossibleInputs();
                    Intrinsics.checkNotNullExpressionValue((Object)genericStackArray2, (String)"getPossibleInputs(...)");
                    Object[] $this$forEach$iv3 = genericStackArray2;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Map<String, Object> pInputResult;
                        GenericStack pInput = (GenericStack)element$iv3;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)pInput);
                        Map<String, Object> map = pInputResult = AE2Helper.INSTANCE.genericStackToMap(pInput);
                        String string = "count";
                        Object object = pInputResult.get("count");
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                        Double d = ((Number)object).doubleValue() * (double)it.getMultiplier();
                        map.put(string, d);
                        inputVariants.add(pInputResult);
                    }
                    var25_25 = new Pair[]{TuplesKt.to((Object)"variants", (Object)inputVariants)};
                    inputData = MapsKt.mutableMapOf((Pair[])var25_25);
                }
                inputs.add(inputData);
            }
            patternRepresentation.put("inputs", inputs);
            patternRepresentation.put("outputs", outputs);
            data.add(patternRepresentation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getActiveCraftings() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IGrid craftingService = iGrid;
        List craftingList = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getCpus(...)");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CraftingJobStatus jobStatus;
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            if (!it.isBusy() || it.getJobStatus() == null) continue;
            Intrinsics.checkNotNull((Object)it.getJobStatus());
            Pair[] pairArray = new Pair[3];
            GenericStack genericStack = jobStatus.crafting();
            Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"crafting(...)");
            pairArray[0] = TuplesKt.to((Object)"target", AE2Helper.INSTANCE.genericStackToMap(genericStack));
            pairArray[1] = TuplesKt.to((Object)"amount", (Object)jobStatus.totalItems());
            pairArray[2] = TuplesKt.to((Object)"progress", (Object)jobStatus.progress());
            Map baseMap = MapsKt.mutableMapOf((Pair[])pairArray);
            if (it.getName() != null) {
                Component component = it.getName();
                Intrinsics.checkNotNull((Object)component);
                baseMap.put("CPU", component.getString());
            }
            craftingList.add(baseMap);
        }
        MethodResult methodResult = MethodResult.of((Object)craftingList);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LuaFunction(mainThread=false)
    @NotNull
    public final MethodResult scheduleCrafting(@NotNull String mode, @NotNull String id_key, @NotNull Optional<Long> amount, @NotNull Optional<String> targetCPU) {
        ICraftingCPU iCraftingCPU;
        long realAmount;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(targetCPU, (String)"targetCPU");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        if (iGrid == null || (iGrid = iGrid.getCraftingService()) == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IGrid craftingService = iGrid;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        IActionSource source = IActionSource.ofMachine((IActionHost)((IActionHost)this.entity));
        Future future = craftingService.beginCraftingCalculation(this.level, () -> MENetworkBlockPlugin.scheduleCrafting$lambda$10(source), key, realAmount = (Intrinsics.areEqual((Object)mode, (Object)"item") ? amount.orElse(1L) : Long.valueOf(((Number)amount.orElse(1000L)).longValue() * (long)PlatformToolkit.INSTANCE.get().getFluidCompactDivider())).longValue(), CalculationStrategy.REPORT_MISSING_ITEMS);
        ICraftingPlan plan = (ICraftingPlan)future.get();
        if (!plan.missingItems().isEmpty()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = false;
            objectArray[1] = "Missing items";
            KeyCounter keyCounter = plan.missingItems();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"missingItems(...)");
            objectArray[2] = AE2Helper.keyCounterToLua$default(AE2Helper.INSTANCE, keyCounter, null, false, 6, null);
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (targetCPU.isPresent()) {
            ICraftingCPU iCraftingCPU2;
            try {
                Object element$iv;
                boolean bl;
                ImmutableSet immutableSet = craftingService.getCpus();
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getCpus(...)");
                Iterable $this$first$iv = (Iterable)immutableSet;
                boolean $i$f$first = false;
                Iterator iterator = $this$first$iv.iterator();
                do {
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    element$iv = iterator.next();
                    ICraftingCPU it = (ICraftingCPU)element$iv;
                    boolean bl2 = false;
                    if (it.getName() != null) {
                        Component component = it.getName();
                        Intrinsics.checkNotNull((Object)component);
                        if (component.getString().equals(targetCPU.get())) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                iCraftingCPU2 = (ICraftingCPU)element$iv;
            }
            catch (NoSuchElementException e) {
                Object[] objectArray = new Object[]{null, "Cannot find target CPU"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
            iCraftingCPU = iCraftingCPU2;
        } else {
            iCraftingCPU = null;
        }
        ICraftingCPU realTargetCPU = iCraftingCPU;
        craftingService.submitJob(plan, null, realTargetCPU, false, source);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this, (MinecraftServer)server);
    }

    public void onFirstAttach() {
        IPeripheralPlugin.DefaultImpls.onFirstAttach((IPeripheralPlugin)this);
    }

    public void onLastDetach() {
        IPeripheralPlugin.DefaultImpls.onLastDetach((IPeripheralPlugin)this);
    }

    public void collectConfiguration(@NotNull Map<String, Object> data) {
        IPeripheralPlugin.DefaultImpls.collectConfiguration((IPeripheralPlugin)this, data);
    }

    @Nullable
    public IExpandedPeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IExpandedPeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IExpandedPeripheral)value);
    }

    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType((IPeripheralPlugin)this);
    }

    @NotNull
    public List<String> getAdditionalTypes() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalTypes((IPeripheralPlugin)this);
    }

    private static final boolean getCraftableItems$lambda$1(AEKey it) {
        return it instanceof AEItemKey;
    }

    private static final boolean getCraftableFluids$lambda$3(AEKey it) {
        return it instanceof AEFluidKey;
    }

    private static final IActionSource scheduleCrafting$lambda$10(IActionSource $source) {
        return $source;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Companion;", "", "<init>", "()V", "PLUGIN_TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Provider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class Provider
    implements PeripheralPluginProvider {
        @NotNull
        public static final Provider INSTANCE = new Provider();

        private Provider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return MENetworkBlockPlugin.PLUGIN_TYPE;
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (!Configuration.INSTANCE.getEnableMEInterface()) {
                return null;
            }
            BlockEntity entity = level.m_7702_(pos);
            if (!(entity instanceof AENetworkBlockEntity)) {
                return null;
            }
            return new MENetworkBlockPlugin(level, (AENetworkBlockEntity)entity);
        }

        @Override
        public int getPriority() {
            return PeripheralPluginProvider.DefaultImpls.getPriority(this);
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }
}

