/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.integrateddynamics;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.integrations.integrateddynamics.Configuration;
import site.siredvin.peripheralworks.integrations.integrateddynamics.IntegratedDynamicProxy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lsite/siredvin/peripheralworks/integrations/integrateddynamics/IntegratedDynamicsAPI;", "Ldan200/computercraft/api/lua/ILuaAPI;", "computerID", "", "<init>", "(I)V", "getNames", "", "", "()[Ljava/lang/String;", "getInput", "Ldan200/computercraft/api/lua/MethodResult;", "getOutput", "setOutput", "json", "peripheralworks-forge-1.20.1"})
public final class IntegratedDynamicsAPI
implements ILuaAPI {
    private final int computerID;

    public IntegratedDynamicsAPI(int computerID) {
        this.computerID = computerID;
    }

    @NotNull
    public String[] getNames() {
        String[] stringArray = new String[]{"integrated_dynamics"};
        return stringArray;
    }

    @LuaFunction
    @NotNull
    public final MethodResult getInput() {
        Tag tag = IntegratedDynamicProxy.INSTANCE.getInputData().get(this.computerID);
        if (tag == null) {
            MethodResult methodResult = MethodResult.of(null);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Tag inputData = tag;
        MethodResult methodResult = MethodResult.of((Object)NBTUtil.toLua((Tag)inputData));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction
    @NotNull
    public final MethodResult getOutput() {
        CompoundTag compoundTag = IntegratedDynamicProxy.INSTANCE.getOutputData().get(this.computerID);
        if (compoundTag == null) {
            MethodResult methodResult = MethodResult.of(null);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        CompoundTag inputData = compoundTag;
        MethodResult methodResult = MethodResult.of((Object)NBTUtil.toLua((Tag)((Tag)inputData)));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction
    @NotNull
    public final MethodResult setOutput(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (json.length() > Configuration.INSTANCE.getMaxJsonSize()) {
            Object[] objectArray = new Object[]{null, "JSON size is bigger than allowed"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        CompoundTag parsedData = null;
        try {
            parsedData = TagParser.m_129359_((String)json);
        }
        catch (CommandSyntaxException ex) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            String string = "Cannot parse json: %s";
            Object[] objectArray2 = new Object[]{ex.getMessage()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IntegratedDynamicProxy.INSTANCE.getOutputData().put(this.computerID, parsedData);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }
}

