/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.naturescompass;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.ext.BlockPosExtKt;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.player.FakePlayerProxy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001eB\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0007J\b\u0010\u001a\u001a\u00020\u0016H\u0007J\u0016\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralworks/integrations/naturescompass/NaturesCompassPeripheral;", "O", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "peripheralOwner", "isEnabled", "", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;Z)V", "()Z", "compassStack", "Lnet/minecraft/world/item/ItemStack;", "getCompassStack", "()Lnet/minecraft/world/item/ItemStack;", "setCompassStack", "(Lnet/minecraft/world/item/ItemStack;)V", "compass", "Lcom/chaosthedude/naturescompass/items/NaturesCompassItem;", "getCompass", "()Lcom/chaosthedude/naturescompass/items/NaturesCompassItem;", "getBiomes", "", "", "scheduleSearch", "Ldan200/computercraft/api/lua/MethodResult;", "biome", "getState", "getResult", "", "", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNaturesCompassPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NaturesCompassPeripheral.kt\nsite/siredvin/peripheralworks/integrations/naturescompass/NaturesCompassPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1557#2:71\n1628#2,3:72\n*S KotlinDebug\n*F\n+ 1 NaturesCompassPeripheral.kt\nsite/siredvin/peripheralworks/integrations/naturescompass/NaturesCompassPeripheral\n*L\n28#1:71\n28#1:72,3\n*E\n"})
public final class NaturesCompassPeripheral<O extends IPeripheralOwner>
extends OwnedPeripheral<O> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isEnabled;
    @NotNull
    private ItemStack compassStack;
    @NotNull
    public static final String TYPE = "natures_compass";

    public NaturesCompassPeripheral(@NotNull O peripheralOwner, boolean isEnabled) {
        Intrinsics.checkNotNullParameter(peripheralOwner, (String)"peripheralOwner");
        super(TYPE, peripheralOwner);
        this.isEnabled = isEnabled;
        ItemStack itemStack = NaturesCompass.naturesCompass.m_7968_().m_41777_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        this.compassStack = itemStack;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public final ItemStack getCompassStack() {
        return this.compassStack;
    }

    public final void setCompassStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.compassStack = itemStack;
    }

    @NotNull
    public final NaturesCompassItem getCompass() {
        NaturesCompassItem naturesCompassItem = NaturesCompass.naturesCompass;
        Intrinsics.checkNotNullExpressionValue((Object)naturesCompassItem, (String)"naturesCompass");
        return naturesCompassItem;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final List<String> getBiomes() {
        void $this$mapTo$iv$iv;
        List list = BiomeUtils.getAllowedBiomeKeys((Level)this.getPeripheralOwner().getLevel());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllowedBiomeKeys(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceLocation resourceLocation = (ResourceLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return (List)destination$iv$iv;
    }

    @LuaFunction
    @NotNull
    public final MethodResult scheduleSearch(@NotNull String biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        if (this.getCompass().getState(this.compassStack) == CompassState.SEARCHING) {
            Object[] objectArray = new Object[]{null, "Another compass search is running, stop it to start another"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ResourceLocation biomeLoc = ResourceLocation.parse((String)biome);
        Optional optionalBiome = BiomeUtils.getBiomeForKey((Level)this.getPeripheralOwner().getLevel(), (ResourceLocation)biomeLoc);
        if (optionalBiome.isEmpty()) {
            Object[] objectArray = new Object[]{null, "Incorrect biome id " + biome};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Object object = IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), arg_0 -> NaturesCompassPeripheral.scheduleSearch$lambda$1(this, biomeLoc, arg_0), null, (boolean)false, (int)6, null);
        Intrinsics.checkNotNull((Object)object);
        return (MethodResult)object;
    }

    @LuaFunction
    @NotNull
    public final String getState() {
        return this.getCompass().getState(this.compassStack).name();
    }

    @LuaFunction
    @Nullable
    public final Map<String, Object> getResult() {
        if (this.getCompass().getState(this.compassStack) != CompassState.FOUND) {
            return null;
        }
        int x = this.getCompass().getFoundBiomeX(this.compassStack);
        int z = this.getCompass().getFoundBiomeZ(this.compassStack);
        BlockPos ownerPos = this.getPeripheralOwner().getPos();
        Direction facing = this.getPeripheralOwner().getFacing();
        if (facing == Direction.UP || facing == Direction.DOWN) {
            facing = Direction.EAST;
        }
        BlockPos blockPos = new BlockPos(x, 0, z).m_121996_((Vec3i)ownerPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"subtract(...)");
        BlockPos relativePos = BlockPosExtKt.toRelative((BlockPos)blockPos, (Direction)facing);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"x", (Object)relativePos.m_123341_()), TuplesKt.to((Object)"z", (Object)relativePos.m_123343_()), TuplesKt.to((Object)"distance", (Object)BiomeUtils.getDistanceToBiome((BlockPos)this.getPeripheralOwner().getPos(), (int)x, (int)z)), TuplesKt.to((Object)"biome", (Object)this.getCompass().getBiomeKey(this.compassStack).toString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final MethodResult scheduleSearch$lambda$1(NaturesCompassPeripheral this$0, ResourceLocation $biomeLoc, FakePlayerProxy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getCompass().searchForBiome(it.getFakePlayer().m_284548_(), (Player)it.getFakePlayer(), $biomeLoc, this$0.getPeripheralOwner().getPos(), this$0.compassStack);
        return MethodResult.of((Object)true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/integrations/naturescompass/NaturesCompassPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

