/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.powah;

import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.ender.AbstractEnderTile;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.logistics.IRedstoneInteract;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStorageLookup;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.computercraft.ComputerCraftProxy;
import site.siredvin.peripheralworks.integrations.powah.Configuration;
import site.siredvin.peripheralworks.integrations.powah.EnderCellPlugin;
import site.siredvin.peripheralworks.integrations.powah.GeneratorPlugin;
import site.siredvin.peripheralworks.integrations.powah.PowahEnergyStorageWrapper;
import site.siredvin.peripheralworks.integrations.powah.ReactorPlugin;
import site.siredvin.peripheralworks.integrations.powah.RedstoneControlPlugin;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/Integration;", "Ljava/lang/Runnable;", "<init>", "()V", "run", "", "GeneratorPluginProvider", "RedstonePluginProvider", "peripheralworks-forge-1.20.1"})
public final class Integration
implements Runnable {
    @Override
    public void run() {
        ComputerCraftProxy.INSTANCE.addProvider(GeneratorPluginProvider.INSTANCE);
        ComputerCraftProxy.INSTANCE.addProvider(RedstonePluginProvider.INSTANCE);
        PeripheralWorksConfig.INSTANCE.registerIntegrationConfiguration(Configuration.INSTANCE);
        if (Configuration.INSTANCE.getEnableEnergy()) {
            AgnosticEnergyStorageLookup.INSTANCE.addEnergyStorageExtractor(Integration::run$lambda$0);
        }
    }

    private static final AgnosticEnergyStorage run$lambda$0(Level level, BlockPos blockPos, BlockEntity blockEntity) {
        Optional reactorTile;
        Intrinsics.checkNotNullParameter((Object)level, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<unused var>");
        if (blockEntity instanceof ReactorPartTile && (reactorTile = ((ReactorPartTile)blockEntity).core()).isPresent()) {
            Object t = reactorTile.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return new PowahEnergyStorageWrapper((AbstractEnergyStorage)t);
        }
        if (blockEntity instanceof AbstractEnergyStorage) {
            return new PowahEnergyStorageWrapper((AbstractEnergyStorage)blockEntity);
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/Integration$GeneratorPluginProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class GeneratorPluginProvider
    implements PeripheralPluginProvider {
        @NotNull
        public static final GeneratorPluginProvider INSTANCE = new GeneratorPluginProvider();

        private GeneratorPluginProvider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return "powah_extra";
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            Optional reactorTile;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            BlockEntity blockEntity = level.m_7702_(pos);
            if (Configuration.INSTANCE.getEnableReactor() && blockEntity instanceof ReactorTile) {
                return new ReactorPlugin((ReactorTile)blockEntity);
            }
            if (Configuration.INSTANCE.getEnableReactor() && blockEntity instanceof ReactorPartTile && (reactorTile = ((ReactorPartTile)blockEntity).core()).isPresent()) {
                Object t = reactorTile.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                return new ReactorPlugin((ReactorTile)t);
            }
            if (Configuration.INSTANCE.getEnableGenerator() && blockEntity instanceof AbstractEnergyProvider) {
                return new GeneratorPlugin((AbstractEnergyProvider)blockEntity);
            }
            if (Configuration.INSTANCE.getEnableEnderCell() && blockEntity instanceof AbstractEnderTile) {
                return new EnderCellPlugin((AbstractEnderTile)blockEntity);
            }
            return null;
        }

        @Override
        public int getPriority() {
            return PeripheralPluginProvider.DefaultImpls.getPriority(this);
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/Integration$RedstonePluginProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class RedstonePluginProvider
    implements PeripheralPluginProvider {
        @NotNull
        public static final RedstonePluginProvider INSTANCE = new RedstonePluginProvider();

        private RedstonePluginProvider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return "powah_redstone";
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            BlockEntity blockEntity = level.m_7702_(pos);
            if (Configuration.INSTANCE.getEnableRedstoneControl() && blockEntity instanceof IRedstoneInteract) {
                Optional core;
                if (blockEntity instanceof ReactorPartTile && (core = ((ReactorPartTile)blockEntity).core()).isPresent()) {
                    Object t = core.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    return new RedstoneControlPlugin((IRedstoneInteract)t);
                }
                return new RedstoneControlPlugin((IRedstoneInteract)blockEntity);
            }
            return null;
        }

        @Override
        public int getPriority() {
            return PeripheralPluginProvider.DefaultImpls.getPriority(this);
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }
}

