/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.theurgy;

import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergySink;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.peripheralworks.common.setup.ModEnergies;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lsite/siredvin/peripheralworks/integrations/theurgy/AgnosticMercuryFluxStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "capability", "Lcom/klikli_dev/theurgy/content/capability/MercuryFluxStorage;", "<init>", "(Lcom/klikli_dev/theurgy/content/capability/MercuryFluxStorage;)V", "energy", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "capacity", "", "getCapacity", "()J", "canExtract", "", "getCanExtract", "()Z", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "canReceive", "getCanReceive", "unit", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "storeEnergy", "stack", "setChanged", "", "peripheralworks-forge-1.20.1"})
public final class AgnosticMercuryFluxStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final MercuryFluxStorage capability;

    public AgnosticMercuryFluxStorage(@NotNull MercuryFluxStorage capability) {
        Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
        this.capability = capability;
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(this.getUnit(), (long)this.capability.getEnergyStored());
    }

    public long getCapacity() {
        return this.capability.getMaxEnergyStored();
    }

    public boolean getCanExtract() {
        return this.capability.canExtract();
    }

    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(this.getUnit(), 0L);
        }
        int extractedEnergy = this.capability.extractEnergy((int)limit, false);
        return new AgnosticEnergyStack(this.getUnit(), (long)extractedEnergy);
    }

    public boolean getCanReceive() {
        return this.capability.canReceive();
    }

    @NotNull
    public EnergyUnit getUnit() {
        return ModEnergies.INSTANCE.getMERCURY_FLUX();
    }

    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(this.getUnit())) {
            return stack;
        }
        int storedEnergy = this.capability.receiveEnergy((int)stack.getAmount(), false);
        return new AgnosticEnergyStack(this.getUnit(), stack.getAmount() - (long)storedEnergy);
    }

    public void setChanged() {
    }

    public long moveTo(@NotNull AgnosticEnergySink to, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveTo((AgnosticEnergyStorage)this, (AgnosticEnergySink)to, (long)limit, takePredicate);
    }

    public long moveFrom(@NotNull AgnosticEnergyStorage from, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveFrom((AgnosticEnergyStorage)this, (AgnosticEnergyStorage)from, (long)limit, takePredicate);
    }

    @Nullable
    public String getMovableType() {
        return AgnosticEnergyStorage.DefaultImpls.getMovableType((AgnosticEnergyStorage)this);
    }
}

