/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.configurator;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.common.setup.Blocks;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;
import site.siredvin.peripheralworks.subsystem.configurator.EntityLinkMode;
import site.siredvin.peripheralworks.subsystem.configurator.NetworkManagerMode;
import site.siredvin.peripheralworks.subsystem.configurator.PeripheralProxyMode;
import site.siredvin.peripheralworks.subsystem.configurator.RemoteObserverMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsite/siredvin/peripheralworks/subsystem/configurator/ConfiguratorModeRegistry;", "", "<init>", "()V", "REGISTRY", "", "Lnet/minecraft/resources/ResourceLocation;", "Lsite/siredvin/peripheralworks/subsystem/configurator/ConfigurationMode;", "CONDITION_REGISTRY", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/level/block/state/BlockState;", "register", "", "modeID", "builder", "condition", "get", "state", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nConfiguratorModeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfiguratorModeRegistry.kt\nsite/siredvin/peripheralworks/subsystem/configurator/ConfiguratorModeRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,35:1\n216#2,2:36\n*S KotlinDebug\n*F\n+ 1 ConfiguratorModeRegistry.kt\nsite/siredvin/peripheralworks/subsystem/configurator/ConfiguratorModeRegistry\n*L\n27#1:36,2\n*E\n"})
public final class ConfiguratorModeRegistry {
    @NotNull
    public static final ConfiguratorModeRegistry INSTANCE = new ConfiguratorModeRegistry();
    @NotNull
    private static final Map<ResourceLocation, ConfigurationMode> REGISTRY = new LinkedHashMap();
    @NotNull
    private static final Map<Predicate<BlockState>, ResourceLocation> CONDITION_REGISTRY = new LinkedHashMap();

    private ConfiguratorModeRegistry() {
    }

    public final void register(@NotNull ResourceLocation modeID, @NotNull ConfigurationMode builder, @NotNull Predicate<BlockState> condition) {
        Intrinsics.checkNotNullParameter((Object)modeID, (String)"modeID");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        REGISTRY.put(modeID, builder);
        CONDITION_REGISTRY.put(condition, modeID);
    }

    @Nullable
    public final ConfigurationMode get(@NotNull ResourceLocation modeID) {
        Intrinsics.checkNotNullParameter((Object)modeID, (String)"modeID");
        return REGISTRY.get(modeID);
    }

    @Nullable
    public final ConfigurationMode get(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<Predicate<BlockState>, ResourceLocation> $this$forEach$iv = CONDITION_REGISTRY;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Predicate<BlockState>, ResourceLocation>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Predicate<BlockState>, ResourceLocation> element$iv;
            Map.Entry<Predicate<BlockState>, ResourceLocation> entry = element$iv = iterator.next();
            boolean bl = false;
            Predicate<BlockState> predicate = entry.getKey();
            ResourceLocation modID = entry.getValue();
            if (!predicate.test(state)) continue;
            return INSTANCE.get(modID);
        }
        return null;
    }

    private static final boolean _init_$lambda$0(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_60713_((Block)Blocks.INSTANCE.getREMOTE_OBSERVER().get());
    }

    private static final boolean _init_$lambda$1(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_60713_((Block)Blocks.INSTANCE.getPERIPHERAL_PROXY().get());
    }

    private static final boolean _init_$lambda$2(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_60713_((Block)Blocks.INSTANCE.getENTITY_LINK().get());
    }

    private static final boolean _init_$lambda$3(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_60713_((Block)Blocks.INSTANCE.getNETWORK_MANAGER().get());
    }

    static {
        INSTANCE.register(RemoteObserverMode.INSTANCE.getModeID(), RemoteObserverMode.INSTANCE, ConfiguratorModeRegistry::_init_$lambda$0);
        INSTANCE.register(PeripheralProxyMode.INSTANCE.getModeID(), PeripheralProxyMode.INSTANCE, ConfiguratorModeRegistry::_init_$lambda$1);
        INSTANCE.register(EntityLinkMode.INSTANCE.getModeID(), EntityLinkMode.INSTANCE, ConfiguratorModeRegistry::_init_$lambda$2);
        INSTANCE.register(NetworkManagerMode.INSTANCE.getModeID(), NetworkManagerMode.INSTANCE, ConfiguratorModeRegistry::_init_$lambda$3);
    }
}

