/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.configurator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.PeripheralWorksCore;
import site.siredvin.peripheralworks.common.blockentity.RemoteObserverBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.data.ModText;
import site.siredvin.peripheralworks.data.ModTooltip;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/subsystem/configurator/RemoteObserverMode;", "Lsite/siredvin/peripheralworks/subsystem/configurator/ConfigurationMode;", "<init>", "()V", "modeID", "Lnet/minecraft/resources/ResourceLocation;", "getModeID$annotations", "getModeID", "()Lnet/minecraft/resources/ResourceLocation;", "description", "Lnet/minecraft/network/chat/Component;", "getDescription", "()Lnet/minecraft/network/chat/Component;", "onBlockClick", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "configurationTarget", "Lnet/minecraft/core/BlockPos;", "stack", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "level", "Lnet/minecraft/world/level/Level;", "peripheralworks-forge-1.20.1"})
public final class RemoteObserverMode
implements ConfigurationMode {
    @NotNull
    public static final RemoteObserverMode INSTANCE = new RemoteObserverMode();
    @NotNull
    private static final ResourceLocation modeID = new ResourceLocation("peripheralworks", "remote_observer");
    @NotNull
    private static final Component description = (Component)ModTooltip.REMOTE_OBSERVER_MODE.getText();

    private RemoteObserverMode() {
    }

    @Override
    @NotNull
    public ResourceLocation getModeID() {
        return modeID;
    }

    public static /* synthetic */ void getModeID$annotations() {
    }

    @Override
    @NotNull
    public Component getDescription() {
        return description;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onBlockClick(@NotNull BlockPos configurationTarget, @NotNull ItemStack stack, @NotNull Player player, @NotNull BlockHitResult hit, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)configurationTarget, (String)"configurationTarget");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.f_46443_) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        BlockEntity entity = level.m_7702_(configurationTarget);
        if (!(entity instanceof RemoteObserverBlockEntity)) {
            PeripheralWorksCore.INSTANCE.getLogger().error("Remote observer configuration mode renderer process " + configurationTarget + " which is not remote observer");
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        if (Intrinsics.areEqual((Object)((RemoteObserverBlockEntity)entity).m_58899_(), (Object)hit.m_82425_())) {
            player.m_5661_((Component)ModText.REMOTE_OBSERVER_NOT_SELF.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        RemoteObserverBlockEntity remoteObserverBlockEntity = (RemoteObserverBlockEntity)entity;
        BlockPos blockPos = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        if (!remoteObserverBlockEntity.isPosApplicable(blockPos)) {
            player.m_5661_((Component)ModText.REMOTE_OBSERVER_TOO_FAR.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        if (!((RemoteObserverBlockEntity)entity).getTrackedBlocksView().contains(hit.m_82425_()) && ((RemoteObserverBlockEntity)entity).getTrackedBlocksView().size() >= PeripheralWorksConfig.INSTANCE.getRemoteObserverMaxCapacity()) {
            player.m_5661_((Component)ModText.REMOTE_OBSERVER_TOO_MANY.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        RemoteObserverBlockEntity remoteObserverBlockEntity2 = (RemoteObserverBlockEntity)entity;
        BlockPos blockPos2 = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        if (remoteObserverBlockEntity2.togglePos(blockPos2)) {
            player.m_5661_((Component)ModText.REMOTE_OBSERVER_BLOCK_ADDED.getText(), true);
        } else {
            player.m_5661_((Component)ModText.REMOTE_OBSERVER_BLOCK_REMOVED.getText(), true);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onEntityClick(@NotNull BlockPos configurationTarget, @NotNull ItemStack stack, @NotNull Player player, @NotNull EntityHitResult hit, @NotNull Level level) {
        return ConfigurationMode.DefaultImpls.onEntityClick(this, configurationTarget, stack, player, hit, level);
    }
}

