/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.tweakium.modules.peripheral.representation.LuaInterpretation;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"rotate", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "rotation", "Lnet/minecraft/data/models/blockstates/VariantProperties$Rotation;", "getRotation", "Lnet/minecraft/core/Direction;", "to", "from", "getBlockPos", "Lnet/minecraft/core/BlockPos;", "Ldan200/computercraft/api/lua/IArguments;", "index", "", "getVec3i", "Lnet/minecraft/core/Vec3i;", "optDirection", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nsite/siredvin/peripheralworks/utils/ExtensionsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,92:1\n37#2,2:93\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nsite/siredvin/peripheralworks/utils/ExtensionsKt\n*L\n85#1:93,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final VoxelShape rotate(@NotNull VoxelShape $this$rotate, @NotNull VariantProperties.Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        double rotationAngle = switch (WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
            case 1 -> 0.0;
            case 2 -> 1.5707963267948966;
            case 3 -> Math.PI;
            case 4 -> -1.5707963267948966;
            default -> throw new NoWhenBranchMatchedException();
        };
        Ref.ObjectRef movingShape = new Ref.ObjectRef();
        movingShape.element = Shapes.m_83040_();
        $this$rotate.m_83286_((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ExtensionsKt.rotate$lambda$0(rotationAngle, movingShape, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        Object object = movingShape.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return (VoxelShape)object;
    }

    @NotNull
    public static final VariantProperties.Rotation getRotation(@NotNull Direction $this$getRotation, @NotNull Direction to) {
        VariantProperties.Rotation rotation;
        Intrinsics.checkNotNullParameter((Object)$this$getRotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Direction direction = to;
        if (direction == $this$getRotation) {
            rotation = VariantProperties.Rotation.R0;
        } else if (direction == $this$getRotation.m_122427_()) {
            rotation = VariantProperties.Rotation.R270;
        } else if (direction == $this$getRotation.m_122428_()) {
            rotation = VariantProperties.Rotation.R90;
        } else if (direction == $this$getRotation.m_122424_()) {
            rotation = VariantProperties.Rotation.R180;
        } else {
            throw new IllegalArgumentException("Only horizontal rotation are supported");
        }
        return rotation;
    }

    @NotNull
    public static final VoxelShape rotate(@NotNull VoxelShape $this$rotate, @NotNull Direction from, @NotNull Direction to) {
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from != to) {
            return ExtensionsKt.rotate($this$rotate, ExtensionsKt.getRotation(from, to));
        }
        return $this$rotate;
    }

    @NotNull
    public static final BlockPos getBlockPos(@NotNull IArguments $this$getBlockPos, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockPos, (String)"<this>");
        Map map = $this$getBlockPos.getTable(index);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTable(...)");
        return LuaInterpretation.INSTANCE.asBlockPos(map);
    }

    @NotNull
    public static final Vec3i getVec3i(@NotNull IArguments $this$getVec3i, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec3i, (String)"<this>");
        Map table = $this$getVec3i.getTable(index);
        Intrinsics.checkNotNull((Object)table);
        if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            throw new LuaException("Table should be block position table");
        }
        Object x = table.get("x");
        Object y = table.get("y");
        Object z = table.get("z");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should be block position table");
        }
        return new Vec3i(((Number)x).intValue(), ((Number)y).intValue(), ((Number)z).intValue());
    }

    @Nullable
    public static final Direction optDirection(@NotNull IArguments $this$optDirection, int index) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)$this$optDirection, (String)"<this>");
        Optional directionArgument = $this$optDirection.optString(index);
        if (directionArgument.isEmpty()) {
            direction = null;
        } else {
            Direction direction2;
            try {
                Object t = directionArgument.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                String string = ((String)t).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                direction2 = Direction.valueOf((String)string);
            }
            catch (IllegalArgumentException exc) {
                Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                List list = Arrays.stream(thisCollection$iv.toArray(new Direction[0])).map(arg_0 -> ExtensionsKt.optDirection$lambda$2(ExtensionsKt::optDirection$lambda$1, arg_0)).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
                String allValues = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                throw new LuaException("Vertical direction should be one of: " + allValues);
            }
            direction = direction2;
        }
        return direction;
    }

    private static final void rotate$lambda$0(double $rotationAngle, Ref.ObjectRef $movingShape, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Intrinsics.checkNotNullParameter((Object)$movingShape, (String)"$movingShape");
        double x1 = (minZ - 0.5) * Math.sin($rotationAngle) + (minX - 0.5) * Math.cos($rotationAngle) + 0.5;
        double x2 = (maxZ - 0.5) * Math.sin($rotationAngle) + (maxX - 0.5) * Math.cos($rotationAngle) + 0.5;
        double z1 = (minZ - 0.5) * Math.cos($rotationAngle) - (minX - 0.5) * Math.sin($rotationAngle) + 0.5;
        double z2 = (maxZ - 0.5) * Math.cos($rotationAngle) - (maxX - 0.5) * Math.sin($rotationAngle) + 0.5;
        $movingShape.element = Shapes.m_83110_((VoxelShape)((VoxelShape)$movingShape.element), (VoxelShape)Shapes.m_83048_((double)Math.min(x1, x2), (double)minY, (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)maxY, (double)Math.max(z1, z2)));
    }

    private static final String optDirection$lambda$1(Direction mode) {
        String string = mode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final String optDirection$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VariantProperties.Rotation.values().length];
            try {
                nArray[VariantProperties.Rotation.R0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VariantProperties.Rotation.R90.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VariantProperties.Rotation.R180.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VariantProperties.Rotation.R270.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

