/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fB1\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u000e\u0010\u0016J\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00010/J\u0006\u00101\u001a\u00020\u0015J\u0006\u00102\u001a\u000203J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\nH\u00c6\u0003J\t\u0010;\u001a\u00020\fH\u00c6\u0003J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003Jc\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020\fH\u00d6\u0001J\t\u0010B\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006C"}, d2={"Lsite/siredvin/peripheralworks/utils/QuadData;", "", "x1", "", "x2", "y1", "y2", "z1", "z2", "texture", "Lnet/minecraft/resources/ResourceLocation;", "tint", "", "opacity", "<init>", "(FFFFFFLnet/minecraft/resources/ResourceLocation;IF)V", "start", "Lorg/joml/Vector3f;", "end", "(Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lnet/minecraft/resources/ResourceLocation;IF)V", "data", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)V", "getX1", "()F", "getX2", "getY1", "getY2", "getZ1", "getZ2", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "getTint", "()I", "getOpacity", "getStart", "()Lorg/joml/Vector3f;", "getEnd", "uv", "", "getUv", "()[F", "shape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "toLua", "", "", "toTag", "toAABB", "Lnet/minecraft/world/phys/AABB;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "peripheralworks-forge-1.20.1"})
public final class QuadData {
    private final float x1;
    private final float x2;
    private final float y1;
    private final float y2;
    private final float z1;
    private final float z2;
    @NotNull
    private final ResourceLocation texture;
    private final int tint;
    private final float opacity;

    public QuadData(float x1, float x2, float y1, float y2, float z1, float z2, @NotNull ResourceLocation texture, int tint, float opacity) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z1 = z1;
        this.z2 = z2;
        this.texture = texture;
        this.tint = tint;
        this.opacity = opacity;
    }

    public final float getX1() {
        return this.x1;
    }

    public final float getX2() {
        return this.x2;
    }

    public final float getY1() {
        return this.y1;
    }

    public final float getY2() {
        return this.y2;
    }

    public final float getZ1() {
        return this.z1;
    }

    public final float getZ2() {
        return this.z2;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    public final int getTint() {
        return this.tint;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public QuadData(@NotNull Vector3f start, @NotNull Vector3f end, @NotNull ResourceLocation texture, int tint, float opacity) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this(start.x, end.x, start.y, end.y, start.z, end.z, texture, tint, opacity);
    }

    public QuadData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data.m_128457_("x1"), data.m_128457_("x2"), data.m_128457_("y1"), data.m_128457_("y2"), data.m_128457_("z1"), data.m_128457_("z2"), new ResourceLocation(data.m_128461_("texture")), data.m_128451_("tint"), data.m_128441_("opacity") ? data.m_128457_("opacity") : 1.0f);
    }

    @NotNull
    public final Vector3f getStart() {
        return new Vector3f(this.x1, this.y1, this.z1);
    }

    @NotNull
    public final Vector3f getEnd() {
        return new Vector3f(this.x2, this.y2, this.z2);
    }

    @NotNull
    public final float[] getUv() {
        float[] fArray = new float[]{this.x1 / (float)4, this.z1 / (float)4, this.x2 / (float)4, this.z2 / (float)4};
        return fArray;
    }

    @NotNull
    public final VoxelShape getShape() {
        VoxelShape voxelShape = Shapes.m_83048_((double)(this.x1 / (float)16), (double)(this.y1 / (float)16), (double)(this.z1 / (float)16), (double)(this.x2 / (float)16), (double)(this.y2 / (float)16), (double)(this.z2 / (float)16));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    @NotNull
    public final Map<String, Object> toLua() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"x1", (Object)Float.valueOf(this.x1)), TuplesKt.to((Object)"x2", (Object)Float.valueOf(this.x2)), TuplesKt.to((Object)"y1", (Object)Float.valueOf(this.y1)), TuplesKt.to((Object)"y2", (Object)Float.valueOf(this.y2)), TuplesKt.to((Object)"z1", (Object)Float.valueOf(this.z1)), TuplesKt.to((Object)"z2", (Object)Float.valueOf(this.z2)), TuplesKt.to((Object)"texture", (Object)this.texture.toString()), TuplesKt.to((Object)"tint", (Object)this.tint), TuplesKt.to((Object)"opacity", (Object)Float.valueOf(this.opacity))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final CompoundTag toTag() {
        CompoundTag data = new CompoundTag();
        data.m_128350_("x1", this.x1);
        data.m_128350_("x2", this.x2);
        data.m_128350_("y1", this.y1);
        data.m_128350_("y2", this.y2);
        data.m_128350_("z1", this.z1);
        data.m_128350_("z2", this.z2);
        data.m_128405_("tint", this.tint);
        data.m_128359_("texture", this.texture.toString());
        data.m_128350_("opacity", RangesKt.coerceAtMost((float)this.opacity, (float)1.0f));
        return data;
    }

    @NotNull
    public final AABB toAABB() {
        return new AABB((double)this.x1, (double)this.y1, (double)this.z1, (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public final float component1() {
        return this.x1;
    }

    public final float component2() {
        return this.x2;
    }

    public final float component3() {
        return this.y1;
    }

    public final float component4() {
        return this.y2;
    }

    public final float component5() {
        return this.z1;
    }

    public final float component6() {
        return this.z2;
    }

    @NotNull
    public final ResourceLocation component7() {
        return this.texture;
    }

    public final int component8() {
        return this.tint;
    }

    public final float component9() {
        return this.opacity;
    }

    @NotNull
    public final QuadData copy(float x1, float x2, float y1, float y2, float z1, float z2, @NotNull ResourceLocation texture, int tint, float opacity) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        return new QuadData(x1, x2, y1, y2, z1, z2, texture, tint, opacity);
    }

    public static /* synthetic */ QuadData copy$default(QuadData quadData, float f, float f2, float f3, float f4, float f5, float f6, ResourceLocation resourceLocation, int n, float f7, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = quadData.x1;
        }
        if ((n2 & 2) != 0) {
            f2 = quadData.x2;
        }
        if ((n2 & 4) != 0) {
            f3 = quadData.y1;
        }
        if ((n2 & 8) != 0) {
            f4 = quadData.y2;
        }
        if ((n2 & 0x10) != 0) {
            f5 = quadData.z1;
        }
        if ((n2 & 0x20) != 0) {
            f6 = quadData.z2;
        }
        if ((n2 & 0x40) != 0) {
            resourceLocation = quadData.texture;
        }
        if ((n2 & 0x80) != 0) {
            n = quadData.tint;
        }
        if ((n2 & 0x100) != 0) {
            f7 = quadData.opacity;
        }
        return quadData.copy(f, f2, f3, f4, f5, f6, resourceLocation, n, f7);
    }

    @NotNull
    public String toString() {
        return "QuadData(x1=" + this.x1 + ", x2=" + this.x2 + ", y1=" + this.y1 + ", y2=" + this.y2 + ", z1=" + this.z1 + ", z2=" + this.z2 + ", texture=" + this.texture + ", tint=" + this.tint + ", opacity=" + this.opacity + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.x1);
        result = result * 31 + Float.hashCode(this.x2);
        result = result * 31 + Float.hashCode(this.y1);
        result = result * 31 + Float.hashCode(this.y2);
        result = result * 31 + Float.hashCode(this.z1);
        result = result * 31 + Float.hashCode(this.z2);
        result = result * 31 + this.texture.hashCode();
        result = result * 31 + Integer.hashCode(this.tint);
        result = result * 31 + Float.hashCode(this.opacity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuadData)) {
            return false;
        }
        QuadData quadData = (QuadData)other;
        if (Float.compare(this.x1, quadData.x1) != 0) {
            return false;
        }
        if (Float.compare(this.x2, quadData.x2) != 0) {
            return false;
        }
        if (Float.compare(this.y1, quadData.y1) != 0) {
            return false;
        }
        if (Float.compare(this.y2, quadData.y2) != 0) {
            return false;
        }
        if (Float.compare(this.z1, quadData.z1) != 0) {
            return false;
        }
        if (Float.compare(this.z2, quadData.z2) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.texture, (Object)quadData.texture)) {
            return false;
        }
        if (this.tint != quadData.tint) {
            return false;
        }
        return Float.compare(this.opacity, quadData.opacity) == 0;
    }
}

