/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import com.google.gson.Gson;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.base.ext.BlockPosExtKt;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.utils.ExtensionsKt;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.util.AbstractNotNullDataObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u000bJ6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010\u001f\u001a\u00020\u00152\u0016\u0010 \u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0!2\u0006\u0010\u0017\u001a\u00020\u001cJ$\u0010\"\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u001c2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00180$J$\u0010%\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u001c2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00180$J$\u0010&\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u001c2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00180$J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001cJ\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u000bH\u0007J\u0010\u00102\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u00103\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u00104\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u00105\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0007J\u0018\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000bH\u0007J\u0010\u00109\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u000bH\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006;"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "owner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "findEntity", "Lkotlin/Pair;", "Lnet/minecraft/world/entity/Entity;", "Ldan200/computercraft/api/lua/MethodResult;", "uuid", "parseNumberList", "", "name", "data", "", "expectedSize", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "default", "Lnet/minecraft/nbt/ListTag;", "handleDefaultOptions", "it", "", "mergeTextOptions", "options", "Ljava/util/Optional;", "mergeItemOptions", "mergeBlockOptions", "spawnEntity", "describeEntity", "entity", "Lnet/minecraft/world/entity/Display;", "destroy", "move", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "rotate", "list", "mode", "update", "item", "block", "text", "ride", "riderUUID", "horseUUID", "unmount", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHologramProjectorPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramProjectorPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,504:1\n1557#2:505\n1628#2,3:506\n1863#2,2:509\n1863#2,2:517\n1863#2,2:519\n1863#2,2:521\n1863#2,2:523\n1863#2,2:525\n1863#2,2:527\n1863#2,2:529\n1863#2,2:531\n216#3,2:511\n216#3,2:513\n216#3,2:515\n*S KotlinDebug\n*F\n+ 1 HologramProjectorPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral\n*L\n147#1:505\n147#1:506,3\n149#1:509,2\n258#1:517,2\n263#1:519,2\n271#1:521,2\n276#1:523,2\n281#1:525,2\n286#1:527,2\n367#1:529,2\n377#1:531,2\n185#1:511,2\n214#1:513,2\n225#1:515,2\n*E\n"})
public final class HologramProjectorPeripheral
extends OwnedPeripheral<IPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "hologram_projector";
    @NotNull
    private static final ResourceLocation UPGRADE_ID = new ResourceLocation("peripheralworks", "hologram_projector");
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final Set<String> INT_OPTIONS;
    @NotNull
    private static final Set<String> FLOAT_OPTIONS;
    @NotNull
    private static final Set<String> STR_OPTIONS;
    @NotNull
    private static final Set<String> TEXT_INT_OPTIONS;
    @NotNull
    private static final Set<String> TEXT_BOOLEAN_OPTIONS;
    @NotNull
    private static final Set<String> TEXT_BYTE_OPTIONS;
    @NotNull
    private static final Set<String> TEXT_STR_OPTIONS;
    @NotNull
    private static final Set<String> ITEM_STR_OPTIONS;
    @NotNull
    private static final Lazy<ListTag> ROTATION_DEFAULT$delegate;
    @NotNull
    private static final Lazy<ListTag> SCALE_DEFAULT$delegate;
    @NotNull
    private static final Lazy<ListTag> TRANSLATE_DEFAULT$delegate;

    public HologramProjectorPeripheral(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(TYPE, owner);
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableHologramProjector();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map base = super.getPeripheralConfiguration();
        base.put("entityLimit", PeripheralWorksConfig.INSTANCE.getHologramProjectorEntityLimit());
        base.put("distanceLimit", PeripheralWorksConfig.INSTANCE.getHologramProjectorDistanceLimit());
        return base;
    }

    @NotNull
    public final Pair<Entity, MethodResult> findEntity(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object[] objectArray = this.getPeripheralOwner().getLevel();
        ServerLevel serverLevel = objectArray instanceof ServerLevel ? (ServerLevel)objectArray : null;
        if (serverLevel == null) {
            objectArray = new Object[]{null, "Cannot locate level for some reason"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray));
        }
        ServerLevel level = serverLevel;
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            Object[] objectArray2 = new Object[]{null, "Cannot locale owner"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray2));
        }
        UUID ownerUUID = uUID;
        Entity entity = level.m_8791_(UUID.fromString(uuid));
        if (entity == null) {
            Companion.Entities.INSTANCE.remove(this.getPeripheralOwner(), uuid);
            Object[] objectArray3 = new Object[]{null, "Cannot find entity"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray3));
        }
        if (!(entity instanceof Display)) {
            Companion.Entities.INSTANCE.remove(this.getPeripheralOwner(), uuid);
            Object[] objectArray4 = new Object[]{null, "Target entity incorrect"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray4));
        }
        if (!((Display)entity).m_19880_().contains("spawner:" + ownerUUID)) {
            Companion.Entities.INSTANCE.remove(this.getPeripheralOwner(), uuid);
            Object[] objectArray5 = new Object[]{null, "Target entity incorrect"};
            return new Pair(null, (Object)MethodResult.of((Object[])objectArray5));
        }
        return new Pair((Object)entity, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void parseNumberList(@NotNull String name, @NotNull Map<?, ?> data, @NotNull Number expectedSize, @NotNull CompoundTag tag, @NotNull ListTag listTag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)expectedSize, (String)"expectedSize");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)listTag, (String)"default");
        if (data.containsKey(name)) {
            void $this$mapTo$iv$iv;
            Object obj = data.get(name);
            Map map = obj instanceof Map ? (Map)obj : null;
            if (map == null) {
                throw new LuaException(name + " must be a table with " + expectedSize + " elements");
            }
            Map scale = map;
            Number number = expectedSize;
            if (!(number instanceof Integer) || scale.size() != number.intValue()) {
                throw new LuaException(name + " must be a table with " + expectedSize + " elements");
            }
            Iterable $this$map$iv = scale.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Number number2 = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if (number2 == null) {
                    throw new LuaException(name + " elements must be number");
                }
                collection.add(number2);
            }
            List scales = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            ListTag listTag2 = new ListTag();
            Iterable $this$forEach$iv = scales;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Number it = (Number)element$iv;
                boolean bl = false;
                listTag2.add((Object)FloatTag.m_128566_((float)it.floatValue()));
            }
            v3 = tag.m_128365_(name, (Tag)listTag2);
        } else {
            v3 = tag.m_128365_(name, (Tag)listTag);
        }
    }

    public final void handleDefaultOptions(@NotNull Map.Entry<? extends Object, ? extends Object> it, @NotNull CompoundTag data) {
        Number number;
        Object object;
        Intrinsics.checkNotNullParameter(it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (CollectionsKt.contains((Iterable)INT_OPTIONS, (Object)it.getKey())) {
            object = it.getValue();
            Number number2 = number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number != null) {
                data.m_128405_(String.valueOf(it.getKey()), number.intValue());
            }
        }
        if (CollectionsKt.contains((Iterable)FLOAT_OPTIONS, (Object)it.getKey())) {
            object = it.getValue();
            Number number3 = number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number != null) {
                data.m_128350_(String.valueOf(it.getKey()), number.floatValue());
            }
        }
        if (CollectionsKt.contains((Iterable)STR_OPTIONS, (Object)it.getKey())) {
            data.m_128359_(String.valueOf(it.getKey()), String.valueOf(it.getValue()));
        }
        if (Intrinsics.areEqual((Object)it.getKey(), (Object)"transformation")) {
            Object object2 = it.getValue();
            Map map = object2 instanceof Map ? (Map)object2 : null;
            if (map == null) {
                throw new LuaException("Transformation should be a table");
            }
            Map value = map;
            CompoundTag innerTag = new CompoundTag();
            this.parseNumberList("scale", value, 3, innerTag, Companion.getSCALE_DEFAULT());
            this.parseNumberList("translation", value, 3, innerTag, Companion.getTRANSLATE_DEFAULT());
            this.parseNumberList("left_rotation", value, 4, innerTag, Companion.getROTATION_DEFAULT());
            this.parseNumberList("right_rotation", value, 4, innerTag, Companion.getROTATION_DEFAULT());
            data.m_128365_("transformation", (Tag)innerTag);
        }
    }

    public final void mergeTextOptions(@NotNull CompoundTag data, @NotNull Optional<Map<?, ?>> options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (options.isPresent()) {
            Map<?, ?> map = options.get();
            Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
            Map<?, ?> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Serializable number;
                Object obj;
                Map.Entry<?, ?> element$iv;
                Map.Entry<?, ?> it = element$iv = iterator.next();
                boolean bl = false;
                this.handleDefaultOptions(it, data);
                if (CollectionsKt.contains((Iterable)TEXT_INT_OPTIONS, it.getKey())) {
                    obj = it.getValue();
                    Serializable serializable = number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
                    if (number != null) {
                        data.m_128405_(String.valueOf(it.getKey()), ((Number)number).intValue());
                    }
                }
                if (CollectionsKt.contains((Iterable)TEXT_STR_OPTIONS, it.getKey())) {
                    data.m_128359_(String.valueOf(it.getKey()), String.valueOf(it.getValue()));
                }
                if (CollectionsKt.contains((Iterable)TEXT_BYTE_OPTIONS, it.getKey())) {
                    obj = it.getValue();
                    Serializable serializable = number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
                    if (number != null) {
                        data.m_128344_(String.valueOf(it.getKey()), ((Number)number).byteValue());
                    }
                }
                if (!CollectionsKt.contains((Iterable)TEXT_BOOLEAN_OPTIONS, it.getKey()) || (number = (obj = it.getValue()) instanceof Boolean ? (Boolean)obj : null) == null) continue;
                data.m_128379_(String.valueOf(it.getKey()), ((Boolean)number).booleanValue());
            }
        }
    }

    public final void mergeItemOptions(@NotNull CompoundTag data, @NotNull Optional<Map<?, ?>> options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (options.isPresent()) {
            Map<?, ?> map = options.get();
            Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
            Map<?, ?> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ?> element$iv;
                Map.Entry<?, ?> it = element$iv = iterator.next();
                boolean bl = false;
                this.handleDefaultOptions(it, data);
                if (!CollectionsKt.contains((Iterable)ITEM_STR_OPTIONS, it.getKey())) continue;
                data.m_128359_(String.valueOf(it.getKey()), String.valueOf(it.getValue()));
            }
        }
    }

    public final void mergeBlockOptions(@NotNull CompoundTag data, @NotNull Optional<Map<?, ?>> options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (options.isPresent()) {
            Map<?, ?> map = options.get();
            Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
            Map<?, ?> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ?> element$iv;
                Map.Entry<?, ?> it = element$iv = iterator.next();
                boolean bl = false;
                this.handleDefaultOptions(it, data);
            }
        }
    }

    @NotNull
    public final MethodResult spawnEntity(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((List)Companion.Entities.INSTANCE.get(this.getPeripheralOwner())).size() > PeripheralWorksConfig.INSTANCE.getHologramProjectorEntityLimit()) {
            Object[] objectArray = new Object[]{null, "Cannot create more then 10 displays"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            Object[] objectArray = new Object[]{null, "Cannot locale owner"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        UUID ownerUUID = uUID;
        Level level = this.getPeripheralOwner().getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Cannot locale level"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        BlockPos pos = this.getPeripheralOwner().getPos();
        Level level3 = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level3);
        Entity entity = EntityType.m_20645_((CompoundTag)data, (Level)level3, arg_0 -> HologramProjectorPeripheral.spawnEntity$lambda$0(pos, ownerUUID, arg_0));
        if (entity != null) {
            IPeripheralOwner iPeripheralOwner = this.getPeripheralOwner();
            String string = entity.m_20149_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
            Companion.Entities.INSTANCE.add(iPeripheralOwner, string);
            if (level2.m_8860_(entity)) {
                MethodResult methodResult = MethodResult.of((Object)entity.m_20149_());
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
        }
        Object[] objectArray = new Object[]{null, "Something went wrong"};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final Map<String, Object> describeEntity(@NotNull Display entity) {
        String opt;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        CompoundTag data = new CompoundTag();
        entity.m_20223_(data);
        Display display = new Display[]{TuplesKt.to((Object)"type", (Object)entity.m_6095_().m_20675_())};
        Map subInfo = MapsKt.mutableMapOf((Pair[])display);
        Iterable $this$forEach$iv = INT_OPTIONS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            opt = (String)element$iv;
            boolean bl = false;
            if (!data.m_128441_(opt)) continue;
            subInfo.put(opt, data.m_128451_(opt));
        }
        $this$forEach$iv = STR_OPTIONS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            opt = (String)element$iv;
            boolean bl = false;
            if (!data.m_128441_(opt)) continue;
            subInfo.put(opt, data.m_128461_(opt));
        }
        display = entity;
        if (display instanceof Display.TextDisplay) {
            subInfo.put("text", data.m_128461_("text"));
            Iterable $this$forEach$iv2 = TEXT_INT_OPTIONS;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String opt2 = (String)element$iv;
                boolean bl = false;
                if (!data.m_128441_(opt2)) continue;
                subInfo.put(opt2, data.m_128451_(opt2));
            }
            $this$forEach$iv2 = TEXT_STR_OPTIONS;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String opt3 = (String)element$iv;
                boolean bl = false;
                if (!data.m_128441_(opt3)) continue;
                subInfo.put(opt3, data.m_128461_(opt3));
            }
            $this$forEach$iv2 = TEXT_BYTE_OPTIONS;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String opt4 = (String)element$iv;
                boolean bl = false;
                if (!data.m_128441_(opt4)) continue;
                subInfo.put(opt4, data.m_128445_(opt4));
            }
            $this$forEach$iv2 = TEXT_BOOLEAN_OPTIONS;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String opt5 = (String)element$iv;
                boolean bl = false;
                if (!data.m_128441_(opt5)) continue;
                subInfo.put(opt5, data.m_128471_(opt5));
            }
        } else if (display instanceof Display.ItemDisplay) {
            Map map = subInfo;
            var6_9 = "item";
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)data.m_128469_("item"));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"of(...)");
            var7_11 = LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)itemStack, null, (int)2, null);
            map.put(var6_9, var7_11);
            subInfo.put("item_display", data.m_128461_("item_display"));
        } else if (display instanceof Display.BlockDisplay) {
            Map map = subInfo;
            var6_9 = "block_state";
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)((HolderGetter)PlatformRegistries.INSTANCE.getBLOCKS()), (CompoundTag)data.m_128469_("block_state"));
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"readBlockState(...)");
            var7_11 = LuaRepresentation.INSTANCE.forBlockState(blockState);
            map.put(var6_9, var7_11);
        }
        return subInfo;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult destroy(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Pair<Entity, MethodResult> entityResult = this.findEntity(uuid);
        if (entityResult.getSecond() != null) {
            Object object = entityResult.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = entityResult.getFirst();
        Intrinsics.checkNotNull((Object)object);
        ((Entity)object).m_142467_(Entity.RemovalReason.DISCARDED);
        Companion.Entities.INSTANCE.remove(this.getPeripheralOwner(), uuid);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult move(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String uuid = arguments.getString(0);
        Vec3 vec3 = BlockPosExtKt.toVec3((BlockPos)this.getPeripheralOwner().getPos()).m_82520_(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        Vec3 pos = ExtensionsKt.getVec(arguments, 1, vec3, this.getPeripheralOwner().getFacing());
        Level level = this.getPeripheralOwner().getLevel();
        if (level == null) {
            Object[] objectArray = new Object[]{null, "Cannot find level"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Level level2 = level;
        if (!level2.m_46749_(BlockPosExtKt.toBlockPos((Vec3)pos))) {
            Object[] objectArray = new Object[]{null, "Cannot send entity into unloaded location"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Intrinsics.checkNotNull((Object)uuid);
        Pair<Entity, MethodResult> entityResult = this.findEntity(uuid);
        if (entityResult.getSecond() != null) {
            Object object = entityResult.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = entityResult.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Entity entity = (Entity)object;
        Vec3 distanceVector = pos.m_82546_(entity.m_20182_());
        if (distanceVector.m_82553_() > PeripheralWorksConfig.INSTANCE.getHologramProjectorDistanceLimit()) {
            Vec3 modifiedPos = pos.m_82541_().m_82542_(PeripheralWorksConfig.INSTANCE.getHologramProjectorDistanceLimit(), PeripheralWorksConfig.INSTANCE.getHologramProjectorDistanceLimit(), PeripheralWorksConfig.INSTANCE.getHologramProjectorDistanceLimit());
            entity.m_20219_(modifiedPos);
        } else {
            entity.m_20219_(pos);
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult rotate(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String uuid = arguments.getString(0);
        Intrinsics.checkNotNull((Object)uuid);
        Pair<Entity, MethodResult> entityResult = this.findEntity(uuid);
        if (entityResult.getSecond() != null) {
            Object object = entityResult.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = entityResult.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Entity entity = (Entity)object;
        float xRot = (float)arguments.optDouble(1, (double)entity.m_146909_());
        float yRot = (float)arguments.optDouble(2, (double)entity.m_146908_());
        entity.m_146926_(xRot);
        entity.m_146922_(yRot);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult list(@NotNull String mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Map info = new LinkedHashMap();
        Level level = this.getPeripheralOwner().getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Cannot locate level for some reason"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        UUID uUID = this.getPeripheralOwner().getOwnerUUID();
        if (uUID == null) {
            Object[] objectArray = new Object[]{null, "Cannot locale owner"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        UUID ownerUUID = uUID;
        String ownershipTag = "spawner:" + ownerUUID;
        String string = mode;
        if (Intrinsics.areEqual((Object)string, (Object)"owned")) {
            Iterable $this$forEach$iv = (Iterable)Companion.Entities.INSTANCE.get(this.getPeripheralOwner());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Entity entity = level2.m_8791_(UUID.fromString(it));
                if (entity instanceof Display && ((Display)entity).m_19880_().contains(ownershipTag)) {
                    info.put(it, this.describeEntity((Display)entity));
                    continue;
                }
                info.put(it, MapsKt.emptyMap());
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"around")) {
            List list = level2.m_45976_(Display.class, new AABB(this.getPeripheralOwner().getPos()).m_82400_(32.0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Display it = (Display)element$iv;
                boolean bl = false;
                if (!it.m_19880_().contains(ownershipTag)) continue;
                String string2 = it.m_20149_();
                Intrinsics.checkNotNull((Object)it);
                info.put(string2, this.describeEntity(it));
            }
        } else {
            throw new LuaException("Incorrect mode, should be owned or around");
        }
        MethodResult methodResult = MethodResult.of((Object)info);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult update(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String uuid = arguments.getString(0);
        Intrinsics.checkNotNull((Object)uuid);
        Pair<Entity, MethodResult> entityResult = this.findEntity(uuid);
        if (entityResult.getSecond() != null) {
            Object object = entityResult.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = entityResult.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Entity entity = (Entity)object;
        if (entity instanceof Display.TextDisplay) {
            Optional text = arguments.optTable(1);
            Optional options = arguments.optTable(2);
            CompoundTag data = new CompoundTag();
            if (text.isPresent()) {
                data.m_128359_("text", GSON.toJson(text.get()));
            }
            Intrinsics.checkNotNull((Object)options);
            this.mergeTextOptions(data, options);
            if (!data.m_128456_()) {
                ((Display.TextDisplay)entity).m_7378_(data);
            }
        } else if (entity instanceof Display.BlockDisplay) {
            Optional block = arguments.optTable(1);
            Optional options = arguments.optTable(2);
            CompoundTag data = new CompoundTag();
            if (block.isPresent()) {
                data.m_128359_("block_state", GSON.toJson(block.get()));
            }
            Intrinsics.checkNotNull((Object)options);
            this.mergeBlockOptions(data, options);
            if (!data.m_128456_()) {
                ((Display.BlockDisplay)entity).m_7378_(data);
            }
        } else if (entity instanceof Display.ItemDisplay) {
            Optional item = arguments.optTable(1);
            Optional options = arguments.optTable(2);
            CompoundTag data = new CompoundTag();
            if (item.isPresent()) {
                data.m_128359_("item", GSON.toJson(item.get()));
            }
            Intrinsics.checkNotNull((Object)options);
            this.mergeItemOptions(data, options);
            if (!data.m_128456_()) {
                ((Display.ItemDisplay)entity).m_7378_(data);
            }
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult item(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map item = arguments.getTable(0);
        Optional options = arguments.optTable(1);
        CompoundTag data = new CompoundTag();
        data.m_128365_("item", (Tag)TagParser.m_129359_((String)GSON.toJson((Object)item)));
        data.m_128359_("id", "minecraft:item_display");
        Intrinsics.checkNotNull((Object)options);
        this.mergeItemOptions(data, options);
        return this.spawnEntity(data);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult block(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map block = arguments.getTable(0);
        Optional options = arguments.optTable(1);
        CompoundTag data = new CompoundTag();
        data.m_128365_("block_state", (Tag)TagParser.m_129359_((String)GSON.toJson((Object)block)));
        data.m_128359_("id", "minecraft:block_display");
        Intrinsics.checkNotNull((Object)options);
        this.mergeBlockOptions(data, options);
        return this.spawnEntity(data);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult text(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map text = arguments.getTable(0);
        Optional options = arguments.optTable(1);
        CompoundTag data = new CompoundTag();
        data.m_128359_("text", GSON.toJson((Object)text));
        data.m_128359_("id", "minecraft:text_display");
        Intrinsics.checkNotNull((Object)options);
        this.mergeTextOptions(data, options);
        return this.spawnEntity(data);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult ride(@NotNull String riderUUID, @NotNull String horseUUID) {
        Intrinsics.checkNotNullParameter((Object)riderUUID, (String)"riderUUID");
        Intrinsics.checkNotNullParameter((Object)horseUUID, (String)"horseUUID");
        if (Intrinsics.areEqual((Object)riderUUID, (Object)horseUUID)) {
            Object[] objectArray = new Object[]{null, "Cannot ride itself"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Pair<Entity, MethodResult> riderFind = this.findEntity(riderUUID);
        if (riderFind.getSecond() != null) {
            Object object = riderFind.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Pair<Entity, MethodResult> horseFind = this.findEntity(horseUUID);
        if (horseFind.getSecond() != null) {
            Object object = horseFind.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = riderFind.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Entity rider = (Entity)object;
        Object object2 = horseFind.getFirst();
        Intrinsics.checkNotNull((Object)object2);
        Entity horse = (Entity)object2;
        List list = rider.m_20197_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
        if (!((Collection)list).isEmpty()) {
            Object[] objectArray = new Object[]{null, "Rider can't have passengers"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        boolean riding = rider.m_7998_(horse, true);
        if (!riding) {
            Object[] objectArray = new Object[]{false, "Rider can't mount entity"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult unmount(@NotNull String riderUUID) {
        Intrinsics.checkNotNullParameter((Object)riderUUID, (String)"riderUUID");
        Pair<Entity, MethodResult> riderFind = this.findEntity(riderUUID);
        if (riderFind.getSecond() != null) {
            Object object = riderFind.getSecond();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = riderFind.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Entity rider = (Entity)object;
        rider.m_8127_();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final Entity spawnEntity$lambda$0(BlockPos $pos, UUID $ownerUUID, Entity entity) {
        entity.m_7678_((double)$pos.m_123341_() + 0.5, (double)$pos.m_123342_() + 1.5, (double)$pos.m_123343_() + 0.5, entity.m_146909_(), entity.m_146908_());
        entity.m_19880_().add("spawner:" + $ownerUUID);
        return entity;
    }

    private static final ListTag ROTATION_DEFAULT_delegate$lambda$0() {
        ListTag lst = new ListTag();
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        lst.add((Object)FloatTag.m_128566_((float)1.0f));
        return lst;
    }

    private static final ListTag SCALE_DEFAULT_delegate$lambda$0() {
        ListTag lst = new ListTag();
        lst.add((Object)FloatTag.m_128566_((float)1.0f));
        lst.add((Object)FloatTag.m_128566_((float)1.0f));
        lst.add((Object)FloatTag.m_128566_((float)1.0f));
        return lst;
    }

    private static final ListTag TRANSLATE_DEFAULT_delegate$lambda$0() {
        ListTag lst = new ListTag();
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        lst.add((Object)FloatTag.m_128566_((float)0.0f));
        return lst;
    }

    static {
        Object[] objectArray = new String[]{"brightness", "glow_color_override", "interpolation_duration", "start_interpolation"};
        INT_OPTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"height", "width", "shadow_radius", "shadow_strength", "view_range"};
        FLOAT_OPTIONS = SetsKt.setOf((Object[])objectArray);
        STR_OPTIONS = SetsKt.setOf((Object)"billboard");
        objectArray = new String[]{"line_width", "background"};
        TEXT_INT_OPTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"shadow", "see_through", "default_background"};
        TEXT_BOOLEAN_OPTIONS = SetsKt.setOf((Object[])objectArray);
        TEXT_BYTE_OPTIONS = SetsKt.setOf((Object)"text_opacity");
        TEXT_STR_OPTIONS = SetsKt.setOf((Object)"alignment");
        ITEM_STR_OPTIONS = SetsKt.setOf((Object)"item_display");
        ROTATION_DEFAULT$delegate = LazyKt.lazy(HologramProjectorPeripheral::ROTATION_DEFAULT_delegate$lambda$0);
        SCALE_DEFAULT$delegate = LazyKt.lazy(HologramProjectorPeripheral::SCALE_DEFAULT_delegate$lambda$0);
        TRANSLATE_DEFAULT$delegate = LazyKt.lazy(HologramProjectorPeripheral::TRANSLATE_DEFAULT_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u001b\u0010'\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010&\u001a\u0004\b(\u0010$R\u001b\u0010*\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010&\u001a\u0004\b+\u0010$\u00a8\u0006."}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "UPGRADE_ID", "Lnet/minecraft/resources/ResourceLocation;", "getUPGRADE_ID$annotations", "getUPGRADE_ID", "()Lnet/minecraft/resources/ResourceLocation;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "INT_OPTIONS", "", "getINT_OPTIONS", "()Ljava/util/Set;", "FLOAT_OPTIONS", "getFLOAT_OPTIONS", "STR_OPTIONS", "getSTR_OPTIONS", "TEXT_INT_OPTIONS", "getTEXT_INT_OPTIONS", "TEXT_BOOLEAN_OPTIONS", "getTEXT_BOOLEAN_OPTIONS", "TEXT_BYTE_OPTIONS", "getTEXT_BYTE_OPTIONS", "TEXT_STR_OPTIONS", "getTEXT_STR_OPTIONS", "ITEM_STR_OPTIONS", "getITEM_STR_OPTIONS", "ROTATION_DEFAULT", "Lnet/minecraft/nbt/ListTag;", "getROTATION_DEFAULT", "()Lnet/minecraft/nbt/ListTag;", "ROTATION_DEFAULT$delegate", "Lkotlin/Lazy;", "SCALE_DEFAULT", "getSCALE_DEFAULT", "SCALE_DEFAULT$delegate", "TRANSLATE_DEFAULT", "getTRANSLATE_DEFAULT", "TRANSLATE_DEFAULT$delegate", "Entities", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getUPGRADE_ID() {
            return UPGRADE_ID;
        }

        public static /* synthetic */ void getUPGRADE_ID$annotations() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        @NotNull
        public final Set<String> getINT_OPTIONS() {
            return INT_OPTIONS;
        }

        @NotNull
        public final Set<String> getFLOAT_OPTIONS() {
            return FLOAT_OPTIONS;
        }

        @NotNull
        public final Set<String> getSTR_OPTIONS() {
            return STR_OPTIONS;
        }

        @NotNull
        public final Set<String> getTEXT_INT_OPTIONS() {
            return TEXT_INT_OPTIONS;
        }

        @NotNull
        public final Set<String> getTEXT_BOOLEAN_OPTIONS() {
            return TEXT_BOOLEAN_OPTIONS;
        }

        @NotNull
        public final Set<String> getTEXT_BYTE_OPTIONS() {
            return TEXT_BYTE_OPTIONS;
        }

        @NotNull
        public final Set<String> getTEXT_STR_OPTIONS() {
            return TEXT_STR_OPTIONS;
        }

        @NotNull
        public final Set<String> getITEM_STR_OPTIONS() {
            return ITEM_STR_OPTIONS;
        }

        @NotNull
        public final ListTag getROTATION_DEFAULT() {
            Lazy lazy = ROTATION_DEFAULT$delegate;
            return (ListTag)lazy.getValue();
        }

        @NotNull
        public final ListTag getSCALE_DEFAULT() {
            Lazy lazy = SCALE_DEFAULT$delegate;
            return (ListTag)lazy.getValue();
        }

        @NotNull
        public final ListTag getTRANSLATE_DEFAULT() {
            Lazy lazy = TRANSLATE_DEFAULT$delegate;
            return (ListTag)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral$Companion$Entities;", "Lsite/siredvin/tweakium/modules/peripheral/util/AbstractNotNullDataObject;", "", "", "<init>", "()V", "nbtTag", "getNbtTag", "()Ljava/lang/String;", "default", "getDefault", "()Ljava/util/List;", "add", "", "peripheralOwner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "value", "remove", "read", "data", "Lsite/siredvin/tweakium/modules/peripheral/api/IDataStorage;", "write", "", "peripheralworks-forge-1.20.1"})
        @SourceDebugExtension(value={"SMAP\nHologramProjectorPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramProjectorPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral$Companion$Entities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,504:1\n1557#2:505\n1628#2,3:506\n1863#2,2:509\n*S KotlinDebug\n*F\n+ 1 HologramProjectorPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/HologramProjectorPeripheral$Companion$Entities\n*L\n63#1:505\n63#1:506,3\n71#1:509,2\n*E\n"})
        public static final class Entities
        extends AbstractNotNullDataObject<List<String>> {
            @NotNull
            public static final Entities INSTANCE = new Entities();

            private Entities() {
            }

            @NotNull
            public String getNbtTag() {
                return "entities";
            }

            @NotNull
            public List<String> getDefault() {
                return new ArrayList();
            }

            public final void add(@NotNull IPeripheralOwner peripheralOwner, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List list = (List)this.get(peripheralOwner);
                list.add(value);
                this.set(peripheralOwner, list);
            }

            public final void remove(@NotNull IPeripheralOwner peripheralOwner, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List list = (List)this.get(peripheralOwner);
                list.remove(value);
                this.set(peripheralOwner, list);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<String> read(@NotNull IDataStorage data) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ListTag tag = data.getList(this.getNbtTag(), 8);
                Iterable $this$map$iv = (Iterable)tag;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Tag tag2 = (Tag)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.StringTag");
                    collection.add(((StringTag)it).m_7916_());
                }
                return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            }

            public boolean write(@NotNull IDataStorage data, @NotNull List<String> value) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter(value, (String)"value");
                ListTag tag = new ListTag();
                Iterable $this$forEach$iv = value;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    tag.add((Object)StringTag.m_129297_((String)it));
                }
                data.putList(this.getNbtTag(), tag);
                return true;
            }
        }
    }
}

