/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyStorageUtils;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0012H\u0016J&\u0010!\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006%"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEEnergyStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "energyService", "Lappeng/api/networking/energy/IEnergyService;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "<init>", "(Lappeng/api/networking/energy/IEnergyService;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "maxStackSize", "", "getMaxStackSize", "()Ljava/lang/Long;", "operator", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "canExtract", "", "getCanExtract", "()Z", "firstEnergy", "getFirstEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getContent", "", "setChanged", "", "canReceive", "getCanReceive", "store", "stack", "simulate", "take", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class AEEnergyStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final IEnergyService energyService;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEEnergyStorage(@NotNull IEnergyService energyService, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)energyService, (String)"energyService");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.energyService = energyService;
        this.entity = entity;
    }

    @NotNull
    public Long getMaxStackSize() {
        return (long)this.energyService.getMaxStoredPower();
    }

    @NotNull
    public SomethingOperator<AgnosticEnergyStack, Long> getOperator() {
        return (SomethingOperator)EnergyStorageUtils.INSTANCE;
    }

    public boolean getCanExtract() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack getFirstEnergy() {
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)this.energyService.getStoredPower());
    }

    @NotNull
    public Iterator<AgnosticEnergyStack> getContent() {
        return CollectionsKt.listOf((Object)this.getFirstEnergy()).iterator();
    }

    public void setChanged() {
        this.entity.m_6596_();
    }

    public boolean getCanReceive() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack store(@NotNull AgnosticEnergyStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)Energies.INSTANCE.getREDSTONE_FLUX())) {
            return stack;
        }
        double leftover = this.energyService.injectPower((double)stack.getAmount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return stack.copyWithCount((long)leftover);
    }

    @NotNull
    public AgnosticEnergyStack take(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getFirstEnergy())) {
            return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), 0L);
        }
        double extracted = this.energyService.extractAEPower((double)limit, simulate ? Actionable.SIMULATE : Actionable.MODULATE, PowerMultiplier.CONFIG);
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)extracted);
    }
}

