/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.platform.PlatformTags;
import site.siredvin.broccolium.modules.platform.api.InnerPlatformTags;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/utils/SensorCollection;", "", "<init>", "()V", "MIN_Y", "", "MAX_Y", "VANILLA_SLIME_CHUNK_SALT", "", "inspectDimension", "Ldan200/computercraft/api/lua/MethodResult;", "owner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "analyzeDimensions", "inspectBiome", "inspectWeather", "inspectOrientationAngle", "inspectTime", "inspectLight", "decodeMoonPhase", "", "level", "Lnet/minecraft/world/level/Level;", "inspectCalendar", "inspectChunk", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nSensorCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SensorCollection.kt\nsite/siredvin/peripheralworks/utils/SensorCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1557#2:118\n1628#2,3:119\n*S KotlinDebug\n*F\n+ 1 SensorCollection.kt\nsite/siredvin/peripheralworks/utils/SensorCollection\n*L\n29#1:118\n29#1:119,3\n*E\n"})
public final class SensorCollection {
    @NotNull
    public static final SensorCollection INSTANCE = new SensorCollection();
    public static final int MIN_Y = -64;
    public static final int MAX_Y = 320;
    public static final long VANILLA_SLIME_CHUNK_SALT = 987234911L;

    private SensorCollection() {
    }

    @NotNull
    public final MethodResult inspectDimension(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        if (level == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Level level2 = level;
        MethodResult methodResult = MethodResult.of((Object)level2.m_46472_().m_135782_().toString());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MethodResult analyzeDimensions(@NotNull IPeripheralOwner owner) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MinecraftServer minecraftServer = level2.m_7654_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        MinecraftServer server = minecraftServer;
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerLevel serverLevel2 = (ServerLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.m_46472_().m_135782_().toString());
        }
        MethodResult methodResult = MethodResult.of((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectBiome(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MethodResult methodResult = MethodResult.of((Object)level2.m_204166_(owner.getPos()).m_203543_().map(arg_0 -> SensorCollection.inspectBiome$lambda$1(SensorCollection::inspectBiome$lambda$0, arg_0)).orElse("unknown"));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectWeather(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        if (level2.m_46470_()) {
            MethodResult methodResult = MethodResult.of((Object)"thunder");
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (level2.m_46471_()) {
            MethodResult methodResult = MethodResult.of((Object)"rain");
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)"stable");
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectOrientationAngle(@NotNull IPeripheralOwner owner) {
        MethodResult methodResult;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        switch (WhenMappings.$EnumSwitchMapping$0[owner.getFacing().ordinal()]) {
            case 1: {
                MethodResult methodResult2 = MethodResult.of((Object)0);
                methodResult = methodResult2;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult2, (String)"of(...)");
                break;
            }
            case 2: {
                MethodResult methodResult3 = MethodResult.of((Object)180);
                methodResult = methodResult3;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult3, (String)"of(...)");
                break;
            }
            case 3: {
                MethodResult methodResult4 = MethodResult.of((Object)270);
                methodResult = methodResult4;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult4, (String)"of(...)");
                break;
            }
            case 4: {
                MethodResult methodResult5 = MethodResult.of((Object)90);
                methodResult = methodResult5;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult5, (String)"of(...)");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{null, "Cannot determinate angle to north pole"};
                MethodResult methodResult6 = MethodResult.of((Object[])objectArray);
                methodResult = methodResult6;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult6, (String)"of(...)");
            }
        }
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectTime(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MethodResult methodResult = MethodResult.of((Object)level2.m_46468_());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectLight(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Pair[] pairArray = owner.getLevel();
        ServerLevel serverLevel = pairArray instanceof ServerLevel ? (ServerLevel)pairArray : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level = serverLevel;
        pairArray = new Pair[]{TuplesKt.to((Object)"light", (Object)level.m_45517_(LightLayer.BLOCK, owner.getPos().m_7494_())), TuplesKt.to((Object)"sunlight", (Object)level.m_45517_(LightLayer.SKY, owner.getPos().m_7494_()))};
        MethodResult methodResult = MethodResult.of((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private final String decodeMoonPhase(Level level) {
        return switch (level.m_46941_()) {
            case 0 -> "Full moon";
            case 1 -> "Waning gibbous";
            case 2 -> "Third quarter";
            case 3 -> "Waning crescent";
            case 4 -> "New moon";
            case 5 -> "Waxing crescent";
            case 6 -> "First quarter";
            case 7 -> "Waxing gibbous";
            default -> "Unknown moon phase";
        };
    }

    @NotNull
    public final MethodResult inspectCalendar(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        Map inspectionData = new LinkedHashMap();
        inspectionData.put("day", level2.m_46468_() / 24000L % Integer.MAX_VALUE);
        if (Intrinsics.areEqual((Object)level2.m_46472_(), (Object)Level.f_46428_)) {
            inspectionData.put("moonPhase", this.decodeMoonPhase((Level)level2));
        }
        MethodResult methodResult = MethodResult.of((Object)inspectionData);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectChunk(@NotNull IPeripheralOwner owner) {
        int n;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        Map information = new LinkedHashMap();
        Map ores = new LinkedHashMap();
        ChunkPos chunkPos = new ChunkPos(owner.getPos());
        int x = chunkPos.m_45604_();
        if (x <= (n = chunkPos.m_45608_())) {
            while (true) {
                int n2;
                int z;
                if ((z = chunkPos.m_45605_()) <= (n2 = chunkPos.m_45609_())) {
                    while (true) {
                        for (int y = -64; y < 321; ++y) {
                            String key;
                            BlockState blockState = level2.m_8055_(new BlockPos(x, y, z));
                            if (blockState.m_60795_()) continue;
                            InnerPlatformTags innerPlatformTags = PlatformTags.INSTANCE.get();
                            Intrinsics.checkNotNull((Object)blockState);
                            if (!innerPlatformTags.isOre(blockState)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)PlatformRegistries.INSTANCE.getBLOCKS().getKey((Object)blockState.m_60734_()).toString(), (String)"toString(...)");
                            if (!ores.containsKey(key)) {
                                ores.put(key, 0);
                            }
                            Object v = ores.get(key);
                            Intrinsics.checkNotNull(v);
                            ores.put(key, ((Number)v).intValue() + 1);
                        }
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        information.put("oresDistribution", ores);
        information.put("isSlime", WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)level2.m_7328_(), (long)987234911L).m_188503_(10) == 0);
        MethodResult methodResult = MethodResult.of((Object)information);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final String inspectBiome$lambda$0(ResourceKey it) {
        return it.m_135782_().toString();
    }

    private static final String inspectBiome$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

