/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralHubPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0011J!\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u0019\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010!\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b&\u0010'J\u001b\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020)0(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010/R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00100R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00101\u00a8\u00062"}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "O", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "record", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "peripheralHubPeripheral", "<init>", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;)V", "", "desiredLocation", "Ldan200/computercraft/api/filesystem/Mount;", "mount", "(Ljava/lang/String;Ldan200/computercraft/api/filesystem/Mount;)Ljava/lang/String;", "driveName", "(Ljava/lang/String;Ldan200/computercraft/api/filesystem/Mount;Ljava/lang/String;)Ljava/lang/String;", "Ldan200/computercraft/api/filesystem/WritableMount;", "mountWritable", "(Ljava/lang/String;Ldan200/computercraft/api/filesystem/WritableMount;)Ljava/lang/String;", "(Ljava/lang/String;Ldan200/computercraft/api/filesystem/WritableMount;Ljava/lang/String;)Ljava/lang/String;", "location", "", "unmount", "(Ljava/lang/String;)V", "", "getID", "()I", "event", "", "", "arguments", "queueEvent", "(Ljava/lang/String;[Ljava/lang/Object;)V", "Ldan200/computercraft/api/peripheral/WorkMonitor;", "getMainThreadMonitor", "()Ldan200/computercraft/api/peripheral/WorkMonitor;", "getAttachmentName", "()Ljava/lang/String;", "", "Ldan200/computercraft/api/peripheral/IPeripheral;", "getAvailablePeripherals", "()Ljava/util/Map;", "name", "getAvailablePeripheral", "(Ljava/lang/String;)Ldan200/computercraft/api/peripheral/IPeripheral;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "peripheralworks-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteComputerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1187#2,2:64\n1261#2,4:66\n*S KotlinDebug\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n*L\n50#1:64,2\n50#1:66,4\n*E\n"})
public final class RemoteComputerWrapper<O extends IPeripheralOwner>
implements IComputerAccess {
    @NotNull
    private final IComputerAccess computer;
    @NotNull
    private final PeripheralRecord<O> record;
    @NotNull
    private final PeripheralHubPeripheral<O> peripheralHubPeripheral;

    public RemoteComputerWrapper(@NotNull IComputerAccess computer, @NotNull PeripheralRecord<O> record, @NotNull PeripheralHubPeripheral<O> peripheralHubPeripheral) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter(peripheralHubPeripheral, (String)"peripheralHubPeripheral");
        this.computer = computer;
        this.record = record;
        this.peripheralHubPeripheral = peripheralHubPeripheral;
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mount(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mount(desiredLocation, mount, driveName);
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mountWritable(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mountWritable(desiredLocation, mount, driveName);
    }

    public void unmount(@Nullable String location) {
        this.computer.unmount(location);
    }

    public int getID() {
        return this.computer.getID();
    }

    public void queueEvent(@NotNull String event, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.computer.queueEvent(event, Arrays.copyOf(arguments, arguments.length));
    }

    @Nonnull
    @NotNull
    public WorkMonitor getMainThreadMonitor() {
        WorkMonitor workMonitor = this.computer.getMainThreadMonitor();
        Intrinsics.checkNotNullExpressionValue((Object)workMonitor, (String)"getMainThreadMonitor(...)");
        return workMonitor;
    }

    @Nonnull
    @NotNull
    public String getAttachmentName() {
        return this.record.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, IPeripheral> getAvailablePeripherals() {
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralHubPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Iterable $this$associate$iv = this.peripheralHubPeripheral.getPeripheralsRecord().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), (Object)((PeripheralRecord)it.getValue()).getPeripheral());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IPeripheral getAvailablePeripheral(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralHubPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            PeripheralRecord peripheralRecord;
            block4: {
                boolean bl = false;
                if ((PeripheralRecord)this.peripheralHubPeripheral.getPeripheralsRecord().get(name) != null) break block4;
                IPeripheral iPeripheral = null;
                return iPeripheral;
            }
            PeripheralRecord record = peripheralRecord;
            IPeripheral iPeripheral = record.getPeripheral();
            return iPeripheral;
        }
    }
}

